/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.debitoautomatico.remessa;

import br.com.elotech.tributos.domain.DebitoAutomaticoRemessaDetalhe;
import br.com.elotech.tributos.repository.DebitoAutomaticoRemessaDetalheRepository;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class RemessaArquivoDebitoAutomaticoWriter
implements ItemWriter<DebitoAutomaticoRemessaDetalhe> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemessaArquivoDebitoAutomaticoWriter.class);
    private final DebitoAutomaticoRemessaDetalheRepository debitoAutomaticoRemessaDetalheRepository;
    private StepExecution stepExecution;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends DebitoAutomaticoRemessaDetalhe> items) throws Exception {
        List<DebitoAutomaticoRemessaDetalhe> itensParaSalvar = items.stream().filter(item -> Boolean.FALSE.equals(item.getApagarRegistro())).toList();
        log.info("Salvando {} itens de detalhe de remessa de d\u00e9bito autom\u00e1tico.", (Object)itensParaSalvar.size());
        this.debitoAutomaticoRemessaDetalheRepository.saveAll(itensParaSalvar);
        List<DebitoAutomaticoRemessaDetalhe> itensParaRemover = items.stream().filter(item -> Boolean.TRUE.equals(item.getApagarRegistro())).toList();
        if (!itensParaRemover.isEmpty()) {
            log.info("Removendo {} itens de detalhe de remessa de d\u00e9bito autom\u00e1tico.", (Object)itensParaRemover.size());
            this.debitoAutomaticoRemessaDetalheRepository.deleteAll(itensParaRemover);
        }
    }

    @Generated
    public RemessaArquivoDebitoAutomaticoWriter(DebitoAutomaticoRemessaDetalheRepository debitoAutomaticoRemessaDetalheRepository) {
        this.debitoAutomaticoRemessaDetalheRepository = debitoAutomaticoRemessaDetalheRepository;
    }
}

