/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.debitoautomatico.remessa;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoAutomaticoRemessa;
import br.com.elotech.tributos.domain.DebitoAutomaticoRemessaDetalhe;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.dto.BloquetoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.debitoautomatico.DebitoAutomaticoRemessaItemDTO;
import br.com.elotech.tributos.repository.DebitoAutomaticoRemessaDetalheRepository;
import br.com.elotech.tributos.repository.DebitoAutomaticoRemessaRepository;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.ModeloBoletoService;
import br.com.elotech.tributos.service.exception.DebitoNotFoundException;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class RemessaArquivoDebitoAutomaticoProcessor
implements ItemProcessor<DebitoAutomaticoRemessaItemDTO, DebitoAutomaticoRemessaDetalhe> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemessaArquivoDebitoAutomaticoProcessor.class);
    private static String TIPO_SITUACAO_PARCELA_BAIXADO = "B";
    private final DebitoService debitoService;
    private final GeraBoletoService geraBoletoService;
    private final ModeloBoletoService modeloBoletoService;
    private final DebitoAutomaticoRemessaRepository debitoAutomaticoRemessaRepository;
    private final DebitoAutomaticoRemessaDetalheRepository debitoAutomaticoRemessaDetalheRepository;
    private DebitoAutomaticoRemessa remessa;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) throws JsonProcessingException {
        JobParameters jobParameters = stepExecution.getJobExecution().getJobParameters();
        Long idRemessa = jobParameters.getLong("idRemessa");
        this.remessa = (DebitoAutomaticoRemessa)this.debitoAutomaticoRemessaRepository.findOne((Object)idRemessa);
    }

    public DebitoAutomaticoRemessaDetalhe process(DebitoAutomaticoRemessaItemDTO item) {
        DebitoAutomaticoRemessaDetalhe detalhe;
        if (TIPO_SITUACAO_PARCELA_BAIXADO.equals(item.getTipoSituacaoParcela())) {
            log.info("Marcando registro para ser apagado. Item: {}", (Object)item);
            DebitoAutomaticoRemessaDetalhe detalhe2 = (DebitoAutomaticoRemessaDetalhe)this.debitoAutomaticoRemessaDetalheRepository.findOne((Object)item.getId());
            detalhe2.setApagarRegistro(Boolean.TRUE);
            return detalhe2;
        }
        log.info("Gerando boleto para d\u00e9bito autom\u00e1tico. Item: {}", (Object)item);
        BloquetoDTO bloquetoDTO = this.geraBoletoPorFormaPagamento(item.getIdDebito(), item.getParcela(), item.getDataVencimento(), item.getFormaPagamento(), item.getTipoFormaPagamento());
        if (Objects.isNull(item.getId())) {
            detalhe = new DebitoAutomaticoRemessaDetalhe();
            detalhe.setDebitoAutomaticoRemessa(this.remessa);
            detalhe.setEntidade(item.getEntidade());
            detalhe.setExercicio(item.getExercicio());
            detalhe.setTipoCadastro(item.getTipoCadastro());
            detalhe.setCadastroGeral(item.getCadastroGeral());
            detalhe.setDivida(item.getGuiaRecolhimento());
            detalhe.setSubDivida(item.getSubDivida());
            detalhe.setParcela(item.getParcela());
        } else {
            detalhe = (DebitoAutomaticoRemessaDetalhe)this.debitoAutomaticoRemessaDetalheRepository.findOne((Object)item.getId());
        }
        detalhe.setExercicioBloqueto(bloquetoDTO.getExercicioBloqueto());
        detalhe.setNumeroBloqueto(bloquetoDTO.getBloqueto());
        return detalhe;
    }

    private BloquetoDTO geraBoletoPorFormaPagamento(Long idDebito, Long parcela, LocalDate dataVencimento, Long formaPagamento, String tipoFormaPagamento) {
        ModeloBoleto modeloBoleto = this.modeloBoletoService.retornarConfiguracaoModeloBoletoSequencia();
        Debito debito = (Debito)this.debitoService.findById((Serializable)idDebito).orElseThrow(() -> new DebitoNotFoundException(idDebito));
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setTipoBoleto(TipoBloqueto.fromValue((String)tipoFormaPagamento));
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE_WEB);
        geraBoletoDTO.setImpressaoCarne(Boolean.FALSE);
        geraBoletoDTO.setUsuario("WEB");
        geraBoletoDTO.setDebitos(this.getDebitoParcelaDTOS(debito, parcela));
        geraBoletoDTO.setModeloBoleto(modeloBoleto);
        geraBoletoDTO.setDataReferencia(LocalDate.now());
        geraBoletoDTO.setDataVencimento(dataVencimento);
        geraBoletoDTO.setCalcularAcrescimos(Boolean.FALSE);
        return this.geraBoleto(geraBoletoDTO, formaPagamento);
    }

    private List<DebitoParcelaDTO> getDebitoParcelaDTOS(Debito debito, Long parcela) {
        return debito.getParcelas().stream().map(debitoParcela -> {
            DebitoParcelaDTO dto = new DebitoParcelaDTO();
            dto.setIdDebito(debito.getId());
            dto.setParcela(debitoParcela.getId().getParcela());
            return dto;
        }).filter(d -> Objects.isNull(parcela) || d.getParcela().compareTo(parcela) == 0).toList();
    }

    public BloquetoDTO geraBoleto(GeraBoletoDTO geraBoletoDTO, Long formaPagamento) {
        List boletosGerados = this.geraBoletoService.geraBoleto(geraBoletoDTO, formaPagamento, Boolean.valueOf(true));
        if (boletosGerados.isEmpty()) {
            throw new EloValidationException("N\u00e3o foi gerado nenhum boleto");
        }
        if (boletosGerados.size() > 1) {
            String idsBoletosGerados = boletosGerados.stream().map(Bloqueto::getId).map(Object::toString).collect(Collectors.joining(", "));
            throw new EloValidationException(String.format("Foram gerados mais de um boleto. Boletos gerados: %s.", idsBoletosGerados));
        }
        return boletosGerados.stream().findFirst().map(Bloqueto::toBloquetoDTO).orElse(null);
    }

    @Generated
    public RemessaArquivoDebitoAutomaticoProcessor(DebitoService debitoService, GeraBoletoService geraBoletoService, ModeloBoletoService modeloBoletoService, DebitoAutomaticoRemessaRepository debitoAutomaticoRemessaRepository, DebitoAutomaticoRemessaDetalheRepository debitoAutomaticoRemessaDetalheRepository) {
        this.debitoService = debitoService;
        this.geraBoletoService = geraBoletoService;
        this.modeloBoletoService = modeloBoletoService;
        this.debitoAutomaticoRemessaRepository = debitoAutomaticoRemessaRepository;
        this.debitoAutomaticoRemessaDetalheRepository = debitoAutomaticoRemessaDetalheRepository;
    }
}

