/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.debitoautomatico.remessa;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.service.NotificacaoService;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class RemessaArquivoDebitoAutomaticoJobListener
extends JobExecutionListenerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemessaArquivoDebitoAutomaticoJobListener.class);
    private final NotificacaoService notificacaoService;
    private static final String ID_NOTIFICACAO = "idNotificacao";

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long idRemessa = jobExecution.getJobParameters().getLong("idRemessa");
        Optional notificacaoId = this.notificacaoService.send(String.format("Iniciada gera\u00e7\u00e3o da remessa de D\u00e9bitos Autom\u00e1ticos %d.", idRemessa), null, jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long idRemessa = jobExecution.getJobParameters().getLong("idRemessa");
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send(String.format("Finalizada gera\u00e7\u00e3o da remessa de D\u00e9bitos Autom\u00e1ticos %d.", idRemessa), null, jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send(String.format("Ocorreu um erro na gera\u00e7\u00e3o da remessa de D\u00e9bitos Autom\u00e1ticos %d.", idRemessa), null, jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    @Generated
    public RemessaArquivoDebitoAutomaticoJobListener(NotificacaoService notificacaoService) {
        this.notificacaoService = notificacaoService;
    }
}

