/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.debitoautomatico.importacao;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoAutomaticoArquivoConfirmacao;
import br.com.elotech.tributos.dto.DebitoAutomaticoInconsistenciaDTO;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemA;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemB;
import br.com.elotech.tributos.dto.debitoautomatico.ArquivoDebitoAutomaticoItemDTO;
import br.com.elotech.tributos.enums.ArquivoDebitoAutomaticoItemTipo;
import br.com.elotech.tributos.enums.DebitoAutomaticoInconsistenciaEnum;
import br.com.elotech.tributos.repository.DebitoAutomaticoArquivoConfirmacaoRepository;
import br.com.elotech.tributos.repository.DebitoAutomaticoInconsistenciaDetalheRepository;
import br.com.elotech.tributos.repository.DebitoRepository;
import br.com.elotech.tributos.service.DebitoAutomaticoArquivoConfirmacaoService;
import br.com.elotech.tributos.util.FieldItem;
import br.com.elotech.tributos.util.FieldUtils;
import java.time.temporal.ChronoField;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class ImportacaoArquivoDebitoAutomaticoProcessor
implements ItemProcessor<ArquivoDebitoAutomaticoItemDTO, FieldItem> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoArquivoDebitoAutomaticoProcessor.class);
    private final DebitoRepository debitoRepository;
    private StepExecution stepExecution;
    private final DebitoAutomaticoInconsistenciaDetalheRepository debitoAutomaticoInconsistenciaDetalheRepository;
    private final DebitoAutomaticoArquivoConfirmacaoRepository debitoAutomaticoArquivoConfirmacaoRepository;
    private final DebitoAutomaticoArquivoConfirmacaoService debitoAutomaticoArquivoConfirmacaoService;
    private static final Long FORMA_PAGAMENTO_PARCELA = 1L;
    private static final Long FORMA_PAGAMENTO_COTA_UNICA = 2L;
    private static final Long FORMA_PAGAMENTO_SEGUNDA_COTA_UNICA = 3L;
    private static final String KEY_CODIGO_BANCO = "codigoBanco";
    private static final String KEY_CODIGO_CONVENIO = "codigoConvenio";
    private static final String KEY_NSA = "nsa";

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    private void preencheDebito(ADAItemB itemB, DebitoAutomaticoArquivoConfirmacao debitoAutomaticoArquivoConfirmacao) {
        Optional debito;
        String formaPagamentoToVerify = itemB.getIdentificacaoClienteEmpresa().substring(24, 25);
        if (Boolean.FALSE.equals(StringUtils.isNumeric((CharSequence)formaPagamentoToVerify)) || Boolean.FALSE.equals(this.isFormaPagamentoValida(Long.valueOf(Long.parseLong(formaPagamentoToVerify))))) {
            this.inserirOcorrenciaLinha(debitoAutomaticoArquivoConfirmacao, itemB, DebitoAutomaticoInconsistenciaEnum.FORMA_PAGAMENTO_INVALIDA);
            itemB.setRealizaImportacao(Boolean.FALSE);
            return;
        }
        Long cadastroGeral = Long.parseLong(itemB.getIdentificacaoClienteEmpresa().substring(0, 15));
        Long exercicio = Long.parseLong(itemB.getIdentificacaoClienteEmpresa().substring(15, 19));
        Long divida = Long.parseLong(itemB.getIdentificacaoClienteEmpresa().substring(19, 21));
        Long subdivida = Long.parseLong(itemB.getIdentificacaoClienteEmpresa().substring(21, 23));
        Long formaPagamento = Long.parseLong(itemB.getIdentificacaoClienteEmpresa().substring(24, 25));
        itemB.setFormaPagamento(formaPagamento);
        Long tipoCadastro = 3L;
        if (cadastroGeral >= 0L && cadastroGeral <= 999999L) {
            tipoCadastro = 2L;
        }
        if (cadastroGeral >= 1000000L && cadastroGeral <= 80000000L) {
            tipoCadastro = 1L;
        }
        if ((debito = this.debitoRepository.findByCompositeKey(Long.valueOf(1L), exercicio, tipoCadastro, cadastroGeral, divida, subdivida)).isPresent()) {
            itemB.setEntidade(((Debito)debito.get()).getEntidade());
            itemB.setExercicio(((Debito)debito.get()).getExercicio());
            itemB.setTipoCadastro(((Debito)debito.get()).getTipoCadastro());
            itemB.setCadastroGeral(((Debito)debito.get()).getCadastroGeralId());
            itemB.setGuiaRecolhimento(((Debito)debito.get()).getGuiaRecolhimento());
            itemB.setSubdivida(((Debito)debito.get()).getSubDivida());
            return;
        }
        tipoCadastro = Long.parseLong(itemB.getIdentificacaoClienteEmpresa().substring(0, 2));
        cadastroGeral = Long.parseLong(itemB.getIdentificacaoClienteEmpresa().substring(2, 14));
        exercicio = Long.parseLong(itemB.getIdentificacaoClienteEmpresa().substring(14, 18));
        divida = Long.parseLong(itemB.getIdentificacaoClienteEmpresa().substring(18, 21));
        subdivida = Long.parseLong(itemB.getIdentificacaoClienteEmpresa().substring(21, 24));
        formaPagamento = Long.parseLong(itemB.getIdentificacaoClienteEmpresa().substring(24, 25));
        itemB.setFormaPagamento(formaPagamento);
        debito = this.debitoRepository.findByCompositeKey(Long.valueOf(1L), exercicio, tipoCadastro, cadastroGeral, divida, subdivida);
        if (debito.isPresent()) {
            itemB.setEntidade(((Debito)debito.get()).getEntidade());
            itemB.setExercicio(((Debito)debito.get()).getExercicio());
            itemB.setTipoCadastro(((Debito)debito.get()).getTipoCadastro());
            itemB.setCadastroGeral(((Debito)debito.get()).getCadastroGeralId());
            itemB.setGuiaRecolhimento(((Debito)debito.get()).getGuiaRecolhimento());
            itemB.setSubdivida(((Debito)debito.get()).getSubDivida());
        }
        if (debito.isEmpty()) {
            this.inserirOcorrenciaLinha(debitoAutomaticoArquivoConfirmacao, itemB, DebitoAutomaticoInconsistenciaEnum.DEBITO_NAO_ENCONTRADO);
            itemB.setRealizaImportacao(Boolean.FALSE);
        }
    }

    public Set<Long> getFormasPagamento() {
        return Set.of(FORMA_PAGAMENTO_PARCELA, FORMA_PAGAMENTO_COTA_UNICA, FORMA_PAGAMENTO_SEGUNDA_COTA_UNICA);
    }

    public Boolean isFormaPagamentoValida(Long formaPagamento) {
        if (this.getFormasPagamento().contains(formaPagamento)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void inserirOcorrenciaLinha(DebitoAutomaticoArquivoConfirmacao debitoAutomaticoArquivoConfirmacao, ADAItemB itemB, DebitoAutomaticoInconsistenciaEnum debitoAutomaticoInconsistenciaEnum) {
        DebitoAutomaticoInconsistenciaDTO debitoAutomaticoInconsistenciaDTO = DebitoAutomaticoInconsistenciaDTO.builder().debitoAutomaticoArquivoConfirmacao(debitoAutomaticoArquivoConfirmacao).linha(this.buildLinha(itemB)).inconsistencia(debitoAutomaticoInconsistenciaEnum.getDescricao()).identificacaoBanco(itemB.getIdentificacaoClienteBanco()).identificacaoEmpresa(itemB.getIdentificacaoClienteEmpresaNativa()).banco(debitoAutomaticoArquivoConfirmacao.getCodigoBanco()).agencia(itemB.getAgenciaDebito()).dia(Long.valueOf(itemB.getDataOpcaoExclusao().getLong(ChronoField.DAY_OF_MONTH))).mes(Long.valueOf(itemB.getDataOpcaoExclusao().getLong(ChronoField.MONTH_OF_YEAR))).ano(Long.valueOf(itemB.getDataOpcaoExclusao().getLong(ChronoField.YEAR))).codigoMovimentacao(itemB.getCodigoMovimento()).build();
        this.debitoAutomaticoInconsistenciaDetalheRepository.save((Object)DebitoAutomaticoInconsistenciaDTO.toEntity((DebitoAutomaticoInconsistenciaDTO)debitoAutomaticoInconsistenciaDTO));
    }

    public String buildLinha(ADAItemB itemB) {
        return FieldUtils.getString((Object)itemB);
    }

    public void inserirTabelaImportacaArquivo(ADAItemA itemA) {
        DebitoAutomaticoArquivoConfirmacao debitoAutomaticoArquivoConfirmacao = new DebitoAutomaticoArquivoConfirmacao();
        debitoAutomaticoArquivoConfirmacao.setDataGeracao(itemA.getDataGeracao());
        debitoAutomaticoArquivoConfirmacao.setCodigoConvenio(itemA.getCodigoConvenio());
        debitoAutomaticoArquivoConfirmacao.setNomeEmpresa(itemA.getNomeEmpresa());
        debitoAutomaticoArquivoConfirmacao.setCodigoBanco(itemA.getCodigoBanco());
        debitoAutomaticoArquivoConfirmacao.setNomeBanco(itemA.getNomeBanco());
        debitoAutomaticoArquivoConfirmacao.setNsa(itemA.getNsa());
        debitoAutomaticoArquivoConfirmacao.setVersaoLayout(itemA.getVersaoLayout());
        this.debitoAutomaticoArquivoConfirmacaoRepository.save((Object)debitoAutomaticoArquivoConfirmacao);
    }

    public void verificarArquivoImportado(ADAItemA itemA) {
        if (Boolean.TRUE.equals(this.debitoAutomaticoArquivoConfirmacaoService.existsArquivoImportado(itemA.getCodigoConvenio(), itemA.getCodigoBanco(), itemA.getNsa()))) {
            throw new EloValidationException("Arquivo j\u00e1 importado");
        }
    }

    public FieldItem process(ArquivoDebitoAutomaticoItemDTO item) {
        if (ArquivoDebitoAutomaticoItemTipo.A.equals((Object)item.getTipo())) {
            ADAItemA itemA = (ADAItemA)item.getItem();
            this.verificarArquivoImportado(itemA);
            this.inserirTabelaImportacaArquivo(itemA);
            this.stepExecution.getExecutionContext().putLong(KEY_CODIGO_BANCO, itemA.getCodigoBanco().longValue());
            this.stepExecution.getExecutionContext().putString(KEY_CODIGO_CONVENIO, itemA.getCodigoConvenio());
            this.stepExecution.getExecutionContext().putLong(KEY_NSA, itemA.getNsa().longValue());
        }
        if (ArquivoDebitoAutomaticoItemTipo.B.equals((Object)item.getTipo())) {
            DebitoAutomaticoArquivoConfirmacao debitoAutomaticoArquivoConfirmacao = (DebitoAutomaticoArquivoConfirmacao)this.debitoAutomaticoArquivoConfirmacaoRepository.findByCodigoConvenioAndCodigoBancoAndNsa(this.stepExecution.getExecutionContext().getString(KEY_CODIGO_CONVENIO), Long.valueOf(this.stepExecution.getExecutionContext().getLong(KEY_CODIGO_BANCO)), Long.valueOf(this.stepExecution.getExecutionContext().getLong(KEY_NSA))).orElseThrow(() -> new EloValidationException("Arquivo de confirma\u00e7\u00e3o n\u00e3o encontrado"));
            ADAItemB itemB = (ADAItemB)item.getItem();
            itemB.setIdentificacaoClienteEmpresaNativa(itemB.getIdentificacaoClienteEmpresa());
            itemB.setIdentificacaoClienteEmpresa(StringUtils.leftPad((String)itemB.getIdentificacaoClienteEmpresa(), (int)25, (String)"0"));
            this.preencheDebito(itemB, debitoAutomaticoArquivoConfirmacao);
            return item.getItem();
        }
        return null;
    }

    @Generated
    public ImportacaoArquivoDebitoAutomaticoProcessor(DebitoRepository debitoRepository, DebitoAutomaticoInconsistenciaDetalheRepository debitoAutomaticoInconsistenciaDetalheRepository, DebitoAutomaticoArquivoConfirmacaoRepository debitoAutomaticoArquivoConfirmacaoRepository, DebitoAutomaticoArquivoConfirmacaoService debitoAutomaticoArquivoConfirmacaoService) {
        this.debitoRepository = debitoRepository;
        this.debitoAutomaticoInconsistenciaDetalheRepository = debitoAutomaticoInconsistenciaDetalheRepository;
        this.debitoAutomaticoArquivoConfirmacaoRepository = debitoAutomaticoArquivoConfirmacaoRepository;
        this.debitoAutomaticoArquivoConfirmacaoService = debitoAutomaticoArquivoConfirmacaoService;
    }
}

