/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.createlivrodividaativa;

import br.com.elotech.tributos.dto.dividaativa.FiltroGeraLivroDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcPagingItemReader;
import org.springframework.batch.item.database.support.SqlPagingQueryProviderFactoryBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class LivroDividaAtivaBatchReader
extends JdbcPagingItemReader<Long> {
    public LivroDividaAtivaBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource, ObjectMapper objectMapper) throws Exception {
        this.setFetchSize(10);
        this.setName("geracaoLivroDividaAtivaDebitoId");
        this.setDataSource(dataSource);
        this.setRowMapper((rs, rowNum) -> rs.getLong("idDebito"));
        this.setQueryProvider(this.queryProvider(jobParameters, objectMapper, dataSource).getObject());
    }

    private SqlPagingQueryProviderFactoryBean queryProvider(Map<String, Object> jobParameters, ObjectMapper objectMapper, DataSource dataSource) throws IOException {
        SqlPagingQueryProviderFactoryBean provider = new SqlPagingQueryProviderFactoryBean();
        FiltroGeraLivroDTO filtroGeraLivroDTO = (FiltroGeraLivroDTO)objectMapper.readValue((String)jobParameters.get("filtro"), FiltroGeraLivroDTO.class);
        Boolean inscricaoPorParcela = jobParameters.get("inscricaoPorParcela").equals("P");
        Long entidade = (Long)jobParameters.get("entidade");
        provider.setDataSource(dataSource);
        provider.setSelectClause("SELECT DISTINCT IDDEBITO");
        provider.setFromClause("FROM TRIBDEBITO TD JOIN TRIBDEBITOPARCELA TDP  ON TD.ENTIDADE = TDP.ENTIDADE AND TD.EXERCICIO = TDP.EXERCICIO AND TD.TIPOCADASTRO = TDP.TIPOCADASTRO AND TD.CADASTROGERAL = TDP.CADASTROGERAL AND TD.GUIARECOLHIMENTO = TDP.GUIARECOLHIMENTO AND TD.SUBDIVIDA = TDP.SUBDIVIDA JOIN TRIBDEBITOPARCELARECEITA TDPR  ON TDP.ENTIDADE = TDPR.ENTIDADE AND TDP.EXERCICIO = TDPR.EXERCICIO AND TDP.TIPOCADASTRO = TDPR.TIPOCADASTRO AND TDP.CADASTROGERAL = TDPR.CADASTROGERAL AND TDP.GUIARECOLHIMENTO = TDPR.GUIARECOLHIMENTO AND TDP.SUBDIVIDA = TDPR.SUBDIVIDA AND TDP.PARCELA = TDPR.PARCELA JOIN TRIBCADASTROGERAL TCG  ON TCG.TIPOCADASTRO = TD.TIPOCADASTRO AND TCG.CADASTROGERAL = TD.CADASTROGERAL JOIN PESSOA PES  ON TCG.PESSOA = PES.PESSOA JOIN TRIBSITUACAOPARCELA TSP  ON TSP.SITUACAOPARCELA = TDP.SITUACAODEBITO JOIN TRIBTIPOSITUACAOPARCELA TTSP  ON TSP.TIPOSITUACAOPARCELA = TTSP.TIPOSITUACAOPARCELA JOIN TRIBGUIARECOLHIMENTO TGR  ON TD.ENTIDADE = TGR.ENTIDADE AND TD.EXERCICIO = TGR.EXERCICIO AND TD.GUIARECOLHIMENTO = TGR.GUIARECOLHIMENTO ");
        provider.setWhereClause(String.format("WHERE TD.ENTIDADE = %d   AND TD.CONSTITUIDO = 'S'   AND TDP.LIVRO IS NULL   AND COALESCE(TCG.EXCLUSAOLOGICA,'N') = 'N'   AND TDPR.VALOR > 0   AND TDP.DATAVENCIMENTO < CURRENT_DATE   AND TTSP.TIPO = 'A' %s", entidade, filtroGeraLivroDTO.getFiltro(inscricaoPorParcela)));
        provider.setSortKey("iddebito");
        return provider;
    }
}

