/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.createlivrodividaativa;

import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.Livro;
import br.com.elotech.tributos.domain.LivroRegistro;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.dividaativa.FiltroGeraLivroDTO;
import br.com.elotech.tributos.dto.dividaativa.GeraLivroDebitoParcelaTributoDTO;
import br.com.elotech.tributos.dto.dividaativa.LivroExistenteSequenciadoresDTO;
import br.com.elotech.tributos.repository.GeraLivroRepository;
import br.com.elotech.tributos.service.GeraLivroDividaAtivaService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class LivroDividaAtivaBatchProcessor
implements ItemProcessor<Long, Map<LivroRegistro, List<GeraLivroDebitoParcelaTributoDTO>>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LivroDividaAtivaBatchProcessor.class);
    private final GeraLivroDividaAtivaService geraLivroDividaAtivaService;
    private final GeraLivroRepository geraLivroRepository;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private StepExecution stepExecution;
    private ListasNecessariasCalculaAcrescimoDTO listasNecessariasCalculaAcrescimoDTO;

    public LivroDividaAtivaBatchProcessor(GeraLivroDividaAtivaService geraLivroDividaAtivaService, GeraLivroRepository geraLivroRepository, CalculoAcrescimoService calculoAcrescimoService) {
        this.geraLivroDividaAtivaService = geraLivroDividaAtivaService;
        this.geraLivroRepository = geraLivroRepository;
        this.calculoAcrescimoService = calculoAcrescimoService;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    private void initializeListasNecessarias() {
        if (Objects.isNull(this.listasNecessariasCalculaAcrescimoDTO)) {
            this.listasNecessariasCalculaAcrescimoDTO = this.calculoAcrescimoService.createNecessariasCalculaAcrescimo();
        }
    }

    public Map<LivroRegistro, List<GeraLivroDebitoParcelaTributoDTO>> process(Long idDebito) {
        LOGGER.info("Read Count: {}. idDebito: {}. Job ID {}.", new Object[]{this.stepExecution.getReadCount(), idDebito, this.stepExecution.getJobExecution().getId()});
        ExecutionContext executionContext = this.stepExecution.getJobExecution().getExecutionContext();
        Livro livro = (Livro)executionContext.get("livro");
        LOGGER.info("Livro {}", (Object)livro.getId().getLivro());
        FiltroGeraLivroDTO filtro = (FiltroGeraLivroDTO)executionContext.get("filtro");
        Boolean inscricaoPorParcela = (Boolean)executionContext.get("inscricaoPorParcela");
        Boolean englobaDebitos = (Boolean)executionContext.get("englobaDebitos");
        FormaPagamento formaPagamentoPadrao = (FormaPagamento)executionContext.get("formaPagamentoPadrao");
        LocalDate dataInscricao = (LocalDate)executionContext.get("dataInscricao");
        this.initializeListasNecessarias();
        ListasNecessariasCalculaAcrescimoDTO lNCADTO = this.listasNecessariasCalculaAcrescimoDTO;
        List parcelaTributos = this.geraLivroDividaAtivaService.getParcelaTributos(idDebito, filtro, inscricaoPorParcela.booleanValue());
        this.geraLivroDividaAtivaService.calculaAcrescimo(parcelaTributos, englobaDebitos, dataInscricao, formaPagamentoPadrao, lNCADTO);
        LivroExistenteSequenciadoresDTO sequenciadores = this.geraLivroRepository.getLastLivroExistenteSequenciadores(livro.getId());
        LOGGER.info("Read Count: {}. ", (Object)this.stepExecution.getReadCount());
        return this.geraLivroDividaAtivaService.getParcelasParaAtualizar(inscricaoPorParcela.booleanValue(), livro, parcelaTributos, sequenciadores, filtro, formaPagamentoPadrao);
    }
}

