/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.contenciosorecalculo;

import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.domain.CalculoInconsistencia;
import br.com.elotech.tributos.calculo.domain.CalculoResultado;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoRoot;
import br.com.elotech.tributos.calculo.dto.CalculoBuildDTO;
import br.com.elotech.tributos.calculo.repository.CalculoTributoRepository;
import br.com.elotech.tributos.calculo.service.CalculoContenciosoRecalculoService;
import br.com.elotech.tributos.calculo.service.CalculoService;
import br.com.elotech.tributos.calculo.service.CalculoTabelaValores;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ContenciosoDebito;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.calculo.CalculoConfigBase;
import br.com.elotech.tributos.domain.calculo.CalculoTributo;
import br.com.elotech.tributos.dto.contencioso.ContenciosoRecalculoDebitoDTO;
import br.com.elotech.tributos.enums.SituacaoRecalculoContencioso;
import br.com.elotech.tributos.enums.TipoRecalculoContencioso;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.DividaService;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ContenciosoRecalculoProcessor
implements ItemProcessor<ContenciosoDebito, ContenciosoDebito> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContenciosoRecalculoProcessor.class);
    private static final Long UM_MES = 1L;
    private final CalculoService calculoService;
    private final CalculoContenciosoRecalculoService calculoContenciosoRecalculoService;
    private final CalculoTributoRepository calculoTributoRepository;
    private final DebitoService debitoService;
    private final DividaService dividaService;
    private final ContextService contextService;
    private StepExecution stepExecution;
    private ObjectMapper objectMapper;
    private Long exercicioCalculo;
    private Long idDivida;
    private Divida divida;
    private List<ContenciosoRecalculoDebitoDTO> debitosParaRecalculo;
    private CalculoTabelaValores calculoTabelaValores;
    private List<CalculoTributo> formulas;
    private LocalDateTime dataRecalculo;

    public ContenciosoRecalculoProcessor(CalculoService calculoService, CalculoContenciosoRecalculoService calculoContenciosoRecalculoService, CalculoTributoRepository calculoTributoRepository, DebitoService debitoService, DividaService dividaService, ContextService contextService, ObjectMapper objectMapper) {
        this.calculoService = calculoService;
        this.calculoContenciosoRecalculoService = calculoContenciosoRecalculoService;
        this.calculoTributoRepository = calculoTributoRepository;
        this.debitoService = debitoService;
        this.dividaService = dividaService;
        this.contextService = contextService;
        this.objectMapper = objectMapper;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) throws JsonProcessingException {
        this.stepExecution = stepExecution;
        this.dataRecalculo = DateUtils.dateToLocalDateTime((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("data")));
        CollectionType type = this.objectMapper.getTypeFactory().constructCollectionType(List.class, ContenciosoRecalculoDebitoDTO.class);
        this.debitosParaRecalculo = Objects.requireNonNull((List)this.objectMapper.readValue(this.stepExecution.getJobExecution().getJobParameters().getString("debitos"), (JavaType)type));
        this.idDivida = this.stepExecution.getJobExecution().getJobParameters().getLong("idDivida");
    }

    private void loadFormulas(Long exercicio, Long idDivida) {
        this.loadCalculoTabelaValores(exercicio);
        this.formulas = this.calculoTributoRepository.findByDividasAndExercicioJoinFetchScript(Collections.singletonList(idDivida), exercicio);
        for (CalculoTributo tributo : this.formulas) {
            CalculoBuildDTO calculoBuildDTO = this.calculoContenciosoRecalculoService.getFormulaCompilada((CalculoConfigBase)tributo, Boolean.FALSE);
            tributo.setCalculoBuildDTO(calculoBuildDTO);
        }
    }

    private void loadCalculoTabelaValores(Long exercicio) {
        if (Objects.nonNull(this.calculoTabelaValores)) {
            return;
        }
        this.calculoTabelaValores = this.calculoService.loadCalculoTabelaValores(exercicio);
    }

    public ContenciosoDebito process(ContenciosoDebito contenciosoDebito) throws JsonProcessingException {
        ContenciosoRecalculoDebitoDTO dto;
        if (Objects.isNull(this.divida)) {
            this.dividaService.findById((Serializable)this.idDivida).ifPresent(arg_0 -> this.setDivida(arg_0));
        }
        if (Objects.isNull(this.exercicioCalculo) || !Objects.equals(contenciosoDebito.getId().getExercicio(), this.exercicioCalculo)) {
            this.setExercicioCalculo(contenciosoDebito.getId().getExercicio());
        }
        if (Objects.nonNull(this.divida) && !Objects.equals(this.divida.getExercicio(), this.exercicioCalculo)) {
            this.dividaService.findByEntidadeAndExercicioAndDivida(this.divida.getEntidade(), this.exercicioCalculo, this.divida.getDivida()).ifPresent(arg_0 -> this.setDivida(arg_0));
        }
        if (Objects.nonNull(this.divida)) {
            this.loadFormulas(this.exercicioCalculo, this.divida.getId());
        }
        if (Objects.isNull(dto = (ContenciosoRecalculoDebitoDTO)this.debitosParaRecalculo.stream().filter(contenciosoRecalculoDebitoDTO -> contenciosoDebito.getId().equals((Object)contenciosoRecalculoDebitoDTO.getId())).findFirst().orElse(null))) {
            return null;
        }
        contenciosoDebito.setDataRecalculo(this.dataRecalculo);
        contenciosoDebito.setDataPrimeiroVencimento(dto.getDataPrimeiroVencimento());
        contenciosoDebito.setSituacaoRecalculo(SituacaoRecalculoContencioso.fromTipoRecalculo((TipoRecalculoContencioso)dto.getTipo()));
        String filtro = String.format("cadastrogeral.tipocadastro = %d and cadastrogeral.cadastrogeral = %d", contenciosoDebito.getId().getTipoCadastro().getValue(), contenciosoDebito.getId().getCadastroGeral());
        if (Objects.nonNull(contenciosoDebito.getIdMemoriaCadastro())) {
            filtro = filtro.concat(" and cadastrogeral.idmemoriacadastro = " + contenciosoDebito.getIdMemoriaCadastro());
        }
        List roots = this.calculoContenciosoRecalculoService.calcularSemCompilarFormulas(this.formulas, this.exercicioCalculo, filtro, LocalDate.now(), this.calculoTabelaValores);
        CalculoCadastro cc = CalculoCadastro.from((CadastroCalculoRoot)((CadastroCalculoRoot)roots.get(0)));
        cc.setDivida(this.divida);
        contenciosoDebito.setInconsistencias(null);
        if (!cc.getInconsistencias().isEmpty()) {
            contenciosoDebito.setInconsistencias(cc.getInconsistencias().stream().map(CalculoInconsistencia::getDescricao).collect(Collectors.joining("\n")));
        }
        BigDecimal valorDescontos = cc.getResultados().stream().map(CalculoResultado::getValorDeducoes).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal valorRecalculo = cc.getResultados().stream().map(CalculoResultado::getValor).reduce(BigDecimal.ZERO, BigDecimal::add).subtract(valorDescontos).setScale(2, RoundingMode.HALF_EVEN);
        contenciosoDebito.setValorRecalculo(valorRecalculo);
        if (SituacaoRecalculoContencioso.DEBITO_GERADO.equals((Object)contenciosoDebito.getSituacaoRecalculo())) {
            Optional.ofNullable(contenciosoDebito.getDebito()).map(Debito::getCadastroGeral).map(CadastroGeral::getId).ifPresent(arg_0 -> ((CadastroGeral)cc.getCadastro()).setId(arg_0));
            cc.setCalculo(new Calculo());
            cc.getCalculo().setExercicio(this.exercicioCalculo);
            cc.getCalculo().setDataLancamento(this.dataRecalculo.toLocalDate());
            cc = this.calculoService.gerarDebitoCadastroConsistente(cc, this.contextService.getEntidadePrincipal(), null);
            this.alterarDataDeVencimento(contenciosoDebito.getId().getIdContencioso(), cc.getDebito(), dto.getDataPrimeiroVencimento());
            contenciosoDebito.setDebitoRecalculo(cc.getDebito());
        }
        return contenciosoDebito;
    }

    private Debito alterarDataDeVencimento(Long idContencioso, Debito debito, LocalDate dataPrimeiroVencimento) {
        LocalDate vencimento = dataPrimeiroVencimento;
        List parcelas = debito.getParcelas().stream().sorted(Comparator.comparing(DebitoParcela::getDataVencimento)).collect(Collectors.toList());
        for (DebitoParcela debitoParcela : parcelas) {
            debitoParcela.setDataVencimento(vencimento);
            vencimento = vencimento.plusMonths(UM_MES);
        }
        debito.setIdContenciosoOrigem(idContencioso);
        debito.setConstituido(Boolean.TRUE);
        return this.debitoService.save(debito);
    }

    @Generated
    public void setExercicioCalculo(Long exercicioCalculo) {
        this.exercicioCalculo = exercicioCalculo;
    }

    @Generated
    public void setDivida(Divida divida) {
        this.divida = divida;
    }
}

