/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.contenciosorecalculo;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.dto.CarneDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoRecalculoGerarBoletoBatchDTO;
import br.com.elotech.tributos.service.CarneService;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;

@StepScope
@Component
public class ContenciosoRecalculoBoletoWriter
implements ItemWriter<ContenciosoRecalculoGerarBoletoBatchDTO> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContenciosoRecalculoBoletoWriter.class);
    private final AisePdfService aisePdfService;
    private final CarneService carneService;
    @Autowired
    private PlatformTransactionManager transactionManager;
    private Map<String, byte[]> arquivos = new HashMap();
    private StepExecution stepExecution;
    private Boolean gerarCarne = Boolean.FALSE;
    private Path tempFile;

    public ContenciosoRecalculoBoletoWriter(AisePdfService aisePdfService, CarneService carneService) {
        this.aisePdfService = aisePdfService;
        this.carneService = carneService;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) throws IOException {
        this.stepExecution = stepExecution;
        this.gerarCarne = Boolean.parseBoolean(Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getString("gerarCarne")));
        String nomeArquivo = stepExecution.getJobParameters().getString("nomeArquivo");
        if (!this.stepExecution.getJobExecution().getExecutionContext().containsKey("tempFile")) {
            this.tempFile = Files.createTempFile(nomeArquivo, ".zip", new FileAttribute[0]);
            this.stepExecution.getJobExecution().getExecutionContext().put("tempFile", (Object)this.tempFile.toString());
        }
    }

    private void doInTransaction(Runnable runnable) {
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionAttribute(3));
        runnable.run();
        this.transactionManager.commit(transaction);
    }

    public void write(List<? extends ContenciosoRecalculoGerarBoletoBatchDTO> items) throws IOException {
        LOGGER.info("Salvando os arquivos gerados no zip. Read count {}. Job Id {}.", (Object)this.stepExecution.getReadCount(), (Object)this.stepExecution.getJobExecution().getId());
        this.arquivos.clear();
        for (ContenciosoRecalculoGerarBoletoBatchDTO contenciosoRecalculoGerarBoletoBatchDTO : items) {
            if (Boolean.TRUE.equals(this.gerarCarne)) {
                AtomicReference carneDTO = new AtomicReference();
                this.doInTransaction(() -> carneDTO.set(this.carneService.geraCarneWithoutTransaction(dto.getDebitoCarneDTO())));
                ImpressaoDTO impressaoDTO = ImpressaoDTO.from((String)this.aisePdfService.fetchCarne(((CarneDTO)carneDTO.get()).getNumeroCarne()));
                LOGGER.info("Url de gera\u00e7\u00e3o de carn\u00ea: {}", (Object)impressaoDTO.getUrl());
                this.arquivos.put(String.format("%d.pdf", contenciosoRecalculoGerarBoletoBatchDTO.getDebitoCarneDTO().getCadastroGeral()), this.getPDFBytes(impressaoDTO));
                continue;
            }
            try (PDDocument pdf = new PDDocument();){
                for (Bloqueto bloqueto : contenciosoRecalculoGerarBoletoBatchDTO.getBloquetos()) {
                    ImpressaoDTO impressaoDTO = ImpressaoDTO.from((String)this.aisePdfService.fetchBloquetoByExercicio(bloqueto.getBloqueto(), bloqueto.getExercicioBloqueto()));
                    this.mergeInfoToDocument(pdf, this.getPDFBytes(impressaoDTO));
                }
                InputStream fileStream = this.saveDocument(pdf);
                try {
                    this.arquivos.put(String.format("%d.pdf", ((Bloqueto)contenciosoRecalculoGerarBoletoBatchDTO.getBloquetos().get(0)).getCadastroGeral().getCadastroGeral()), fileStream.readAllBytes());
                }
                finally {
                    if (fileStream == null) continue;
                    fileStream.close();
                }
            }
        }
        FileUtils.addFilesToExistingZip((Path)this.tempFile, (Map)this.arquivos);
    }

    private byte[] getPDFBytes(ImpressaoDTO dto) throws IOException {
        try (InputStream inputStream = new URL(dto.getUrl()).openStream();){
            byte[] byArray = inputStream.readAllBytes();
            return byArray;
        }
    }

    private InputStream saveDocument(PDDocument document) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            document.save((OutputStream)byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    private void appendInfoToDocument(PDDocument document, PDFMergerUtility pdfMerge, byte[] info) throws IOException {
        PDDocument pdfDocument = PDDocument.load((byte[])info);
        pdfMerge.appendDocument(document, pdfDocument);
        pdfDocument.close();
    }

    private void mergeInfoToDocument(PDDocument document, byte[] infoToAppendDocumento) throws IOException {
        try {
            PDFMergerUtility pdfMerge = new PDFMergerUtility();
            this.appendInfoToDocument(document, pdfMerge, infoToAppendDocumento);
        }
        catch (Exception ex) {
            throw new IOException(String.format("Erro ao juntar documentos. %s", ex.getMessage()));
        }
    }
}

