/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.consultadebito;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ConsultaDebitoBatchReader
extends JdbcCursorItemReader<Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsultaDebitoBatchReader.class);
    private static final String SQL_FIND_DEBITOS_CONSTITUIDOS = "br/com/elotech/tributos/repository/find-debito-constituido.sql";

    public ConsultaDebitoBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource, ObjectMapper objectMapper) throws IOException {
        this.setFetchSize(10);
        this.setName("debitoConsultaId");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(Boolean.FALSE.booleanValue());
        this.setRowMapper((rs, rowNum) -> rs.getLong("idDebito"));
        this.setSql(Objects.requireNonNull(this.buildQuery(jobParameters, objectMapper)));
    }

    private String buildQuery(Map<String, Object> jobParameters, ObjectMapper objectMapper) throws IOException {
        FiltroConsultaDebitoDTO filtro = (FiltroConsultaDebitoDTO)objectMapper.readValue((String)jobParameters.get("filtro"), FiltroConsultaDebitoDTO.class);
        String select = "SELECT IDDEBITO ";
        String fromTemplate = FileUtils.readResourceAsString((String)SQL_FIND_DEBITOS_CONSTITUIDOS);
        String query = String.format(fromTemplate, select, filtro.generateJoins(), filtro.generateWhereWithCte(), filtro.buildGroupBy());
        if (filtro.utilizaCte()) {
            query = filtro.buildCte(fromTemplate).concat(query);
        }
        log.debug("ConsultaDebitoBatchReader - SQL utilizado no reader da consulta de d\u00e9bitos: {}", (Object)query);
        return query;
    }
}

