/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.comunicado.simulacaocalculo;

import br.com.elotech.tributos.dto.BooleanSimNao;
import br.com.elotech.tributos.dto.ComunicadoSimulacaoCalculoDTO;
import java.time.LocalDate;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JpaPagingItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ComunicadoSimulacaoCalculoBatchReader
extends JpaPagingItemReader<ComunicadoSimulacaoCalculoDTO> {
    private static final String ID_CALCULO = "idCalculo";
    private static final String SELECT = " select new br.com.elotech.tributos.dto.ComunicadoSimulacaoCalculoDTO( calc.id as calculoId, tcg.tipoCadastro, tcg.cadastroGeral, tcg.id, tcg.pessoa, p.nome as nomePessoa, sum(res.valor) as valor) from Calculo calc join calc.cadastros calcad join calcad.resultados res left join calcad.cadastro tcg left join tcg.pessoa p where calc.id = :idConsulta";
    private static final String ANDVALIDACAODUPLICADO = " and not exists ( select 1 from Comunicado tc join tc.cadastros tcc join tcc.cadastroGeral tcg2 where tcg.id = tcg2.id and tc.dataValidade >= :dataReferencia)";
    private static final String SQLGROUPBY = " group by calc.id, tcg.tipoCadastro, tcg.cadastroGeral, tcg.id, tcg.pessoa, p.nome";

    public ComunicadoSimulacaoCalculoBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, EntityManagerFactory entityManagerFactory) {
        Map<String, Comparable<Long>> params;
        Long idConsulta = (Long)jobParameters.get(ID_CALCULO);
        this.setPageSize(500);
        this.setName(ID_CALCULO);
        this.setEntityManagerFactory(entityManagerFactory);
        BooleanSimNao validacaoComunicadoDuplicado = BooleanSimNao.fromValue((String)((String)jobParameters.get("VALIDACOMUNICADODUPLICADO")));
        StringBuilder sql = new StringBuilder(SELECT);
        if (BooleanSimNao.SIM.equals((Object)validacaoComunicadoDuplicado)) {
            sql.append(ANDVALIDACAODUPLICADO);
            params = Map.of("idConsulta", idConsulta, "dataReferencia", LocalDate.now());
        } else {
            params = Map.of("idConsulta", idConsulta);
        }
        sql.append(SQLGROUPBY);
        this.setQueryString(sql.toString());
        this.setParameterValues(params);
    }
}

