/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cenprotms.gerarprotesto;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.dto.cenprot.GerarProtestoCenprotMSDTO;
import br.com.elotech.tributos.service.cenprotms.CenprotMSValidationService;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.stereotype.Service;

@Service
public class GerarProtestoCenprotMSJobStarter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GerarProtestoCenprotMSJobStarter.class);
    private final JobLauncher jobLauncher;
    private final Job gerarProtestoCenprotMSBatchJob;
    private final JobExplorer jobExplorer;
    private final CenprotMSValidationService validationService;

    public void startJob(GerarProtestoCenprotMSDTO dto) {
        log.info("Iniciando job de envio CENPROTMS para {} protestos", (Object)dto.getIdsProtesto().size());
        this.validationService.validarCenprotMSDisponivel();
        String idsProtestoString = dto.getIdsProtesto().stream().map(String::valueOf).collect(Collectors.joining(","));
        this.validateJobRunningWith(idsProtestoString);
        try {
            JobParameters jobParameters = new JobParametersBuilder().addString("idsProtesto", idsProtestoString).addString("dataExecucao", LocalDateTime.now().toString()).toJobParameters();
            this.jobLauncher.run(this.gerarProtestoCenprotMSBatchJob, jobParameters);
            log.info("Job CENPROTMS iniciado com sucesso");
        }
        catch (Exception e) {
            log.error("Erro ao iniciar job CENPROTMS", (Throwable)e);
            throw new EloValidationException("Erro ao iniciar job de envio CENPROTMS. " + e.getMessage());
        }
    }

    private void validateJobRunningWith(String idsProtestoString) {
        boolean hasJobRunning = this.jobExplorer.findRunningJobExecutions(JobType.GERAR_PROTESTO_CENPROTMS.getTipo()).stream().anyMatch(jobExecution -> Objects.equals(idsProtestoString, jobExecution.getJobParameters().getString("idsProtesto")));
        if (hasJobRunning) {
            throw new EloValidationException("J\u00e1 existe um job de envio CENPROTMS em execu\u00e7\u00e3o para os protestos selecionados.");
        }
    }

    @Generated
    public GerarProtestoCenprotMSJobStarter(JobLauncher jobLauncher, Job gerarProtestoCenprotMSBatchJob, JobExplorer jobExplorer, CenprotMSValidationService validationService) {
        this.jobLauncher = jobLauncher;
        this.gerarProtestoCenprotMSBatchJob = gerarProtestoCenprotMSBatchJob;
        this.jobExplorer = jobExplorer;
        this.validationService = validationService;
    }
}

