/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cenprotms.gerarprotesto;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.service.NotificacaoService;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.StepExecution;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class GerarProtestoCenprotMSJobListener
implements JobExecutionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GerarProtestoCenprotMSJobListener.class);
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;

    public void beforeJob(@Nullable JobExecution jobExecution) {
        if (Objects.isNull(jobExecution)) {
            return;
        }
        String idsProtesto = jobExecution.getJobParameters().getString("idsProtesto");
        String dataInicio = LocalDate.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        log.info("Iniciando job de envio CENPROTMS - IDs: {}", (Object)idsProtesto);
        String title = "CENPROTMS - Iniciado Envio de Protestos";
        String detail = String.format("Iniciado o processo de envio de protestos para o CENPROTMS - %s", dataInicio);
        Optional notificacaoId = this.notificacaoService.send(title, detail, jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(@Nullable JobExecution jobExecution) {
        if (Objects.isNull(jobExecution)) {
            return;
        }
        String dataFim = LocalDate.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        String idNotificacaoStr = jobExecution.getExecutionContext().getString(ID_NOTIFICACAO);
        UUID notificacaoId = UUID.fromString(idNotificacaoStr);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.enviarNotificacaoSucesso(jobExecution, notificacaoId, dataFim);
            return;
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.enviarNotificacaoErro(jobExecution, notificacaoId, dataFim);
        }
    }

    private void enviarNotificacaoSucesso(JobExecution jobExecution, UUID notificacaoId, String dataFim) {
        StepExecution stepExecution = (StepExecution)jobExecution.getStepExecutions().iterator().next();
        String title = "CENPROTMS - Envio de Protestos Conclu\u00eddo";
        String detail = String.format("Finalizado com sucesso o envio de protestos para o CENPROTMS - %s. Lidos: %d, Enviados: %d, Erros: %d", dataFim, stepExecution.getReadCount(), stepExecution.getWriteCount(), stepExecution.getSkipCount());
        this.notificacaoService.send(title, detail, jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        log.info("Job de envio CENPROTMS conclu\u00eddo com sucesso - JobId: {}, Lidos: {}, Enviados: {}, Erros: {}", new Object[]{jobExecution.getId(), stepExecution.getReadCount(), stepExecution.getWriteCount(), stepExecution.getSkipCount()});
    }

    private void enviarNotificacaoErro(JobExecution jobExecution, UUID notificacaoId, String dataFim) {
        String title = "CENPROTMS - Erro no Envio de Protestos";
        String detail = String.format("Ocorreu um erro ao enviar protestos para o CENPROTMS - %s", dataFim);
        this.notificacaoService.send(title, detail, jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        log.error("Job de envio CENPROTMS falhou - JobId: {}, Status: {}", (Object)jobExecution.getId(), (Object)jobExecution.getStatus());
    }

    @Generated
    public GerarProtestoCenprotMSJobListener(NotificacaoService notificacaoService) {
        this.notificacaoService = notificacaoService;
    }
}

