/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cenprotms.gerarprotesto;

import br.com.elotech.tributos.dto.cenprot.CenprotMSRetornoDTO;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class GerarProtestoCenprotMSBatchWriter
implements ItemWriter<CenprotMSRetornoDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GerarProtestoCenprotMSBatchWriter.class);

    public void write(List<? extends CenprotMSRetornoDTO> items) throws Exception {
        log.debug("Gravando resultado de {} envios ao CENPROTMS", (Object)items.size());
        long sucessos = items.stream().mapToLong(item -> item.isSucesso() ? 1L : 0L).sum();
        long erros = (long)items.size() - sucessos;
        log.info("Batch CENPROTMS - Sucessos: {}, Erros: {}", (Object)sucessos, (Object)erros);
        items.stream().filter(item -> !item.isSucesso()).forEach(item -> log.error("Erro no envio: {} - {}", (Object)item.getTitulo(), (Object)item.getMensagem()));
    }

    @Generated
    public GerarProtestoCenprotMSBatchWriter() {
    }
}

