/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cenprotms.gerarprotesto;

import br.com.elotech.tributos.batch.cenprotms.CenprotMSStepProvider;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.cenprot.CenprotMSRetornoDTO;
import br.com.elotech.tributos.enums.cenprot.ProcessorType;
import br.com.elotech.tributos.integration.cenprotms.generated.EnviarTituloRequestData;
import br.com.elotech.tributos.integration.cenprotms.generated.EnviarTituloResponseData;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.cenprotms.CenprotMSValidationService;
import br.com.elotech.tributos.service.cenprotms.auth.CenprotMSAuthService;
import br.com.elotech.tributos.service.cenprotms.processor.CenprotMSResponseProcessor;
import br.com.elotech.tributos.service.cenprotms.processor.CenprotMSResponseProcessorFactory;
import br.com.elotech.tributos.util.cenprot.CenprotMSTituloMapper;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterStep;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class GerarProtestoCenprotMSBatchProcessor
implements ItemProcessor<Protesto, CenprotMSRetornoDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GerarProtestoCenprotMSBatchProcessor.class);
    private final CenprotMSStepProvider cenprotProvider;
    private final CenprotMSAuthService authService;
    private final CenprotMSValidationService validationService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final CenprotMSResponseProcessorFactory processorFactory;
    private final CenprotMSTituloMapper tituloMapper;
    private ListasNecessariasCalculaAcrescimoDTO listasCache;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        log.info("Inicializando step de envio ao CENPROTMS");
        this.listasCache = this.calculoAcrescimoService.createNecessariasCalculaAcrescimo();
        this.cenprotProvider.inicializar();
        log.info("Step inicializado com sucesso");
    }

    @AfterStep
    public void afterStep(StepExecution stepExecution) {
        log.info("Finalizando step de envio ao CENPROTMS");
        this.cenprotProvider.limpar();
    }

    public CenprotMSRetornoDTO process(@Nullable Protesto protesto) {
        try {
            Objects.requireNonNull(protesto, "Protesto n\u00e3o pode ser nulo");
            this.validationService.validarProtestoParaEnvio(protesto);
            log.debug("Processando protesto {} para envio ao CENPROTMS", (Object)protesto.getId());
            String token = this.authService.obterTokenValido(this.cenprotProvider.getClient(), this.cenprotProvider.getTokenManager());
            EnviarTituloRequestData request = this.tituloMapper.toEnviarTituloRequest(protesto, this.listasCache);
            List responseList = this.cenprotProvider.getClient().getProtestoInterface().enviarTitulo(token, List.of(request));
            if (responseList == null || responseList.isEmpty()) {
                throw new IllegalStateException("Resposta do CENPROTMS \u00e9 inv\u00e1lida");
            }
            CenprotMSResponseProcessor processor = this.processorFactory.obterProcessador(ProcessorType.ENVIAR_TITULO);
            CenprotMSRetornoDTO retorno = processor.processar(protesto, (Object)((EnviarTituloResponseData)responseList.getFirst()));
            log.debug("Protesto {} processado - Sucesso: {}", (Object)protesto.getId(), (Object)retorno.isSucesso());
            return retorno;
        }
        catch (Exception e) {
            String titulo = protesto != null && protesto.getProtesto() != null && protesto.getExercicio() != null ? String.format("Protesto %d/%d", protesto.getProtesto(), protesto.getExercicio()) : "Protesto inv\u00e1lido";
            Long id = protesto != null ? protesto.getId() : null;
            log.error("Erro ao processar protesto {} para CENPROTMS", (Object)id, (Object)e);
            return CenprotMSRetornoDTO.builder().titulo(titulo).sucesso(false).mensagem("Erro no processamento: " + e.getMessage()).dadosRetorno(null).build();
        }
    }

    @Generated
    public GerarProtestoCenprotMSBatchProcessor(CenprotMSStepProvider cenprotProvider, CenprotMSAuthService authService, CenprotMSValidationService validationService, CalculoAcrescimoService calculoAcrescimoService, CenprotMSResponseProcessorFactory processorFactory, CenprotMSTituloMapper tituloMapper) {
        this.cenprotProvider = cenprotProvider;
        this.authService = authService;
        this.validationService = validationService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.processorFactory = processorFactory;
        this.tituloMapper = tituloMapper;
    }
}

