/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cenprotms.consultarprotesto;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.stereotype.Service;

@Service
public class ConsultarProtestoCenprotMSJobStarter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsultarProtestoCenprotMSJobStarter.class);
    private final JobLauncher jobLauncher;
    private final Job consultarProtestoCenprotMSBatchJob;
    private final JobExplorer jobExplorer;

    public JobExecution startConsultaJob(List<Long> idsProtesto) {
        String idsProtestoString = idsProtesto.stream().map(String::valueOf).collect(Collectors.joining(","));
        this.validateJobRunningWith(idsProtestoString);
        try {
            JobParameters jobParameters = new JobParametersBuilder().addString("idsProtesto", idsProtestoString).addString("dataExecucao", LocalDateTime.now().toString()).addString("tipoOperacao", "CONSULTA").toJobParameters();
            return this.jobLauncher.run(this.consultarProtestoCenprotMSBatchJob, jobParameters);
        }
        catch (Exception e) {
            log.error("Erro ao iniciar job de consulta CENPROTMS", (Throwable)e);
            throw new EloValidationException("Erro ao iniciar job de consulta CENPROTMS. " + e.getMessage());
        }
    }

    private void validateJobRunningWith(String idsProtestoString) {
        boolean hasJobRunning = this.jobExplorer.findRunningJobExecutions(JobType.CONSULTAR_PROTESTO_CENPROTMS.getTipo()).stream().anyMatch(jobExecution -> Objects.equals(idsProtestoString, jobExecution.getJobParameters().getString("idsProtesto")));
        if (hasJobRunning) {
            throw new EloValidationException("J\u00e1 existe um job de consulta CENPROTMS em execu\u00e7\u00e3o para os protestos selecionados.");
        }
    }

    @Generated
    public ConsultarProtestoCenprotMSJobStarter(JobLauncher jobLauncher, Job consultarProtestoCenprotMSBatchJob, JobExplorer jobExplorer) {
        this.jobLauncher = jobLauncher;
        this.consultarProtestoCenprotMSBatchJob = consultarProtestoCenprotMSBatchJob;
        this.jobExplorer = jobExplorer;
    }
}

