/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cenprotms.consultarprotesto;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.service.NotificacaoService;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.StepExecution;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class ConsultarProtestoCenprotMSJobListener
implements JobExecutionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsultarProtestoCenprotMSJobListener.class);
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;

    public void beforeJob(@Nullable JobExecution jobExecution) {
        if (Objects.isNull(jobExecution)) {
            return;
        }
        String idsProtesto = jobExecution.getJobParameters().getString("idsProtesto");
        String dataInicio = LocalDate.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        log.info("Iniciando job de consulta CENPROTMS - IDs: {}", (Object)idsProtesto);
        String title = "CENPROTMS - Iniciada Consulta de Protestos";
        String detail = String.format("Iniciado o processo de consulta de protestos no CENPROTMS - %s", dataInicio);
        Optional notificacaoId = this.notificacaoService.send(title, detail, jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(@Nullable JobExecution jobExecution) {
        if (Objects.isNull(jobExecution)) {
            return;
        }
        String dataFim = LocalDate.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        String idNotificacaoStr = jobExecution.getExecutionContext().getString(ID_NOTIFICACAO);
        UUID notificacaoId = UUID.fromString(idNotificacaoStr);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.enviarNotificacaoSucesso(jobExecution, notificacaoId, dataFim);
            return;
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.enviarNotificacaoErro(jobExecution, notificacaoId, dataFim);
        }
    }

    private void enviarNotificacaoSucesso(JobExecution jobExecution, UUID notificacaoId, String dataFim) {
        StepExecution stepExecution = (StepExecution)jobExecution.getStepExecutions().iterator().next();
        String title = "CENPROTMS - Consulta de Protestos Conclu\u00edda";
        String detail = String.format("Finalizado com sucesso a consulta de protestos no CENPROTMS - %s. Lidos: %d, Processados: %d, Erros: %d", dataFim, stepExecution.getReadCount(), stepExecution.getWriteCount(), stepExecution.getSkipCount());
        this.notificacaoService.send(title, detail, jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        log.info("Job de consulta CENPROTMS conclu\u00eddo com sucesso - JobId: {}, Lidos: {}, Processados: {}, Erros: {}", new Object[]{jobExecution.getId(), stepExecution.getReadCount(), stepExecution.getWriteCount(), stepExecution.getSkipCount()});
    }

    private void enviarNotificacaoErro(JobExecution jobExecution, UUID notificacaoId, String dataFim) {
        String title = "CENPROTMS - Erro na Consulta de Protestos";
        String detail = String.format("Ocorreu um erro ao consultar protestos no CENPROTMS - %s", dataFim);
        this.notificacaoService.send(title, detail, jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        log.error("Job de consulta CENPROTMS falhou - JobId: {}, Status: {}", (Object)jobExecution.getId(), (Object)jobExecution.getStatus());
    }

    @Generated
    public ConsultarProtestoCenprotMSJobListener(NotificacaoService notificacaoService) {
        this.notificacaoService = notificacaoService;
    }
}

