/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cenprotms.consultarprotesto;

import br.com.elotech.tributos.dto.cenprot.CenprotMSRetornoDTO;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ConsultarProtestoCenprotMSBatchWriter
implements ItemWriter<CenprotMSRetornoDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsultarProtestoCenprotMSBatchWriter.class);

    public void write(List<? extends CenprotMSRetornoDTO> items) throws Exception {
        log.debug("Processando resultado de {} consultas ao CENPROTMS", (Object)items.size());
        long sucessos = items.stream().mapToLong(item -> item.isSucesso() ? 1L : 0L).sum();
        long erros = (long)items.size() - sucessos;
        log.info("Batch Consulta CENPROTMS - Sucessos: {}, Erros: {}", (Object)sucessos, (Object)erros);
        items.stream().filter(item -> !item.isSucesso()).forEach(item -> log.warn("Erro na consulta: {} - {}", (Object)item.getTitulo(), (Object)item.getMensagem()));
        items.stream().filter(CenprotMSRetornoDTO::isSucesso).forEach(item -> log.debug("Consulta bem-sucedida: {}", (Object)item.getTitulo()));
    }

    @Generated
    public ConsultarProtestoCenprotMSBatchWriter() {
    }
}

