/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cenprotms.consultarprotesto;

import br.com.elotech.tributos.batch.cenprotms.CenprotMSStepProvider;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.dto.cenprot.CenprotMSRetornoDTO;
import br.com.elotech.tributos.enums.cenprot.ProcessorType;
import br.com.elotech.tributos.integration.cenprotms.generated.ConsultarTituloRequestData;
import br.com.elotech.tributos.service.DiaUtilService;
import br.com.elotech.tributos.service.cenprotms.auth.CenprotMSAuthService;
import br.com.elotech.tributos.service.cenprotms.processor.CenprotMSResponseProcessor;
import br.com.elotech.tributos.service.cenprotms.processor.CenprotMSResponseProcessorFactory;
import br.com.elotech.tributos.service.cenprotms.request.CenprotMSRequestBuilder;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterStep;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ConsultarProtestoCenprotMSBatchProcessor
implements ItemProcessor<Protesto, CenprotMSRetornoDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsultarProtestoCenprotMSBatchProcessor.class);
    private static final CenprotMSRequestBuilder requestBuilder = new CenprotMSRequestBuilder();
    private final CenprotMSStepProvider cenprotProvider;
    private final CenprotMSAuthService authService;
    private final CenprotMSResponseProcessorFactory processorFactory;
    private final DiaUtilService diaUtilService;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        log.info("Inicializando step de consulta ao CENPROTMS");
        this.cenprotProvider.inicializar();
    }

    @AfterStep
    public void afterStep(StepExecution stepExecution) {
        log.info("Finalizando step de consulta ao CENPROTMS");
        this.cenprotProvider.limpar();
    }

    public CenprotMSRetornoDTO process(Protesto protesto) {
        try {
            log.debug("Consultando protesto {} no CENPROTMS", (Object)protesto.getId());
            String token = this.authService.obterTokenValido(this.cenprotProvider.getClient(), this.cenprotProvider.getTokenManager());
            ConsultarTituloRequestData request = requestBuilder.criarConsultaRequest(protesto);
            List responseList = this.cenprotProvider.getClient().getProtestoInterface().consultarTitulo(token, "S", "N", "N", List.of(request));
            CenprotMSResponseProcessor processor = this.processorFactory.obterProcessador(ProcessorType.CONSULTA_TITULO);
            return processor.processar(protesto, (Object)responseList);
        }
        catch (Exception e) {
            log.error("Erro ao consultar protesto {} no CENPROTMS", (Object)protesto.getId(), (Object)e);
            return CenprotMSRetornoDTO.builder().titulo(String.format("Protesto %d/%d", protesto.getProtesto(), protesto.getExercicio())).sucesso(false).mensagem("Erro na consulta: " + e.getMessage()).build();
        }
    }

    @Generated
    public ConsultarProtestoCenprotMSBatchProcessor(CenprotMSStepProvider cenprotProvider, CenprotMSAuthService authService, CenprotMSResponseProcessorFactory processorFactory, DiaUtilService diaUtilService) {
        this.cenprotProvider = cenprotProvider;
        this.authService = authService;
        this.processorFactory = processorFactory;
        this.diaUtilService = diaUtilService;
    }
}

