/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cda.protesto;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.domain.documento.cda.SituacaoLoteCda;
import br.com.elotech.tributos.service.GeracaoProtestoErroService;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.documento.cda.LoteCdaService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class GeracaoProtestoLoteCdaJobListener
extends JobExecutionListenerSupport {
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final GeracaoProtestoErroService geracaoProtestoErroService;
    private final NotificacaoService notificacaoService;
    private final LoteCdaService loteCdaService;
    protected StepExecution stepExecution;

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        JobParameters jobParameters = Objects.requireNonNull(jobExecution.getJobParameters());
        Long idLote = jobParameters.getLong("idLote");
        UUID notificacaoId = UUID.fromString(jobParameters.getString(ID_NOTIFICACAO));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            List erros = this.geracaoProtestoErroService.findByBatchJobExecutionSimulacao(BatchJobExecution.of((JobExecution)jobExecution));
            if (CollectionUtils.isNotEmpty((Collection)erros)) {
                this.loteCdaService.updateSituacaoLoteProtesto(SituacaoLoteCda.ERRO_PROTESTO, idLote);
            } else {
                this.loteCdaService.updateSituacaoLoteProtesto(SituacaoLoteCda.PROTESTO_GERADO, idLote);
            }
            this.notificacaoService.send("Gera\u00e7\u00e3o de protesto a partir do lote de d\u00edvida ativa - finalizado", String.format("Foi finalizada rotina de Gera\u00e7\u00e3o protesto a partir do lote de d\u00edvida ativa %d", idLote), jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Gera\u00e7\u00e3o de protesto a partir do lote de d\u00edvida ativa - falha", String.format("Falha na rotina de Gera\u00e7\u00e3o protesto a partir do lote de d\u00edvida ativa %d", idLote), jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        JobParameters jobParameters = Objects.requireNonNull(jobExecution.getJobParameters());
        Long idLote = jobParameters.getLong("idLote");
        Optional notificacaoId = this.notificacaoService.send("Gera\u00e7\u00e3o de protesto a partir do lote de d\u00edvida ativa - iniciado", String.format("Foi iniciada rotina de Gera\u00e7\u00e3o protesto a partir do lote de d\u00edvida ativa %d", idLote), jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    @Generated
    public GeracaoProtestoLoteCdaJobListener(GeracaoProtestoErroService geracaoProtestoErroService, NotificacaoService notificacaoService, LoteCdaService loteCdaService) {
        this.geracaoProtestoErroService = geracaoProtestoErroService;
        this.notificacaoService = notificacaoService;
        this.loteCdaService = loteCdaService;
    }
}

