/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.baixaautomatica;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class BaixaAutomaticaJobListener
extends JobExecutionListenerSupport {
    private static final String EXERCICIO = "exercicio";
    private static final String LOTE = "lote";
    private static final String ENTIDADE = "entidade";
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;
    private final PagamentoLoteService pagamentoLoteService;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long entidade = jobExecution.getJobParameters().getLong(ENTIDADE);
        Long exercicio = jobExecution.getJobParameters().getLong(EXERCICIO);
        Long lote = jobExecution.getJobParameters().getLong(LOTE);
        PagamentoLoteId pagamentoLoteId = new PagamentoLoteId();
        pagamentoLoteId.setEntidade(entidade);
        pagamentoLoteId.setExercicio(exercicio);
        pagamentoLoteId.setLote(lote);
        PagamentoLote pagamentoLote = (PagamentoLote)this.pagamentoLoteService.findOne((Serializable)pagamentoLoteId);
        this.validaDataMovimentacaoService.validaMesEDia(entidade, pagamentoLote.getDataMovimento());
        pagamentoLote.setBatchJobExecution(BatchJobExecution.of((JobExecution)jobExecution));
        this.pagamentoLoteService.save((EloEntity)pagamentoLote, null);
        Optional notificacaoId = this.notificacaoService.send("Baixa de Pagamento iniciada", String.format("Foi iniciada a baixa do lote de pagamento %d/%d", lote, exercicio), jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long lote = jobExecution.getJobParameters().getLong(LOTE);
        Long exercicio = jobExecution.getJobParameters().getLong(EXERCICIO);
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Baixa de pagamentos finalizada com sucesso", String.format("A baixa do lote %d/%d foi finalizada com sucesso.", lote, exercicio), jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Erro na baixa de pagamentos", "N\u00e3o foi poss\u00edvel realizar a baixa de pagamentos: ", jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    @Generated
    public BaixaAutomaticaJobListener(NotificacaoService notificacaoService, PagamentoLoteService pagamentoLoteService, ValidaDataMovimentacaoService validaDataMovimentacaoService) {
        this.notificacaoService = notificacaoService;
        this.pagamentoLoteService = pagamentoLoteService;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
    }
}

