/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch;

import br.com.elotech.tributos.domain.ComunicadoCadastro;
import br.com.elotech.tributos.domain.ComunicadoDebito;
import br.com.elotech.tributos.repository.ComunicadoCadastroRepository;
import java.util.List;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.item.ItemWriter;

public class ComunicadoGeracaoBatchWriter
implements ItemWriter<ComunicadoCadastro> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComunicadoGeracaoBatchWriter.class);
    private final EntityManager entityManager;
    private final ComunicadoCadastroRepository comunicadoCadastroRepository;
    private StepExecution stepExecution;
    protected static String ROTINA = "Comunicado Debito";

    public ComunicadoGeracaoBatchWriter(EntityManager entityManager, ComunicadoCadastroRepository comunicadoCadastroRepository) {
        this.entityManager = entityManager;
        this.comunicadoCadastroRepository = comunicadoCadastroRepository;
    }

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    @AfterWrite
    public void afterWrite(List<? extends ComunicadoDebito> comunicadoDebitos) {
        LOGGER.info("Comunicados - {} - Registros salvos at\u00e9 o momento: {}. Job Id {}.", new Object[]{ROTINA, this.stepExecution.getReadCount() + comunicadoDebitos.size(), this.stepExecution.getJobExecution().getId()});
    }

    public void write(List<? extends ComunicadoCadastro> items) {
        this.comunicadoCadastroRepository.saveAll(items);
        this.entityManager.flush();
    }
}

