/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.repository.ComunicadoDebitoRepository;
import br.com.elotech.tributos.repository.ComunicadoRepository;
import br.com.elotech.tributos.service.NotificacaoService;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class ComunicadoByConsultaDebitoJobListener
extends JobExecutionListenerSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComunicadoByConsultaDebitoJobListener.class);
    private static final String JOB_TYPE = "jobType";
    private static final String ID_COMUNICADO_DEBITO = "idComunicadoDebito";
    private final NotificacaoService notificacaoService;
    private final ComunicadoDebitoRepository comunicadoDebitoRepository;
    private final ComunicadoRepository comunicadoRepository;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        ComunicadoId comunicadoId = new ComunicadoId();
        JobParameters jobParameters = Objects.requireNonNull(jobExecution.getJobParameters());
        comunicadoId.setEntidade(jobParameters.getLong("entidade"));
        comunicadoId.setExercicio(jobParameters.getLong("exercicioComunicado"));
        comunicadoId.setIdComunicado(jobParameters.getLong("idComunicado"));
        Comunicado comunicado = (Comunicado)this.comunicadoRepository.findOne((Object)comunicadoId);
        comunicado.setBatchJobExecutionComunicado(BatchJobExecution.of((JobExecution)jobExecution));
        this.comunicadoRepository.save((Object)comunicado);
        Optional notificacaoId = this.notificacaoService.send("Comunicado Debito - iniciada", String.format("Foi iniciada a rotina de comunciado por consulta de d\u00e9bito %d/%d", comunicadoId.getIdComunicado(), comunicadoId.getExercicio()), jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_COMUNICADO_DEBITO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long idComunicado = jobExecution.getJobParameters().getLong("idComunicado");
        Long exercicioComunicado = jobExecution.getJobParameters().getLong("exercicioComunicado");
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().get(ID_COMUNICADO_DEBITO).toString());
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Comunicado Debito - finalizado com sucesso", String.format("Os dados referentes ao Comunicado a partir da consulta de Debitos foram gerados com sucesso. %d/%d", idComunicado, exercicioComunicado), jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Comunicado Debito - finalizado com erro", String.format("Ocorreu um erro ao gerar os dados referentes ao Comunicado a partir da consulta de Debitos. %d/%d", idComunicado, exercicioComunicado), jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    @Generated
    public ComunicadoByConsultaDebitoJobListener(NotificacaoService notificacaoService, ComunicadoDebitoRepository comunicadoDebitoRepository, ComunicadoRepository comunicadoRepository) {
        this.notificacaoService = notificacaoService;
        this.comunicadoDebitoRepository = comunicadoDebitoRepository;
        this.comunicadoRepository = comunicadoRepository;
    }
}

