/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.audit;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.jpa.hibernate.envers.ChangeWithRevision;
import br.com.elotech.core.jpa.hibernate.envers.Revision;
import br.com.elotech.core.jpa.hibernate.envers.RevisionReader;
import br.com.elotech.core.metamodel.MetaModel;
import br.com.elotech.core.metamodel.loader.MetaModelLoader;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.rsql.extractor.AttributeGetterResult;
import br.com.elotech.tributos.util.DateUtils;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class AuditService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuditService.class);
    private final RevisionReader revisionReader;

    public AuditService(RevisionReader revisionReader) {
        this.revisionReader = revisionReader;
    }

    public <S extends Serializable, T extends EloEntity<S>> Page<ChangeWithRevision> getRevisionForEntity(Class<T> entityClass, S entityId, String search, Pageable pageable) {
        List filtroCampos = RsqlUtils.getFieldValues((String)search, (String)"fieldName");
        List eventTypeFilter = RsqlUtils.getFieldValues((String)search, (String)"eventTypeFilter");
        List previousValueFilter = RsqlUtils.getFieldValues((String)search, (String)"previousValue");
        List nextValueFilter = RsqlUtils.getFieldValues((String)search, (String)"nextValue");
        String searchWithoutFieldName = RsqlUtils.removeField((String)search, (String)"fieldName");
        String searchWithoutEventType = RsqlUtils.removeField((String)searchWithoutFieldName, (String)"eventTypeFilter");
        String previousValueEventType = RsqlUtils.removeField((String)searchWithoutEventType, (String)"previousValue");
        String nextValueEventType = RsqlUtils.removeField((String)previousValueEventType, (String)"nextValue");
        List history = this.revisionReader.findHistory(entityClass, Revision.class, entityId, nextValueEventType);
        history.stream().reduce((first, second) -> second).ifPresent(last -> last.getChanges().stream().filter(x -> Objects.isNull(x.getBefore())).forEach(x -> x.setType("Criado")));
        List flatRevision = this.revisionReader.flattenChanges(history);
        MetaModel metaModel = MetaModelLoader.newMetaModel(entityClass, (boolean)true);
        List historyWithCaptions = flatRevision.stream().map(historyEntry -> {
            String fieldPath = historyEntry.getChange().getField();
            try {
                String caption = metaModel.getCaption(fieldPath);
                historyEntry.getChange().setField(caption);
            }
            catch (IllegalArgumentException ex) {
                log.debug(String.format("Campo %s n\u00e3o encontrado na classe %s", fieldPath, entityClass.getName()));
            }
            return historyEntry;
        }).collect(Collectors.toList());
        List filteredHistoryFirstStep = this.filtrarPor(filtroCampos, historyWithCaptions, (arg_0, arg_1) -> this.filtrarCampoModificado(arg_0, arg_1));
        List filteredHistorySecondStep = this.filtrarPor(previousValueFilter, filteredHistoryFirstStep, (arg_0, arg_1) -> this.filtrarPreviousValue(arg_0, arg_1));
        List filteredHistoryThirdStep = this.filtrarPor(nextValueFilter, filteredHistorySecondStep, (arg_0, arg_1) -> this.filtrarNextValue(arg_0, arg_1));
        List filteredHistory = this.filtrarPor(eventTypeFilter, filteredHistoryThirdStep, (arg_0, arg_1) -> this.filtrarEventType(arg_0, arg_1));
        List pagedHistory = filteredHistory.stream().skip(pageable.getOffset()).limit(pageable.getPageSize()).collect(Collectors.toList());
        return new PageImpl(pagedHistory, pageable, (long)filteredHistory.size());
    }

    private List<ChangeWithRevision> filtrarPor(List<AttributeGetterResult> eventType, List<ChangeWithRevision> history, BiFunction<ChangeWithRevision, List<AttributeGetterResult>, Boolean> filterMethod) {
        if (eventType.isEmpty()) {
            return history;
        }
        return history.stream().filter(change -> (Boolean)filterMethod.apply((ChangeWithRevision)change, eventType)).collect(Collectors.toList());
    }

    public <T extends EloEntity<S>, S extends Serializable> T getRecordAtDate(Class<T> entityClass, S entityId, LocalDateTime referenceDate) {
        return (T)this.revisionReader.getRecordAtDate(entityClass, entityId, DateUtils.localDateTimeToDate((LocalDateTime)referenceDate));
    }

    private Boolean filtrarCampoModificado(ChangeWithRevision change, List<AttributeGetterResult> filtroCampos) {
        return filtroCampos.stream().anyMatch(fieldFilter -> {
            if (fieldFilter.getOperator().equals("==")) {
                if (fieldFilter.getValue().startsWith("*") && fieldFilter.getValue().endsWith("*")) {
                    return change.getChange().getField().toLowerCase().contains(fieldFilter.getValue().substring(1, fieldFilter.getValue().length() - 1).toLowerCase());
                }
                return change.getChange().getField().equalsIgnoreCase(fieldFilter.getValue());
            }
            return !change.getChange().getField().equalsIgnoreCase(fieldFilter.getValue());
        });
    }

    private Boolean filtrarEventType(ChangeWithRevision change, List<AttributeGetterResult> filtroCampos) {
        return filtroCampos.stream().anyMatch(fieldFilter -> {
            if (fieldFilter.getOperator().equals("==")) {
                return change.getChange().getType().equalsIgnoreCase(fieldFilter.getValue());
            }
            return !change.getChange().getType().equalsIgnoreCase(fieldFilter.getValue());
        });
    }

    private Boolean filtrarPreviousValue(ChangeWithRevision change, List<AttributeGetterResult> filtroCampos) {
        return filtroCampos.stream().anyMatch(fieldFilter -> {
            if (fieldFilter.getOperator().equals("==")) {
                if (fieldFilter.getValue().startsWith("*") && fieldFilter.getValue().endsWith("*")) {
                    return Optional.ofNullable(change.getChange().getBefore()).orElse("").toLowerCase().contains(fieldFilter.getValue().substring(1, fieldFilter.getValue().length() - 1).toLowerCase());
                }
                return Optional.ofNullable(change.getChange().getBefore()).orElse("").equalsIgnoreCase(fieldFilter.getValue());
            }
            return !Optional.ofNullable(change.getChange().getBefore()).orElse("").equalsIgnoreCase(fieldFilter.getValue());
        });
    }

    private Boolean filtrarNextValue(ChangeWithRevision change, List<AttributeGetterResult> filtroCampos) {
        return filtroCampos.stream().anyMatch(fieldFilter -> {
            if (fieldFilter.getOperator().equals("==")) {
                if (fieldFilter.getValue().startsWith("*") && fieldFilter.getValue().endsWith("*")) {
                    return Optional.ofNullable(change.getChange().getAfter()).orElse("").toLowerCase().contains(fieldFilter.getValue().substring(1, fieldFilter.getValue().length() - 1).toLowerCase());
                }
                return Optional.ofNullable(change.getChange().getAfter()).orElse("").equalsIgnoreCase(fieldFilter.getValue());
            }
            return !Optional.ofNullable(change.getChange().getAfter()).orElse("").equalsIgnoreCase(fieldFilter.getValue());
        });
    }
}

