SELECT
    cg.TipoCadastro,
    cg.CadastroGeral,
    cg.idKey as idCadastro,
    p_proprietario.cnpj_cpf as cpfCnpj,
    CASE
        WHEN p_proprietario.tipopessoa = 'J' THEN 'Jurídica'
        ELSE 'Física'
    END as tipoPessoa,
    p_proprietario.nome,
    p_proprietario.pessoa,
    'EMPRESA ONDE É SÓCIO' as VinculoDescricao,
    99 as tipovinculo,
    tl.descricao as tipoLogradouro,
    lg.descricao as logradouro,
    cg.numero as numero,
    ba.descricao as bairro,
    ci.descricao as cidade,
    ci.unidadefederacao as unidadeFederacao,
    COALESCE(sitimob.descricao, sitmob.descricao, 'OK') as situacao
FROM TribCadastroGeral cg
INNER JOIN TribCadastroMobiliario cm ON cm.TRIBCADASTROGERAL_IDKEY = cg.idkey
INNER JOIN TribContratoSocial cs ON cs.tribcadastromobiliario_idkey = cm.TRIBCADASTROGERAL_IDKEY
INNER JOIN TribContratoSocialPessoa csp ON csp.TRIBCONTRATOSOCIAL_IDKEY = cs.idkey
INNER JOIN pessoa p_socio ON p_socio.pessoa = csp.pessoa
INNER JOIN pessoa b ON b.pessoa = p_socio.pessoa
INNER JOIN pessoa p_proprietario ON p_proprietario.pessoa = cg.pessoa
LEFT OUTER JOIN logradouro lg ON lg.cidade = cg.cidade AND lg.logradouro = cg.logradouro
LEFT OUTER JOIN tipologradouro tl ON tl.tipologradouro = lg.tipologradouro
LEFT OUTER JOIN bairro ba ON ba.cidade = cg.cidade AND ba.bairro = cg.bairro
LEFT OUTER JOIN cidade ci ON ci.cidade = cg.cidade
LEFT OUTER JOIN tribmobiliariosituacao mobsit ON cg.tipocadastro = mobsit.tipocadastro
                                               AND cg.cadastrogeral = mobsit.cadastrogeral
                                               AND mobsit.atual = 'S'
LEFT OUTER JOIN tribsituacaomobiliario sitmob ON sitmob.situacaomobiliario = mobsit.situacaomobiliario
LEFT OUTER JOIN tribimobiliariosituacao imobsit ON cg.tipocadastro = imobsit.tipocadastro
                                                 AND cg.cadastrogeral = imobsit.cadastrogeral
                                                 AND imobsit.atual = 'S'
LEFT OUTER JOIN tribsituacaoimobiliario sitimob ON sitimob.situacaoimobiliario = imobsit.situacaoimobiliario
WHERE cg.ExclusaoLogica = 'N'
  AND cg.tipocadastro = 2
  AND (p_socio.cnpj_cpf = 'FILTRO_SERA_SUBSTITUIDO' OR 1=1) :filtroRastreamento
ORDER BY cg.tipocadastro, cg.cadastrogeral, p_proprietario.pessoa