with cadastrorural as
(select tcg.tipoCadastro,
       tcg.cadastroGeral,
       tcg.exclusaoLogica,
       tcg.dataInclusao,
       tcg.dataAlteracao,
       c.Descricao cidadeDescr,
       tcg.pessoa,
       p.Nome proprietario,
       p.tipoPessoa,
       p.cnpj_cpf cnpjCpf,
       tcg.usuario,
       a.numeroImovelReceita,
       a.codigoIncra,
       a.nome,
       a.areaTotal,
       a.areaArrendada,
       a.areaCultivo,
       a.areaPasto,
       a.valorTerreno,
       a.qtdeAlqueires,
       a.lote,
       a.matricula,
       a.oficio,
       a.origemInscricao,
       a.detencao,
       a.resideImovel,
       a.dataAquisicao,
       a.distrito,
       a.setor,
       setor.apelido setorDescr,
       a.endereco,
       tcg.complemento
from tribCadastroGeral tcg
left outer join pessoa p
           on (tcg.Pessoa = p.Pessoa)
left outer join tribTipoCadastro ttc
           on (tcg.TipoCadastro = ttc.TipoCadastro)
left outer join logradouro l
           on (tcg.Logradouro = l.Logradouro)
          and (tcg.Cidade = l.Cidade)
left outer join cidade c
           on (tcg.Cidade = c.Cidade)
left outer join Bairro b
           on (tcg.Bairro = b.Bairro)
          and (tcg.Cidade = b.Cidade)
left outer join tribcadastrorural a
              on (a.tipocadastro = tcg.tipocadastro)
             and (a.cadastrogeral = tcg.cadastrogeral)
left outer join tribsetor setor on
                 (setor.distrito = a.distrito)
             and (setor.setor = a.setor)
where tcg.TipoCadastro = 3
:filtro
order by tcg.TipoCadastro,tcg.CadastroGeral
:pageable
)
select cadastrorural.tipoCadastro,
       cadastrorural.cadastroGeral,
       cadastrorural.exclusaoLogica,
       cadastrorural.dataInclusao,
       cadastrorural.dataAlteracao,
       cadastrorural.cidadeDescr,
       cadastrorural.pessoa,
       cadastrorural.proprietario,
       cadastrorural.tipoPessoa,
       cadastrorural.cnpjCpf,
       cadastrorural.usuario,
       cadastrorural.numeroImovelReceita,
       cadastrorural.codigoIncra,
       cadastrorural.nome,
       cadastrorural.areaTotal,
       cadastrorural.areaArrendada,
       cadastrorural.areaCultivo,
       cadastrorural.areaPasto,
       cadastrorural.valorTerreno,
       cadastrorural.qtdeAlqueires,
       cadastrorural.lote,
       cadastrorural.matricula,
       cadastrorural.oficio,
       cadastrorural.origemInscricao,
       cadastrorural.detencao,
       cadastrorural.resideImovel,
       cadastrorural.dataAquisicao,
       cadastrorural.distrito,
       cadastrorural.setor,
       cadastrorural.setorDescr,
       cadastrorural.endereco,
       cadastrorural.complemento,
       ARRAY_AGG(proprietario.*) as proprietarios
from cadastrorural
  left join (
select
    tcg.cadastroGeral,
    tcg.tipoCadastro,
    tp.pessoa,
    p.tipoPessoa,
    p.cnpj_cpf,
    p.rg,
    p.orgaoemissor,
    tp.Vinculo,
    tp.Percentual * 1000 as Percentual,
    tp.Principal,
    p.Nome Proprietario,
    tv.Descricao Vinculo_Descr,
    ep.Cidade,
    ep.UnidadeFederacao as Estado,
    ep.Bairro,
    ep.cep,
    tplo.sigla,
    ep.Numero,
    ep.Complemento,
    cp.TelefoneCelular,
    cp.TelefoneResidencial,
    cp.TelefoneComercial,
    cid.Descricao Cidade_Descricao,
    bai.Descricao Bairro_Descricao,
    lgr.Descricao Logradouro_Descricao
  from tribProprietario tp
  left outer join tribCadastroGeral tcg
               on tcg.TipoCadastro = tp.TipoCadastro
              and tcg.CadastroGeral = tp.CadastroGeral
  left outer join pessoa p
               on (tp.Pessoa = p.Pessoa)
  left outer join tribVinculo tv
                on (tp.Vinculo = tv.Vinculo)
  left outer join EnderecoPessoa ep
                on p.Pessoa = ep.Pessoa and
                   p.SequenciaEndereco = ep.Sequencia
  left outer join Cidade cid
                on ep.Cidade = cid.Cidade
  left outer join Bairro bai
                on ep.Bairro = bai.Bairro
               and ep.Cidade = bai.Cidade
  left outer join ContatoPessoa cp
                on p.Pessoa = cp.Pessoa and
                   p.SequenciaContato = cp.Sequencia
  left outer join Logradouro lgr
                on ep.Cidade = lgr.Cidade
               and ep.Logradouro = lgr.Logradouro
  Left outer join tipologradouro tplo on
                tplo.tipologradouro = lgr.tipologradouro
   and tcg.ExclusaoLogica <> 'S'
 order by tp.Pessoa
 ) proprietario
   on proprietario.tipocadastro = cadastrorural.tipocadastro
   and proprietario.cadastrogeral = cadastrorural.cadastrogeral
group by cadastrorural.tipoCadastro,
        cadastrorural.cadastroGeral,
        cadastrorural.exclusaoLogica,
        cadastrorural.dataInclusao,
        cadastrorural.dataAlteracao,
        cadastrorural.cidadeDescr,
        cadastrorural.pessoa,
        cadastrorural.proprietario,
        cadastrorural.tipoPessoa,
        cadastrorural.cnpjcpf,
        cadastrorural.usuario,
        cadastrorural.numeroImovelReceita,
        cadastrorural.codigoIncra,
        cadastrorural.nome,
        cadastrorural.areaTotal,
        cadastrorural.areaArrendada,
        cadastrorural.areaCultivo,
        cadastrorural.areaPasto,
        cadastrorural.valorTerreno,
        cadastrorural.qtdeAlqueires,
        cadastrorural.lote,
        cadastrorural.matricula,
        cadastrorural.oficio,
        cadastrorural.origemInscricao,
        cadastrorural.detencao,
        cadastrorural.resideImovel,
        cadastrorural.dataAquisicao,
        cadastrorural.distrito,
        cadastrorural.setor,
        cadastrorural.setorDescr,
        cadastrorural.endereco,
        cadastrorural.complemento