select tp.entidade,
       tep.datareabilitacao as datamovimentacao,
       tr.receita as tributo,
       tr.descricao as descricaotributo,
       tr.tiporeceita as tipotributo,
       case
           when tr.classificacao = 'F'
               then 'J'
           else tr.classificacao
           end                              classificacaotributo,
       case
           when valores.situacaolegal <> 0 and
                (valores.datadividaativa is null or valores.datadividaativa <= tep.dataestorno)
               then valores.situacaolegal
           else 0
           end                              situacaolegal,
       null                    as tipooperacaodeducao,
       'ACRESCIMOS_PARCELAMENTO' as tipomovimento,
       valores.iddebito,
       p.idunico as idunicopessoa,
       valores.iddebitoparcelareceita,
       valores.valor
from tribestornoparcelamento tep
         left join tribparcelamento tp on tep.idparcelamento = tp.idparcelamento
         left join (select case
                               when x.parcela = x.max_parcela then
                                       x.valorjurosfinan  + x.juros_financiamento_extra -
                                       coalesce((select sum(y.rateio_juros_financiamento)
                                                 from vw_atualizacao_parcelamento y
                                                 where y.idparcelamento = x.idparcelamento
                                                   and y.iddebito = x.iddebito
                                                   and y.receitaorigem = x.receitaorigem
                                                   and y.parcela <> x.max_parcela), 0)
                               else x.rateio_juros_financiamento  + x.juros_financiamento_extra end as valor,
                           x.valorjurosfinan,
                           x.rateio_juros_financiamento,
                           x.idparcelamento,
                           x.iddebitoparcelareceita,
                           x.iddebito,
                           pre.jurosfinandestino as receita,
                           x.guiarecolhimento,
                           x.situacaolegal,
                           pre.iddebitonovo,
                           x.datadividaativa
                    from vw_atualizacao_parcelamento x
                            inner join tribparcelamentoreceitaespelho pre on pre.idparcelamentoreceitaespelho = x.idparcelamentoreceitaespelho
                    where x.valorjurosfinan > 0
                      and x.datareabilitacao in (:datasMovimento)
                      and x.datareabilitacao <> x.dataestorno) as valores
                   on valores.idparcelamento = tp.idparcelamento
         left join tribdebito td on td.iddebito = valores.iddebito
         	  join tribcadastrogeral tcg
         	    on td.tipocadastro = tcg.tipocadastro
         	   and td.cadastrogeral = tcg.cadastrogeral
         	  join pessoa p
         	    on tcg.pessoa = p.pessoa
         left join tribreceita tr
                   on tr.entidade = td.entidade  and tr.exercicio = :exercicio and tr.receita = valores.receita
where tep.datareabilitacao in (:datasMovimento)
  and valores.valor > 0
  and tp.anocontrato = :exercicio
  and tep.datareabilitacao <> tep.dataestorno
  and exists(select 1
             from tribestornoparcelamentodebito tepd
             where tepd.idestornoparcelamento = tep.idestornoparcelamento
               and tepd.iddebitoorigem < tepd.iddebitodestino)