        /* CANCELAMENTOS */
        SELECT CASE
                 WHEN P.TIPOPESSOA = 'F' THEN 2
                 WHEN P.TIPOPESSOA = 'J' THEN 3
                 ELSE 3
               END                                    AS idTpDocContribuinte,
               P.CNPJ_CPF                             AS nrDocContribuinte,
               CASE
                 WHEN TCDI.SITUACAOLEGAL = 0 THEN 1
                 WHEN TCDI.SITUACAOLEGAL IN (1, 2) THEN 2
                 ELSE 99
               END                                    AS idTipoOrigemReceita,
               TTD.TIPOTCE                            AS idTipoDeducaoCredito,
               RT.CLASSIFICACAORECEITATIPO            AS idTipoCredito,
               CG.IDTCE                               AS cdControleLeiAto,
               TCD.DATACANCELAMENTO                   AS dtDeducao,
               TCG.CADASTROGERAL                      AS cdCadastro,
               NULL                                   AS nrProcesso,
               CASE
                 WHEN PRESP.TIPOPESSOA = 'F' THEN 2
                 WHEN PRESP.TIPOPESSOA = 'J' THEN 3
                 ELSE 3
               END                                    AS idTpDocResponsavel,
               PRESP.CNPJ_CPF                         AS nrDocResponsavel,
               TMD.DESCRICAO                          AS dsMotivo,
               SUM(COALESCE(TCDI.VALOR, 0))           AS vlDeducao
          FROM TRIBCANCELAMENTODEBITO       TCD
     LEFT JOIN TRIBCANCELAMENTODEBITOITEM   TCDI  ON (TCD.ENTIDADE = TCDI.ENTIDADE
                                                  AND TCD.EXERCICIO = TCDI.EXERCICIO
                                                  AND TCD.IDCANCELAMENTO = TCDI.IDCANCELAMENTO)
     LEFT JOIN TRIBDEBITOPARCELARECEITA     TDPR  ON (TCDI.IDDEBITOPARCELARECEITA = TDPR.IDDEBITOPARCELARECEITA)
     LEFT JOIN TRIBRECEITA                  TR    ON (TDPR.ENTIDADE = TR.ENTIDADE AND TDPR.EXERCICIO = TR.EXERCICIO AND TDPR.RECEITA = TR.RECEITA)
     LEFT JOIN TRIBDEBITO                   TD    ON (TDPR.ENTIDADE = TD.ENTIDADE
                                                  AND TDPR.EXERCICIO = TD.EXERCICIO
     				                              AND TDPR.TIPOCADASTRO = TD.TIPOCADASTRO
     				                              AND TDPR.CADASTROGERAL = TD.CADASTROGERAL
     				                              AND TDPR.GUIARECOLHIMENTO = TD.GUIARECOLHIMENTO
     				                              AND TDPR.SUBDIVIDA = TD.SUBDIVIDA)
     LEFT JOIN TRIBMOTIVODESCONTO           TMD   ON (TCD.MOTIVOCANCELAMENTO = TMD.MOTIVODESCONTO)
     LEFT JOIN TRIBTIPODEDUCAO              TTD   ON (TMD.TIPODEDUCAO = TTD.TIPODEDUCAO)
     LEFT JOIN TRIBRECEITATIPO              RT    ON (RT.TIPORECEITA = TR.TIPORECEITA)
     LEFT JOIN TRIBCADASTROGERAL            TCG   ON (TCG.CADASTROGERAL = TDPR.CADASTROGERAL)
     LEFT JOIN PESSOA                       P     ON (P.PESSOA = TCG.PESSOA)
     LEFT JOIN USUARIO                      U     ON (TCD.USUARIO = U.USUARIO)
     LEFT JOIN PESSOA                       PRESP ON (PRESP.PESSOA = U.PESSOA)
     LEFT JOIN CGATO                        CG    ON (CG.ENTIDADE = TMD.ENTIDADE AND CG.IDATO = TMD.IDATO)
         WHERE TD.CONSTITUIDO = 'S'
           AND RT.CLASSIFICACAORECEITATIPO IN (1, 2, 3, 4, 5, 7)
           AND TTD.TIPOTCE IN ('1', '2', '3', '4', '5', '6')
           AND COALESCE(TCDI.VALOR, 0) > 0
               %s
           AND NOT EXISTS (SELECT 1
                             FROM TRIBESTORNOPARCELAMENTODEBITO TEPD
                        LEFT JOIN TRIBESTORNOPARCELAMENTO       TEP  ON (TEPD.IDESTORNOPARCELAMENTO = TEP.IDESTORNOPARCELAMENTO)
                            WHERE (TEPD.IDDEBITOORIGEM = TD.IDDEBITO
                               AND TCD.DATACANCELAMENTO = TEP.DATAESTORNO)
                                OR (TEPD.IDDEBITODESTINO = TD.IDDEBITO
                                AND TEP.ESTORNADO = 'S'
                                AND TCD.DATACANCELAMENTO = TEP.DATAREABILITACAO))
         GROUP BY idTpDocContribuinte,
                  nrDocContribuinte,
                  idTipoOrigemReceita,
                  idTipoDeducaoCredito,
                  idTipoCredito,
                  cdControleLeiAto,
                  dtDeducao,
                  cdCadastro,
                  nrProcesso,
                  idTpDocResponsavel,
                  nrDocResponsavel,
                  dsMotivo

            UNION

        /* ISENÇÕES */
        SELECT CASE
                 WHEN P.TIPOPESSOA = 'F' THEN 2
                 WHEN P.TIPOPESSOA = 'J' THEN 3
                 ELSE 3
               END                                                  AS idTpDocContribuinte,
               P.CNPJ_CPF                                           AS nrDocContribuinte,
               CASE
                 WHEN TDP.SITUACAOLEGAL = 0 THEN 1
                 WHEN TDP.SITUACAOLEGAL IN (1, 2) THEN 2
                 ELSE 99
               END                                                  AS idTipoOrigemReceita,
               DADOS.TIPOOPERACAODEDUCAO                            AS idTipoDeducaoCredito,
               RT.CLASSIFICACAORECEITATIPO                          AS idTipoCredito,
               DADOS.LEIATO                                         AS cdControleLeiAto,
               CASE
                 WHEN TD.DATACONTABILIZACAO >= TDP.DATALANCAMENTO THEN TD.DATACONTABILIZACAO
                 WHEN TD.DATAINCLUSAO > TDP.DATALANCAMENTO THEN TD.DATAINCLUSAO
                 ELSE TDP.DATALANCAMENTO
               END                                                   AS dtDeducao,
               DADOS.CADASTROGERAL                                   AS cdCadastro,
               NULL                                                  AS nrProcesso,
               CASE
                 WHEN PRESP.TIPOPESSOA = 'F' THEN 2
                 WHEN PRESP.TIPOPESSOA = 'J' THEN 3
                 ELSE 3
               END                                                   AS idTpDocResponsavel,
               PRESP.CNPJ_CPF                                        AS nrDocResponsavel,
               DADOS.MOTIVODEDUCAO                                   AS dsMotivo,
               SUM(COALESCE(DADOS.VALORISENCAO, 0))                  AS vlDeducao
          FROM TRIBDEBITO                TD
     LEFT JOIN TRIBDEBITOPARCELA         TDP  ON (TD.ENTIDADE = TDP.ENTIDADE
                                              AND TD.EXERCICIO = TDP.EXERCICIO
                                              AND TD.TIPOCADASTRO = TDP.TIPOCADASTRO
                                              AND TD.CADASTROGERAL = TDP.CADASTROGERAL
                                              AND TD.GUIARECOLHIMENTO = TDP.GUIARECOLHIMENTO
                                              AND TD.SUBDIVIDA = TDP.SUBDIVIDA)
      LEFT JOIN TRIBDEBITOPARCELARECEITA TDPR ON (TDP.ENTIDADE = TDPR.ENTIDADE
                                              AND TDP.EXERCICIO = TDPR.EXERCICIO
                                              AND TDP.TIPOCADASTRO = TDPR.TIPOCADASTRO
                                              AND TDP.CADASTROGERAL = TDPR.CADASTROGERAL
                                              AND TDP.GUIARECOLHIMENTO = TDPR.GUIARECOLHIMENTO
                                              AND TDP.SUBDIVIDA = TDPR.SUBDIVIDA
                                              AND TDP.PARCELA = TDPR.PARCELA)
      LEFT JOIN TRIBSITUACAOPARCELA       TSP ON (TDP.SITUACAODEBITO = TSP.SITUACAOPARCELA)
      LEFT JOIN TRIBCADASTROGERAL         TCG ON (TD.TIPOCADASTRO = TCG.TIPOCADASTRO AND TD.CADASTROGERAL = TCG.CADASTROGERAL)
      LEFT JOIN PESSOA                    P   ON (P.PESSOA = TCG.PESSOA)
      LEFT JOIN USUARIO                   U   ON (TD.USUARIO = U.USUARIO)
      LEFT JOIN PESSOA                    PRESP ON (PRESP.PESSOA = U.PESSOA)
      LEFT JOIN TRIBDEBITORECEITA         TDR ON (TDPR.ENTIDADE = TDR.ENTIDADE
                                              AND TDPR.EXERCICIO = TDR.EXERCICIO
                                              AND TDPR.TIPOCADASTRO = TDR.TIPOCADASTRO
                                              AND TDPR.CADASTROGERAL = TDR.CADASTROGERAL
                                              AND TDPR.GUIARECOLHIMENTO = TDR.GUIARECOLHIMENTO
                                              AND TDPR.SUBDIVIDA = TDR.SUBDIVIDA
                                              AND TDPR.RECEITA = TDR.RECEITA)
      LEFT JOIN TRIBRECEITA 			  TR  ON (TDR.ENTIDADE = TR.ENTIDADE AND TDR.EXERCICIO = TR.EXERCICIO AND TDR.RECEITA = TR.RECEITA)
      LEFT JOIN TRIBRECEITATIPO           RT  ON (RT.TIPORECEITA = TR.TIPORECEITA)
      LEFT JOIN (SELECT ISREC.ENTIDADE,
        			    ISREC.EXERCICIO,
                        ISREC.TIPOCADASTRO,
                        ISREC.CADASTROGERAL,
                        ISREC.GUIARECOLHIMENTO,
                        ISREC.SUBDIVIDA,
                        ISREC.RECEITA,
                        TTD.TIPODEDUCAO,
                        TTD.DESCRICAO AS TIPODEDUCAO_DESCR,
                        TTD.TIPOTCE   AS TIPOOPERACAODEDUCAO,
                        TMD.DESCRICAO AS MOTIVODEDUCAO,
                        CG.IDTCE      AS LEIATO,
                        SUM(ISREC.VALORISENCAO) AS VALORISENCAO
                  FROM TRIBDEBITORECEITAISENCAO ISREC
             LEFT JOIN TRIBISENCAO TIREC ON	TIREC.ISENCAO = ISREC.ISENCAO
             LEFT JOIN TRIBMOTIVODESCONTO TMD ON TIREC.MOTIVODESCONTO = TMD.MOTIVODESCONTO
             LEFT JOIN TRIBTIPODEDUCAO TTD ON TMD.TIPODEDUCAO = TTD.TIPODEDUCAO
             LEFT JOIN CGATO CG ON (CG.ENTIDADE = TMD.ENTIDADE AND CG.IDATO = TMD.IDATO)
                 WHERE ISREC.VALORISENCAO > 0
                GROUP BY ISREC.ENTIDADE,
                         ISREC.EXERCICIO,
                         ISREC.TIPOCADASTRO,
                         ISREC.CADASTROGERAL,
                         ISREC.GUIARECOLHIMENTO,
                         ISREC.SUBDIVIDA,
                         ISREC.RECEITA,
                         TTD.TIPODEDUCAO,
                         TTD.DESCRICAO,
                         TTD.TIPOTCE,
                         TMD.DESCRICAO,
                         CG.IDTCE)  DADOS ON (DADOS.ENTIDADE = TDR.ENTIDADE
                                          AND DADOS.EXERCICIO = TDR.EXERCICIO
                                          AND DADOS.TIPOCADASTRO = TDR.TIPOCADASTRO
                                          AND DADOS.CADASTROGERAL = TDR.CADASTROGERAL
                                          AND DADOS.GUIARECOLHIMENTO = TDR.GUIARECOLHIMENTO
                                          AND DADOS.SUBDIVIDA = TDR.SUBDIVIDA
                                          AND DADOS.RECEITA = TDR.RECEITA)
                      WHERE TD.CONSTITUIDO = 'S'
                    	  AND COALESCE(DADOS.VALORISENCAO, 0) > 0
                    	  AND RT.CLASSIFICACAORECEITATIPO in (1, 2, 3, 4, 5, 7)
                    	  AND DADOS.TIPOOPERACAODEDUCAO IN ('1', '2', '3', '4', '5', '6')
                    	  %s
                  GROUP BY IdTpDocContribuinte,
                           nrDocContribuinte,
                           idTipoOrigemReceita,
                           idTipoDeducaoCredito,
                           idTipoCredito,
                           cdControleLeiAto,
                           CASE
                             WHEN TD.DATACONTABILIZACAO >= TDP.DATALANCAMENTO THEN TD.DATACONTABILIZACAO
                             WHEN TD.DATAINCLUSAO > TDP.DATALANCAMENTO THEN TD.DATAINCLUSAO
                             ELSE TDP.DATALANCAMENTO
                           END,
                           cdCadastro,
                           nrProcesso,
                           idTpDocResponsavel,
                           nrDocResponsavel,
                           dsMotivo

            UNION

        /* DESCONTOS */
        SELECT CASE
                 WHEN P.TIPOPESSOA = 'F' THEN 2
                 WHEN P.TIPOPESSOA = 'J' THEN 3
                 ELSE 3
               END                                 AS idTpDocContribuinte,
               P.CNPJ_CPF                          AS nrDocContribuinte,
               CASE
                 WHEN LICI.SITUACAOLEGAL = 0 THEN 1
                 WHEN LICI.SITUACAOLEGAL IN (1, 2) THEN 2
                 ELSE 99
               END                                 AS idTipoOrigemReceita,
               TTD.TIPOTCE   	                   AS idTipoDeducaoCredito,
               RT.CLASSIFICACAORECEITATIPO         AS idTipoCredito,
               CG.IDTCE                            AS cdControleLeiAto,
               LIC.DATALOTE                        AS dtDeducao,
               TCG.CADASTROGERAL                   AS cdCadastro,
               NULL                                AS nrProcesso,
               CASE
                 WHEN PRESP.TIPOPESSOA = 'F' THEN 2
                 WHEN PRESP.TIPOPESSOA = 'J' THEN 3
                 ELSE 3
               END                                 AS idTpDocResponsavel,
               PRESP.CNPJ_CPF                      AS nrDocResponsavel,
               TMD.DESCRICAO                       AS dsMotivo,
               SUM(COALESCE(LICI.VALORDEDUCAO, 0)) AS vlDeducao
           FROM LOTEINTEGRACAOCONTABIL     LIC
           JOIN LOTEITEMINTEGRACAOCONTABIL LICI  ON (LIC.ID = LICI.IDLOTE)
           JOIN TRIBPAGAMENTOLOTE          TPL   ON (LIC.ENTIDADE = TPL.ENTIDADE
                                                 AND LIC.EXERCICIO = TPL.EXERCICIO
                                                 AND LIC.LOTE = TPL.LOTE)
           JOIN TRIBPAGAMENTO              TP    ON (TP.ENTIDADE = TPL.ENTIDADE
                                                 AND TP.EXERCICIOLOTE = TPL.EXERCICIO
                                                 AND TP.LOTE = TPL.LOTE)
           JOIN TRIBRECEITA                TR    ON (LICI.IDTRIBUTO = TR.ID)
      LEFT JOIN TRIBRECEITATIPO            RT    ON (RT.TIPORECEITA = TR.TIPORECEITA)
      LEFT JOIN TRIBDEBITO                 TD    ON (LICI.IDDEBITO = TD.IDDEBITO)
      LEFT JOIN TRIBCADASTROGERAL          TCG   ON (TCG.CADASTROGERAL = TD.CADASTROGERAL
                                                 AND TCG.TIPOCADASTRO = TD.TIPOCADASTRO)
      LEFT JOIN PESSOA                     P     ON (P.PESSOA = LICI.PESSOA)
      LEFT JOIN USUARIO                    U     ON (TP.USUARIO = U.USUARIO)
      LEFT JOIN PESSOA                     PRESP ON (PRESP.PESSOA = U.PESSOA)
      LEFT JOIN CONTABANCARIA              CB    ON (LIC.IDCONTABANCARIA = CB.ID)
      LEFT JOIN TRIBMOTIVODESCONTO         TMD   ON (LICI.IDMOTIVODEDUCAO = TMD.MOTIVODESCONTO)
      LEFT JOIN TRIBTIPODEDUCAO            TTD   ON (TMD.TIPODEDUCAO = TTD.TIPODEDUCAO)
      LEFT JOIN CGATO                      CG    ON (CG.ENTIDADE = TMD.ENTIDADE AND CG.IDATO = TMD.IDATO)
          WHERE COALESCE(LICI.VALORDEDUCAO, 0) > 0
            AND CB.INTEGRAARRECADACAO = 'S'
            AND TTD.TIPOTCE IN ('1', '2', '3', '4', '5', '6')
            AND RT.CLASSIFICACAORECEITATIPO IN (1, 2, 3, 4, 5, 7)
              %s
         GROUP BY idTpDocContribuinte,
                  nrDocContribuinte,
                  idTipoOrigemReceita,
                  idTipoDeducaoCredito,
                  idTipoCredito,
                  cdControleLeiAto,
                  dtDeducao,
                  cdCadastro,
                  nrProcesso,
                  idTpDocResponsavel,
                  nrDocResponsavel,
                  dsMotivo