with debitosAtualizacao as (select tdprea.idreajuste,
                                   td.iddebito,
                                   tdpr.entidade,
                                   tdpr.exercicio,
                                   tdpr.tipocadastro,
                                   tdpr.cadastrogeral,
                                   tdpr.guiarecolhimento,
                                   tdpr.subdivida,
                                   min(tdpr.parcela) as minParcela
                            from tribdebitoparcelarecreajuste tdprea
                                     inner join tribdebitoparcelareceita tdpr
                                                on tdpr.iddebitoparcelareceita = tdprea.iddebitoparcelareceita
                                     inner join tribdebito td
                                                on tdpr.entidade = td.entidade and tdpr.exercicio = td.exercicio and
                                                   tdpr.tipocadastro = td.tipocadastro and
                                                   tdpr.cadastrogeral = td.cadastrogeral and
                                                   tdpr.guiarecolhimento = td.guiarecolhimento and
                                                   tdpr.subdivida = td.subdivida
                            where tdprea.idreajuste = :idReajuste
                            group by tdprea.idreajuste,
                                     td.iddebito,
                                     tdpr.entidade,
                                     tdpr.exercicio,
                                     tdpr.tipocadastro,
                                     tdpr.cadastrogeral,
                                     tdpr.guiarecolhimento,
                                     tdpr.subdivida)
select dpre.entidade,
       dpre.exercicio,
       dpre.tipocadastro,
       dpre.cadastrogeral,
       dpre.guiarecolhimento,
       dpre.subdivida,
       deb.minParcela $AGRUPAMENTO_TRIBUTO,
       deb.iddebito,
       Sum(case
               when (dprec.valor > 0) and (dprec.valor = dpre.valor) then dprec.valororiginal
               when (dprec.valor > 0) and (dprec.valororiginal < dprec.valor)
                   then coalesce(dprec.valororiginal, dpre.valor)
               when (coalesce(dprec.valor, 0) = 0) and (coalesce(dpre.valoratualizacao, 0) = 0) and
                    (dpre.valor = dpre.valororiginal) then dpre.valor
               when (coalesce(dprec.valor, 0) = 0) and (dpre.valor = dpre.valoratualizacao) and
                    (dpre.valor = dpre.valororiginal) then (dpre.valor - dpre.valoratualizacao)
               when (dprec.valor > 0) and (dpre.valor = dpre.valoratualizacao) and (dpre.valor = dpre.valororiginal)
                   then dpre.valor
               else dpre.valor
           end) as                              valorOriginal,
       Sum(coalesce(dprec.valor, dpre.valor))   as valor,
       sum(coalesce(dprec.valoratualizacao, 0)) as valorAtualizacao
from debitosAtualizacao deb
         inner join tribdebitoparcelareceita dpre on dpre.entidade = deb.entidade and dpre.exercicio = deb.exercicio and
                                                     dpre.tipocadastro = deb.tipocadastro and
                                                     dpre.cadastrogeral = deb.cadastrogeral and
                                                     dpre.guiarecolhimento = deb.guiarecolhimento and
                                                     dpre.subdivida = deb.subdivida

         left outer join tribdebitoparcelarecreajuste dprec
                         on dprec.valoratualizacao <> 0
                             and dprec.idreajuste = :idReajuste
                             and dpre.iddebitoparcelareceita = dprec.iddebitoparcelareceita
    $FILTRO_RSQL
Group by dpre.entidade,
    dpre.exercicio,
    dpre.tipocadastro,
    dpre.cadastrogeral,
    dpre.guiarecolhimento,
    dpre.subdivida,
    deb.minParcela $AGRUPAMENTO_TRIBUTO,
    deb.iddebito

