FROM TRIBDEBITO TD
         JOIN TRIBDEBITOPARCELA TDP
              ON TDP.ENTIDADE = TD.ENTIDADE
                  AND TDP.EXERCICIO = TD.EXERCICIO
                  AND TDP.TIPOCADASTRO = TD.TIPOCADASTRO
                  AND TDP.CADASTROGERAL = TD.CADASTROGERAL
                  AND TDP.GUIARECOLHIMENTO = TD.GUIARECOLHIMENTO
                  AND TDP.SUBDIVIDA = TD.SUBDIVIDA
         JOIN TRIBSITUACAOPARCELA TSP
              ON TDP.SITUACAODEBITO = TSP.SITUACAOPARCELA
         JOIN TRIBTIPOSITUACAOPARCELA TTSP
              ON TSP.TIPOSITUACAOPARCELA = TTSP.TIPOSITUACAOPARCELA
WHERE TD.ENTIDADE = :ENTIDADE
  AND TTSP.TIPO = 'A'
  AND EXISTS (SELECT 1
              FROM TRIBDEBITOPARCELARECEITA TDPR
              WHERE TDPR.ENTIDADE = TDP.ENTIDADE
                AND TDPR.EXERCICIO = TDP.EXERCICIO
                AND TDPR.TIPOCADASTRO = TDP.TIPOCADASTRO
                AND TDPR.CADASTROGERAL = TDP.CADASTROGERAL
                AND TDPR.GUIARECOLHIMENTO = TDP.GUIARECOLHIMENTO
                AND TDPR.SUBDIVIDA = TDP.SUBDIVIDA
                AND TDPR.PARCELA = TDP.PARCELA)
  AND (TD.PARCELADO = 'S' OR TD.REPARCELADO = 'S')
  AND EXTRACT(MONTH FROM TD.DATAPRIMEIRAPARCELA) = :MES
  AND TD.DATALANCAMENTO < :DATALANCAMENTO
  AND TDP.DATAVENCIMENTO >= :DATAVENCIMENTO
  AND TDP.DATAVENCIMENTO >= :DATAREAJUSTE
  AND (EXISTS (SELECT 1
               FROM TRIBPARCELAMENTODEBITO TPD
                        JOIN TRIBPARCELAMENTO TP ON TPD.IDPARCELAMENTO = TP.IDPARCELAMENTO
               WHERE TPD.IDDEBITO = TD.IDDEBITO
                 AND TP.ESTORNADO = 'N'
               :filtroIdParcelamento)
    or NOT EXISTS (SELECT 1
                   FROM TRIBPARCELAMENTODEBITO TPD
                            JOIN TRIBPARCELAMENTO TP ON TPD.IDPARCELAMENTO = TP.IDPARCELAMENTO
                   WHERE TPD.IDDEBITO = TD.IDDEBITO))
  :filtroParamPermiteAtualizacaoMensal