SELECT count(distinct PESSOASGROUP.*)  as total
FROM (
 select 
       PESSOA.PESSOA AS CODIGOPESSOA,
       PESSOA.TIPOPESSOA AS TIPOPESSOA,
       PESSOA.NOME AS NOME,
       PESSOA.CNPJ_CPF AS CNPJCPF,
       CP.IDKEY AS CONTATOID,
       CP.SEQUENCIA AS CONTATOCODIGO,
       CP.TELEFONECELULAR AS TELEFONECELULAR,
       CP.TELEFONERESIDENCIAL AS TELEFONERESIDENCIAL,
       CP.TELEFONECOMERCIAL AS TELEFONECOMERCIAL
 FROM PESSOA PESSOA
 LEFT OUTER JOIN TRIBPROPRIETARIO PROP ON PESSOA.PESSOA = PROP.PESSOA
 JOIN TRIBCADASTROGERAL CG
  	 ON PROP.TIPOCADASTRO = CG.TIPOCADASTRO
 	AND PROP.CADASTROGERAL = CG.CADASTROGERAL
 LEFT JOIN CONTATOPESSOA CP
     ON CP.PESSOA = PESSOA.PESSOA
 WHERE (PESSOA.CNPJ_CPF LIKE :search OR UPPER(PESSOA.NOME) LIKE :search OR CAST(PESSOA.PESSOA AS VARCHAR) LIKE :search )
 	AND CG.EXCLUSAOLOGICA = 'N' 
 	AND (CP.SEQUENCIA = PESSOA.SEQUENCIACONTATO OR CP.SEQUENCIA IS NULL) 

UNION ALL

 SELECT
       PESSOA.PESSOA AS CODIGOPESSOA,
       PESSOA.TIPOPESSOA AS TIPOPESSOA,
       PESSOA.NOME AS NOME,
       PESSOA.CNPJ_CPF AS CNPJCPF,
       CP.IDKEY AS CONTATOID,
       CP.SEQUENCIA AS CONTATOCODIGO,
       CP.TELEFONECELULAR AS TELEFONECELULAR,
       CP.TELEFONERESIDENCIAL AS TELEFONERESIDENCIAL,
       CP.TELEFONECOMERCIAL AS TELEFONECOMERCIAL
 FROM PESSOA PESSOA
 JOIN TRIBCADASTROGERAL CG
 ON CG.PESSOA = PESSOA.PESSOA
 LEFT JOIN CONTATOPESSOA CP
     ON CP.PESSOA = PESSOA.PESSOA
 WHERE (PESSOA.CNPJ_CPF LIKE :search OR UPPER(PESSOA.NOME) LIKE :search OR CAST(PESSOA.PESSOA AS VARCHAR) LIKE :search )
    AND CG.EXCLUSAOLOGICA = 'N'
    AND (CP.SEQUENCIA = PESSOA.SEQUENCIACONTATO OR CP.SEQUENCIA IS NULL)

 UNION ALL

 SELECT
       PESSOA.PESSOA AS CODIGOPESSOA,
       PESSOA.TIPOPESSOA AS TIPOPESSOA,
       PESSOA.NOME AS NOME,
       PESSOA.CNPJ_CPF AS CNPJCPF,
       CP.IDKEY AS CONTATOID,
       CP.SEQUENCIA AS CONTATOCODIGO,
       CP.TELEFONECELULAR AS TELEFONECELULAR,
       CP.TELEFONERESIDENCIAL AS TELEFONERESIDENCIAL,
       CP.TELEFONECOMERCIAL AS TELEFONECOMERCIAL
 FROM PESSOA PESSOA
 JOIN TRIBCONTRATOSOCIALPESSOA CSP ON CSP.PESSOA = PESSOA.PESSOA
 JOIN TRIBCONTRATOSOCIAL CS ON CS.IDKEY = CSP.TRIBCONTRATOSOCIAL_IDKEY
 JOIN TRIBCADASTROMOBILIARIO CM ON CM.TRIBCADASTROGERAL_IDKEY = CS.TRIBCADASTROMOBILIARIO_IDKEY
 JOIN TRIBCADASTROGERAL CG ON CG.IDKEY = CM.TRIBCADASTROGERAL_IDKEY
 LEFT JOIN CONTATOPESSOA CP
     ON CP.PESSOA = PESSOA.PESSOA
 WHERE (PESSOA.CNPJ_CPF LIKE :search OR UPPER(PESSOA.NOME) LIKE :search OR CAST(PESSOA.PESSOA AS VARCHAR) LIKE :search )
    AND CG.EXCLUSAOLOGICA = 'N'
    AND (CP.SEQUENCIA = PESSOA.SEQUENCIACONTATO OR CP.SEQUENCIA IS NULL)
    AND :consideraContratoSocial = true

) PESSOASGROUP