/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util.sisobra;

import br.com.elotech.tributos.domain.sisobra.SisObraAlvara;
import br.com.elotech.tributos.domain.sisobra.SisObraAlvaraArea;
import br.com.elotech.tributos.dto.sisobra.xml.AlvaraIndXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.AlvaraXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.AreaComplementarItemXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.AreaItemXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.AreaPrincipalItemXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.ArquitetoXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.CamposArquitetoXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.CamposEngenheiroXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.CamposTecnicoIndustrialXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.DonoObraXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.ElementoCnpjAndCpfXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.EmpresaConstrutoraXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.EnderecoObraXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.EngenheiroXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.IncorporadorConstrucaoCivilXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.InfAlvaraXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.InformacoesAdicionaisXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.ProprietarioImovelXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.ProprietarioObraXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.ResponsavelAlvaraXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.ResponsavelExecObraXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.SisObraPrefXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.TecnologoXmlDTO;
import br.com.elotech.tributos.enums.sisobra.AlvaraAreaCategoria;
import br.com.elotech.tributos.enums.sisobra.AlvaraAreaDestinacao;
import br.com.elotech.tributos.enums.sisobra.AlvaraAreaTipoObra;
import br.com.elotech.tributos.enums.sisobra.TipoAlvara;
import br.com.elotech.tributos.enums.sisobra.UnidadeMedida;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.util.ArrayList;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SisObraAlvaraXmlBuilder {
    private static final String ENGENHEIRO = "ENGENHEIRO";
    private static final String TECNOLOGO = "TECNOLOGO";
    private static final String TECNICOIND = "TECNICOIND";
    private static final String ARQUITETO = "TECNICOIND";
    private static final String AREA_PRINCIPAL = "P";
    private static final String AREA_COMPLEMENTAR = "C";
    private static final Long VINCULO_PROPRIETARIO_IMOVEL = 51L;
    private static final Long VINCULO_DONO_OBRA = 52L;
    private static final Long VINCULO_EMPRESA_CONSTRUTORA = 53L;
    private static final Long VINCULO_INCORPORADORA_CIVIL = 54L;

    public static String buildXmlAlvara(SisObraAlvara alvara, List<SisObraAlvaraArea> alvaraArea) {
        return SisObraAlvaraXmlBuilder.buildXml((SisObraAlvara)alvara, alvaraArea);
    }

    private static String buildXml(SisObraAlvara alvara, List<SisObraAlvaraArea> alvaraAreas) {
        SisObraPrefXmlDTO sisObraPrefXmlDTO = new SisObraPrefXmlDTO();
        AlvaraXmlDTO alvaraXmlDTO = new AlvaraXmlDTO();
        InfAlvaraXmlDTO infAlvaraXmlDTO = new InfAlvaraXmlDTO();
        sisObraPrefXmlDTO.setVersao("1.03");
        infAlvaraXmlDTO.setId("id0000001");
        infAlvaraXmlDTO.setNumeroAlvara(alvara.getIdSisobraAlvara());
        infAlvaraXmlDTO.setNomeObra(alvara.getNomeObra());
        infAlvaraXmlDTO.setDataAlvara(String.valueOf(alvara.getDataAlvara()));
        infAlvaraXmlDTO.setDataInicioObra(String.valueOf(alvara.getDataInicioObra()));
        if (alvara.getDataFinalObra() != null) {
            infAlvaraXmlDTO.setDataFinalObra(String.valueOf(alvara.getDataFinalObra()));
        }
        infAlvaraXmlDTO.setTipoAlvara(TipoAlvara.INICIAL.getDescricao());
        infAlvaraXmlDTO.setResponsavelExecObra(SisObraAlvaraXmlBuilder.getFactoryResponsavelExecObra((SisObraAlvara)alvara));
        infAlvaraXmlDTO.setEnderecoObra(SisObraAlvaraXmlBuilder.getEnderecoObra((SisObraAlvara)alvara));
        infAlvaraXmlDTO.setUnidadeMedida(UnidadeMedida.fromValue((Long)alvara.getUnidadeMedida()).getDescricao());
        infAlvaraXmlDTO.setArea(SisObraAlvaraXmlBuilder.getListArea(alvaraAreas));
        infAlvaraXmlDTO.setProprietarioObra(SisObraAlvaraXmlBuilder.getProprietarioObra((SisObraAlvara)alvara));
        infAlvaraXmlDTO.setInfoAdicionais(SisObraAlvaraXmlBuilder.getInformacoesAdicionais((SisObraAlvara)alvara));
        alvaraXmlDTO.setInfAlvara(infAlvaraXmlDTO);
        sisObraPrefXmlDTO.setAlvara(alvaraXmlDTO);
        XmlMapper xmlMapper = new XmlMapper();
        try {
            return xmlMapper.writeValueAsString((Object)sisObraPrefXmlDTO);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static ResponsavelAlvaraXmlDTO getFactoryResponsavelProjeto(SisObraAlvara alvara) {
        EngenheiroXmlDTO responsavelAlvaraXmlDTO = null;
        if (alvara.getTipoRespProjeto().equals("ENGENHEIRO")) {
            EngenheiroXmlDTO engenheiroXmlDTO = new EngenheiroXmlDTO();
            CamposEngenheiroXmlDTO camposEngenheiroXmlDTO = new CamposEngenheiroXmlDTO();
            camposEngenheiroXmlDTO.setNome(alvara.getRespProjNomeEngenheiro());
            camposEngenheiroXmlDTO.setCrea(alvara.getRespProjCreaEngenheiro());
            camposEngenheiroXmlDTO.setArt(alvara.getRespProjNumeroArt());
            engenheiroXmlDTO.setCampos(camposEngenheiroXmlDTO);
            responsavelAlvaraXmlDTO = engenheiroXmlDTO;
        }
        if (alvara.getTipoRespProjeto().equals("TECNICOIND")) {
            AlvaraIndXmlDTO tecnicoIndXmlDTO = new AlvaraIndXmlDTO();
            CamposTecnicoIndustrialXmlDTO camposTecnicoIndustrialXmlDTO = new CamposTecnicoIndustrialXmlDTO();
            camposTecnicoIndustrialXmlDTO.setNome(alvara.getRespProjNomeEngenheiro());
            camposTecnicoIndustrialXmlDTO.setCftCrt(alvara.getRespProjCreaEngenheiro());
            camposTecnicoIndustrialXmlDTO.setTrt(alvara.getRespTecnicoNumeroTrt());
            tecnicoIndXmlDTO.setCampos(camposTecnicoIndustrialXmlDTO);
            responsavelAlvaraXmlDTO = tecnicoIndXmlDTO;
        }
        if (alvara.getTipoRespProjeto().equals("TECNICOIND")) {
            ArquitetoXmlDTO arquitetoXmlDTO = new ArquitetoXmlDTO();
            CamposArquitetoXmlDTO camposArquitetoXmlDTO = new CamposArquitetoXmlDTO();
            camposArquitetoXmlDTO.setNome(alvara.getRespProjNomeArquiteto());
            camposArquitetoXmlDTO.setCau(alvara.getRespProjCauArquiteto());
            camposArquitetoXmlDTO.setRrt(alvara.getRespProjNumeroRrt());
            arquitetoXmlDTO.setCampos(camposArquitetoXmlDTO);
            responsavelAlvaraXmlDTO = arquitetoXmlDTO;
        }
        return responsavelAlvaraXmlDTO;
    }

    private static ResponsavelAlvaraXmlDTO getFactoryResponsavelTecnico(SisObraAlvara alvara) {
        CamposEngenheiroXmlDTO camposEngenheiroXmlDTO;
        EngenheiroXmlDTO responsavelAlvaraXmlDTO = null;
        if (alvara.getTipoRespExec().equals("ENGENHEIRO")) {
            EngenheiroXmlDTO engenheiroXmlDTO = new EngenheiroXmlDTO();
            camposEngenheiroXmlDTO = new CamposEngenheiroXmlDTO();
            camposEngenheiroXmlDTO.setNome(alvara.getRespTecnicoNomeEngenheiro());
            camposEngenheiroXmlDTO.setCrea(alvara.getRespTecnicoCreaEngenheiro());
            camposEngenheiroXmlDTO.setArt(alvara.getRespTecnicoNumeroArt());
            engenheiroXmlDTO.setCampos(camposEngenheiroXmlDTO);
            responsavelAlvaraXmlDTO = engenheiroXmlDTO;
        }
        if (alvara.getTipoRespExec().equals("TECNOLOGO")) {
            TecnologoXmlDTO tecnologoXmlDTO = new TecnologoXmlDTO();
            camposEngenheiroXmlDTO = new CamposEngenheiroXmlDTO();
            camposEngenheiroXmlDTO.setNome(alvara.getRespTecnicoNomeEngenheiro());
            camposEngenheiroXmlDTO.setCrea(alvara.getRespTecnicoCreaEngenheiro());
            camposEngenheiroXmlDTO.setArt(alvara.getRespTecnicoNumeroArt());
            tecnologoXmlDTO.setCampos(camposEngenheiroXmlDTO);
            responsavelAlvaraXmlDTO = tecnologoXmlDTO;
        }
        if (alvara.getTipoRespExec().equals("TECNICOIND")) {
            AlvaraIndXmlDTO tecnicoIndXmlDTO = new AlvaraIndXmlDTO();
            CamposTecnicoIndustrialXmlDTO camposTecnicoIndustrialXmlDTO = new CamposTecnicoIndustrialXmlDTO();
            camposTecnicoIndustrialXmlDTO.setNome(alvara.getRespTecnicoNomeEngenheiro());
            camposTecnicoIndustrialXmlDTO.setCftCrt(alvara.getRespTecnicoCreaEngenheiro());
            camposTecnicoIndustrialXmlDTO.setTrt(alvara.getRespTecnicoNumeroTrt());
            tecnicoIndXmlDTO.setCampos(camposTecnicoIndustrialXmlDTO);
            responsavelAlvaraXmlDTO = tecnicoIndXmlDTO;
        }
        if (alvara.getTipoRespExec().equals("TECNICOIND")) {
            ArquitetoXmlDTO arquitetoXmlDTO = new ArquitetoXmlDTO();
            CamposArquitetoXmlDTO camposArquitetoXmlDTO = new CamposArquitetoXmlDTO();
            camposArquitetoXmlDTO.setNome(alvara.getRespProjNomeArquiteto());
            camposArquitetoXmlDTO.setCau(alvara.getRespTecnicoCauArquiteto());
            camposArquitetoXmlDTO.setRrt(alvara.getRespTecnicoNumeroRrt());
            arquitetoXmlDTO.setCampos(camposArquitetoXmlDTO);
            responsavelAlvaraXmlDTO = arquitetoXmlDTO;
        }
        return responsavelAlvaraXmlDTO;
    }

    private static InformacoesAdicionaisXmlDTO getInformacoesAdicionais(SisObraAlvara alvara) {
        InformacoesAdicionaisXmlDTO informacoesAdicionaisXmlDTO = new InformacoesAdicionaisXmlDTO();
        informacoesAdicionaisXmlDTO.setSituacao(alvara.getSituacao());
        informacoesAdicionaisXmlDTO.setClasse(alvara.getClasse());
        if (!alvara.getNumeroProcesso().isEmpty()) {
            informacoesAdicionaisXmlDTO.setNumeroProcesso(alvara.getNumeroProcesso());
        }
        if (alvara.getTipoRespExec() != null) {
            informacoesAdicionaisXmlDTO.setResponsavelTecnico(SisObraAlvaraXmlBuilder.getFactoryResponsavelTecnico((SisObraAlvara)alvara));
        }
        if (alvara.getTipoRespProjeto() != null) {
            informacoesAdicionaisXmlDTO.setResponsavelProjeto(SisObraAlvaraXmlBuilder.getFactoryResponsavelProjeto((SisObraAlvara)alvara));
        }
        informacoesAdicionaisXmlDTO.setEspecificacao(alvara.getEspecificacao());
        informacoesAdicionaisXmlDTO.setObservacao(alvara.getObservacao());
        if (informacoesAdicionaisXmlDTO.getClasse() != null || informacoesAdicionaisXmlDTO.getSituacao() != null || informacoesAdicionaisXmlDTO.getNumeroProcesso() != null || informacoesAdicionaisXmlDTO.getResponsavelProjeto() != null || informacoesAdicionaisXmlDTO.getResponsavelTecnico() != null || informacoesAdicionaisXmlDTO.getEspecificacao() != null || informacoesAdicionaisXmlDTO.getObservacao() != null) {
            return informacoesAdicionaisXmlDTO;
        }
        return null;
    }

    private static ProprietarioObraXmlDTO getProprietarioObra(SisObraAlvara alvara) {
        ProprietarioObraXmlDTO proprietarioObraXmlDTO = new ProprietarioObraXmlDTO();
        if (alvara.getCpfProprietarioObra() != null && !alvara.getCpfProprietarioObra().isEmpty()) {
            proprietarioObraXmlDTO.setCpf(alvara.getCpfProprietarioObra());
        }
        if (alvara.getCnpjProprietarioObra() != null && !alvara.getCnpjProprietarioObra().isEmpty()) {
            proprietarioObraXmlDTO.setCnpj(alvara.getCnpjProprietarioObra());
        }
        return proprietarioObraXmlDTO;
    }

    private static AreaItemXmlDTO getListArea(List<SisObraAlvaraArea> alvaraAreas) {
        AreaItemXmlDTO areaItemXmlDTO = new AreaItemXmlDTO();
        ArrayList<AreaPrincipalItemXmlDTO> areaPrincipalList = new ArrayList<AreaPrincipalItemXmlDTO>();
        ArrayList<AreaComplementarItemXmlDTO> areaComplementarList = new ArrayList<AreaComplementarItemXmlDTO>();
        for (SisObraAlvaraArea alvaraArea : alvaraAreas) {
            if (alvaraArea.getTipo().equals("P")) {
                AreaPrincipalItemXmlDTO areaPrincipalItemXmlDTO = new AreaPrincipalItemXmlDTO();
                areaPrincipalItemXmlDTO.setCategoria(AlvaraAreaCategoria.fromValue((Long)alvaraArea.getCategoria()).getDescricao());
                areaPrincipalItemXmlDTO.setDestinacao(AlvaraAreaDestinacao.fromValue((Long)alvaraArea.getDestinacao()).getDescricao());
                areaPrincipalItemXmlDTO.setTipoObra(AlvaraAreaTipoObra.fromValue((Long)alvaraArea.getTipoObra()).getDescricao());
                if (areaPrincipalItemXmlDTO.getDestinacao().equals(AlvaraAreaDestinacao.CONJUNTO_HABITACIONAL_POPULAR)) {
                    areaPrincipalItemXmlDTO.setQtdTotalUnidadesBloco(String.valueOf(alvaraArea.getQtdTotalUnidade()));
                }
                areaPrincipalItemXmlDTO.setArea(String.format("%.2f", alvaraArea.getArea()).replace(",", "."));
                areaPrincipalList.add(areaPrincipalItemXmlDTO);
            }
            if (!alvaraArea.getTipo().equals("C")) continue;
            AreaComplementarItemXmlDTO areaComplementarItemXmlDTO = new AreaComplementarItemXmlDTO();
            areaComplementarItemXmlDTO.setCategoria(AlvaraAreaCategoria.fromValue((Long)alvaraArea.getCategoria()).getDescricao());
            areaComplementarItemXmlDTO.setDestinacao(AlvaraAreaDestinacao.fromValue((Long)alvaraArea.getDestinacao()).getDescricao());
            areaComplementarItemXmlDTO.setTipoObra(AlvaraAreaTipoObra.fromValue((Long)alvaraArea.getTipoObra()).getDescricao());
            if (areaComplementarItemXmlDTO.getDestinacao().equals(AlvaraAreaDestinacao.CONJUNTO_HABITACIONAL_POPULAR)) {
                areaComplementarItemXmlDTO.setQtdTotalUnidadesBloco(String.valueOf(alvaraArea.getQtdTotalUnidade()));
            }
            areaComplementarItemXmlDTO.setAreaCoberta(String.format("%.2f", alvaraArea.getAreaCoberta()).replace(",", "."));
            areaComplementarItemXmlDTO.setAreaDescoberta(String.format("%.2f", alvaraArea.getAreaDescoberta()).replace(",", "."));
            areaComplementarList.add(areaComplementarItemXmlDTO);
        }
        if (!areaPrincipalList.isEmpty()) {
            areaItemXmlDTO.setAreaPrincipal(areaPrincipalList);
        }
        if (!areaComplementarList.isEmpty()) {
            areaItemXmlDTO.setAreaComplementar(areaComplementarList);
        }
        return areaItemXmlDTO;
    }

    private static EnderecoObraXmlDTO getEnderecoObra(SisObraAlvara alvara) {
        EnderecoObraXmlDTO enderecoObraXmlDTO = new EnderecoObraXmlDTO();
        enderecoObraXmlDTO.setCep(alvara.getObraCep());
        enderecoObraXmlDTO.setTipoLogradouro(alvara.getObraTipoLogradouro());
        enderecoObraXmlDTO.setLogradouro(alvara.getObraLogradouro());
        if (alvara.getObraNumero() != null) {
            enderecoObraXmlDTO.setNumero(alvara.getObraNumero());
        } else {
            enderecoObraXmlDTO.setNumero(String.valueOf(0L));
        }
        if (alvara.getObraComplemento() != null && !alvara.getObraComplemento().isEmpty()) {
            enderecoObraXmlDTO.setComplemento(alvara.getObraComplemento());
        }
        enderecoObraXmlDTO.setBairro(alvara.getObraBairro());
        return enderecoObraXmlDTO;
    }

    private static ResponsavelExecObraXmlDTO getFactoryResponsavelExecObra(SisObraAlvara alvara) {
        ElementoCnpjAndCpfXmlDTO cnpjAndCpf;
        ProprietarioImovelXmlDTO responsavelExecObraXmlDTO = null;
        if (alvara.getTipoVinculo().equals(VINCULO_PROPRIETARIO_IMOVEL)) {
            responsavelExecObraXmlDTO = new ProprietarioImovelXmlDTO();
        }
        if (alvara.getTipoVinculo().equals(VINCULO_DONO_OBRA)) {
            DonoObraXmlDTO donoObraXmlDTO = new DonoObraXmlDTO();
            cnpjAndCpf = new ElementoCnpjAndCpfXmlDTO();
            if (alvara.getCnpjDonoObra() != null && !alvara.getCnpjDonoObra().isEmpty()) {
                cnpjAndCpf.setCnpj(alvara.getCnpjDonoObra());
            }
            if (alvara.getCpfDonoObra() != null && !alvara.getCpfDonoObra().isEmpty()) {
                cnpjAndCpf.setCpf(alvara.getCpfDonoObra());
            }
            donoObraXmlDTO.setCnpjAndCpf(cnpjAndCpf);
            responsavelExecObraXmlDTO = donoObraXmlDTO;
        }
        if (alvara.getTipoVinculo().equals(VINCULO_EMPRESA_CONSTRUTORA)) {
            EmpresaConstrutoraXmlDTO empresaConstrutoraXmlDTO = new EmpresaConstrutoraXmlDTO();
            cnpjAndCpf = new ElementoCnpjAndCpfXmlDTO();
            cnpjAndCpf.setCnpj(alvara.getCnpjEmpresaConstrutora());
            empresaConstrutoraXmlDTO.setCnpjAndCpf(cnpjAndCpf);
            responsavelExecObraXmlDTO = empresaConstrutoraXmlDTO;
        }
        if (alvara.getTipoVinculo().equals(VINCULO_INCORPORADORA_CIVIL)) {
            IncorporadorConstrucaoCivilXmlDTO incorporadorConstrucaoCivilXmlDTO = new IncorporadorConstrucaoCivilXmlDTO();
            cnpjAndCpf = new ElementoCnpjAndCpfXmlDTO();
            if (alvara.getCpfIncorporadorConcivil() != null && !alvara.getCpfIncorporadorConcivil().isEmpty()) {
                cnpjAndCpf.setCnpj(alvara.getCpfIncorporadorConcivil());
            }
            if (alvara.getCnpjIncorporadorConcivil() != null && alvara.getCnpjIncorporadorConcivil().isEmpty()) {
                cnpjAndCpf.setCpf(alvara.getCnpjIncorporadorConcivil());
            }
            incorporadorConstrucaoCivilXmlDTO.setCnpjAndCpf(cnpjAndCpf);
            responsavelExecObraXmlDTO = incorporadorConstrucaoCivilXmlDTO;
        }
        return responsavelExecObraXmlDTO;
    }
}

