/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.core.exception.EloValidationException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class FileUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    public static byte[] zipBytes(Map<String, ArquivoNovoRequest> files) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
        try {
            for (Map.Entry<String, ArquivoNovoRequest> file : files.entrySet()) {
                byte[] byteArray = IOUtils.toByteArray((InputStream)file.getValue().getContent());
                ZipEntry zipEntry = new ZipEntry(file.getKey());
                zipEntry.setSize(byteArray.length);
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.write(byteArray);
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao compactar arquivos em .zip.");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] zipBytes(String filename, byte[] input) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
        ZipEntry zipEntry = new ZipEntry(filename);
        try {
            zipEntry.setSize(input.length);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(input);
            zipOutputStream.closeEntry();
            zipOutputStream.close();
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao compactar arquivo em .zip.");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static File createTempFile(String nome, String extensao, byte[] content) throws IOException {
        Objects.requireNonNull(nome, "O nome do arquivo tempor\u00e1rio precisa ser informado.");
        Objects.requireNonNull(extensao, "A extens\u00e3o do arquivo tempor\u00e1rio precisa ser informada.");
        Path path = Files.createTempFile(nome, extensao, new FileAttribute[0]);
        return Files.write(path, content, StandardOpenOption.CREATE).toFile();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String unzipFileToString(byte[] bytes, String nomeArquivo) {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
            String string;
            try (ZipInputStream zipInputStream = new ZipInputStream(byteArrayInputStream);){
                ZipEntry arquivo;
                StringBuilder conteudoArquivo = new StringBuilder();
                while ((arquivo = zipInputStream.getNextEntry()) != null) {
                    String linha;
                    if (!arquivo.getName().equals(nomeArquivo)) continue;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)zipInputStream, StandardCharsets.UTF_8));
                    while ((linha = bufferedReader.readLine()) != null) {
                        conteudoArquivo.append(linha).append("\n");
                    }
                    zipInputStream.closeEntry();
                }
                string = conteudoArquivo.toString();
            }
            return string;
        }
        catch (Exception e) {
            throw new EloValidationException(String.format("Falha ao descompactar arquivo zip. Erro: %s", e.getMessage()));
        }
    }

    public static String getFileExtension(String fileName) {
        if (Objects.isNull(fileName) || fileName.trim().isEmpty()) {
            throw new EloValidationException("Nome do arquivo inv\u00e1lido.");
        }
        int ultimoPonto = fileName.lastIndexOf(46);
        if (ultimoPonto == -1) {
            throw new EloValidationException("Extens\u00e3o do arquivo n\u00e3o encontrada.");
        }
        if (ultimoPonto == 0 || ultimoPonto == fileName.length() - 1) {
            throw new EloValidationException("Extens\u00e3o do arquivo inv\u00e1lida.");
        }
        return fileName.substring(ultimoPonto + 1);
    }

    public static String extractFixedLengthField(String line, int startIndex, int length) {
        return line.substring(startIndex, startIndex + length);
    }

    public static Long tryParseLongOrNull(String value) {
        return (Long)FileUtils.convertValueOrNull((String)value, Long::valueOf);
    }

    public static BigDecimal tryParseBigDecimalOrNull(String value) {
        return (BigDecimal)FileUtils.convertValueOrNull((String)value, (T v) -> new BigDecimal(v.replace(",", ".").replaceFirst("^0+(?!$)", "")));
    }

    public static LocalDate tryParseLocalDateOrNull(String value, String datePattern) {
        return (LocalDate)FileUtils.convertValueOrNull((String)value, (T v) -> FileUtils.parseLocalDateValue((String)v, (String)datePattern));
    }

    private static LocalDate parseLocalDateValue(String value, String pattern) {
        return LocalDate.parse(value, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDateTime tryParseLocalDateTimeOrNull(String value, String dateTimePattern) {
        return (LocalDateTime)FileUtils.convertValueOrNull((String)value, (T v) -> FileUtils.parseLocalDateTimeValue((String)v, (String)dateTimePattern));
    }

    private static LocalDateTime parseLocalDateTimeValue(String value, String pattern) {
        return LocalDateTime.parse(value, DateTimeFormatter.ofPattern(pattern));
    }

    private static <T> T convertValueOrNull(String value, Function<String, T> converter) {
        if (FileUtils.isNullOrEmptyOrZero((String)value)) {
            return null;
        }
        try {
            return converter.apply(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isNullOrEmptyOrZero(String value) {
        return StringUtils.isBlank((CharSequence)value) || "0".equals(value.trim());
    }

    public static void addFilesToExistingZip(Path zipPath, Map<String, byte[]> arquivos) throws IOException {
        if (!Files.exists(zipPath, new LinkOption[0])) {
            log.debug("Arquivo ZIP '{}' n\u00e3o encontrado. Criando um novo com os arquivos especificados.", (Object)zipPath);
            try (FileOutputStream fos = new FileOutputStream(zipPath.toString());
                 ZipOutputStream zos = new ZipOutputStream(fos);){
                for (Map.Entry<String, byte[]> arquivo : arquivos.entrySet()) {
                    ZipEntry zipEntry = new ZipEntry(arquivo.getKey());
                    zipEntry.setSize(arquivo.getValue().length);
                    zos.putNextEntry(zipEntry);
                    zos.write(arquivo.getValue());
                    zos.closeEntry();
                }
            }
            return;
        }
        Path tempZipPath = Files.createTempFile(zipPath.getParent(), "tempZip", ".zip", new FileAttribute[0]);
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(tempZipPath, new OpenOption[0]));){
            if (Files.exists(zipPath, new LinkOption[0]) && Files.size(zipPath) > 0L) {
                try (ZipFile zipFile = new ZipFile(zipPath.toFile());){
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry oldEntry = entries.nextElement();
                        zos.putNextEntry(new ZipEntry(oldEntry.getName()));
                        if (!oldEntry.isDirectory()) {
                            try (InputStream is = zipFile.getInputStream(oldEntry);){
                                int length;
                                byte[] buffer = new byte[1024];
                                while ((length = is.read(buffer)) > 0) {
                                    zos.write(buffer, 0, length);
                                }
                            }
                        }
                        zos.closeEntry();
                        log.debug("Entrada existente '{}' copiada para o ZIP tempor\u00e1rio.", (Object)oldEntry.getName());
                    }
                }
            }
            for (Map.Entry<String, byte[]> arquivo : arquivos.entrySet()) {
                ZipEntry zipEntry = new ZipEntry(arquivo.getKey());
                zipEntry.setSize(arquivo.getValue().length);
                zos.putNextEntry(zipEntry);
                zos.write(arquivo.getValue());
                zos.closeEntry();
            }
        }
        try {
            Files.move(tempZipPath, zipPath, StandardCopyOption.REPLACE_EXISTING);
            log.debug("ZIP original substitu\u00eddo pelo ZIP atualizado.");
        }
        catch (IOException e) {
            Files.deleteIfExists(tempZipPath);
            throw new IOException("Falha ao substituir o arquivo ZIP original: " + e.getMessage(), e);
        }
    }

    @Generated
    private FileUtils() {
    }
}

