/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import br.com.elotech.tributos.calculo.annotations.AutoCompleteDetail;
import br.com.elotech.tributos.calculo.dto.CampoDetalheDTO;
import br.com.elotech.tributos.domain.camposdinamicos.TipoCampo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/*
 * Exception performing whole class analysis ignored.
 */
public class AutoCompleteDetailUtils {
    public static List<CampoDetalheDTO> getCamposFromAnnotation(Class<?> classToExtract) {
        AutoCompleteDetail classAnnotation = classToExtract.getAnnotation(AutoCompleteDetail.class);
        return Stream.of(classToExtract.getDeclaredFields()).filter(field -> field.isAnnotationPresent(AutoCompleteDetail.class)).map(field -> {
            AutoCompleteDetail annotation = field.getAnnotation(AutoCompleteDetail.class);
            return new CampoDetalheDTO(field.getName(), annotation.label(), AutoCompleteDetailUtils.parseClass(field.getType()), classAnnotation.table());
        }).sorted(Comparator.comparing(CampoDetalheDTO::getTabela).thenComparing(CampoDetalheDTO::getNome)).collect(Collectors.toList());
    }

    private static TipoCampo parseClass(Class<?> type) {
        if (Long.class.equals(type)) {
            return TipoCampo.INTEIRO;
        }
        if (Double.class.equals(type) || BigDecimal.class.equals(type)) {
            return TipoCampo.DECIMAL;
        }
        if (Boolean.class.equals(type)) {
            return TipoCampo.BOOLEANO;
        }
        if (LocalDate.class.equals(type) || LocalDateTime.class.equals(type)) {
            return TipoCampo.DATA;
        }
        return TipoCampo.TEXTO;
    }
}

