/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.oxy;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.SituacaoParcela;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.TipoSituacaoParcela;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.dto.GerarDebitoRequestDTO;
import br.com.elotech.tributos.dto.GerarDebitoResponseDTO;
import br.com.elotech.tributos.dto.debito.DebitoTributoDTO;
import br.com.elotech.tributos.params.NextSubdividaValueParams;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.DividaService;
import br.com.elotech.tributos.service.FormaCorrecaoService;
import br.com.elotech.tributos.service.GeraDebitoService;
import br.com.elotech.tributos.service.SituacaoParcelaService;
import br.com.elotech.tributos.service.ws.oxy.OxyAiseTaxaItbiService;
import br.com.elotech.tributos.utils.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OxyAiseDebitoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OxyAiseDebitoService.class);
    private final CadastroGeralService cadastroGeralService;
    private final SituacaoParcelaService situacaoParcelaService;
    private final DividaService dividaService;
    private final FormaCorrecaoService formaCorrecaoService;
    private final DebitoService debitoService;
    private final GeraDebitoService geraDebitoService;
    private final OxyAiseTaxaItbiService oxyAiseTaxaItbiService;
    private static final Logger LOGGER = LoggerFactory.getLogger(OxyAiseDebitoService.class);

    public GerarDebitoResponseDTO geraDebito(GerarDebitoRequestDTO debito) {
        LOGGER.info(String.format("Iniciando gera\u00e7\u00e3o de d\u00e9bito pelo Oxy. %s", debito.toString()));
        try {
            CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)debito.getTipoCadastro()), debito.getCadastroGeral()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado cadastro geral com tipo cadastro: %d e cadastro: %d", debito.getTipoCadastro(), debito.getCadastroGeral())));
            Divida divida = (Divida)this.dividaService.findByEntidadeAndExercicioAndDivida(debito.getEntidade(), debito.getExercicio(), debito.getGuiaRecolhimento()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado d\u00edvida com entidade: %d, exercicio: %d e id: %d", debito.getEntidade(), debito.getExercicio(), debito.getGuiaRecolhimento())));
            if (Objects.nonNull(debito.getSituacaoParcela())) {
                this.validateSituacaoDebitoParcelaSemMovimento(debito, divida);
            }
            return this.createDebito(debito, cadastroGeral, divida).toGerarDebitoResponseDTO();
        }
        catch (Exception ex) {
            throw new EloValidationException(String.format("Falha ao gerar d\u00e9bito %s", ex.getMessage()));
        }
    }

    private void validateSituacaoDebitoParcelaSemMovimento(GerarDebitoRequestDTO debito, Divida divida) {
        SituacaoParcela situacaoParcela = this.situacaoParcelaService.findSituacaoParcelaById(Long.valueOf(debito.getSituacaoParcela().intValue()));
        if (!TipoSituacaoParcela.ABERTO.equals((Object)situacaoParcela.getTipoSituacaoParcela()) && !TipoSituacaoParcela.SEM_MOVIMENTACAO.equals((Object)situacaoParcela.getTipoSituacaoParcela())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel informar uma situa\u00e7\u00e3o da parcela que n\u00e3o seja %s ou %s", TipoSituacaoParcela.ABERTO.getDescricao(), TipoSituacaoParcela.SEM_MOVIMENTACAO.getDescricao()));
        }
        if (TipoSituacaoParcela.SEM_MOVIMENTACAO.equals((Object)situacaoParcela.getTipoSituacaoParcela())) {
            this.validateTipoDivida(divida);
            this.validateValor(debito.getValorPrincipal(), debito.getValorMulta(), debito.getValorJuros(), debito.getValorCorrecao());
        }
    }

    private void validateTipoDivida(Divida divida) {
        if (!TipoDivida.ISS_HOMOLOGADO.equals((Object)divida.getTipoDivida())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar d\u00e9bito com situa\u00e7\u00e3o %s para guias que n\u00e3o sejam de %s", TipoSituacaoParcela.SEM_MOVIMENTACAO.getDescricao(), TipoDivida.ISS_HOMOLOGADO.getDescricao()));
        }
    }

    private void validateValor(BigDecimal valorPrincipal, BigDecimal valorMulta, BigDecimal valorJuros, BigDecimal valorCorrecao) {
        if (BigDecimal.ZERO.compareTo(valorPrincipal) != 0 || BigDecimal.ZERO.compareTo(valorMulta) != 0 || BigDecimal.ZERO.compareTo(valorJuros) != 0 || BigDecimal.ZERO.compareTo(valorCorrecao) != 0) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar d\u00e9bito com situa\u00e7\u00e3o %s e possuir valor maior que 0.", TipoSituacaoParcela.SEM_MOVIMENTACAO.getDescricao()));
        }
    }

    private Debito createDebito(GerarDebitoRequestDTO debito, CadastroGeral cadastroGeral, Divida divida) {
        Long subdivida = this.debitoService.getNextValueSubdivida(NextSubdividaValueParams.of((Long)debito.getTipoCadastro(), (Long)cadastroGeral.getCadastroGeral(), (Long)debito.getExercicio(), (Long)debito.getGuiaRecolhimento()));
        FormaCorrecao formaCorrecao = this.formaCorrecaoService.getFormaCorrecaoPadrao(divida.getId(), debito.getEntidade(), debito.getExercicio());
        String usuario = Optional.ofNullable(SecurityUtils.getUserAise()).orElse(TenantUtils.getAiseWsUserName());
        ArrayList<DebitoTributoDTO> debitoTributoDTOS = new ArrayList<DebitoTributoDTO>();
        if (Objects.nonNull(debito.getReceitaLista())) {
            debitoTributoDTOS.addAll(this.getReceitas(debito));
        } else {
            debitoTributoDTOS.add(DebitoTributoDTO.createReceita((GerarDebitoRequestDTO)debito));
        }
        DebitoManualDTO debitoManualDTO = DebitoManualDTO.from((GerarDebitoRequestDTO)debito, (Divida)divida, (Long)subdivida, (FormaCorrecao)formaCorrecao);
        DebitoManualParcelaDTO debitoManualParcelaDTO = DebitoManualParcelaDTO.fromGerarDebitoRequestDTO((GerarDebitoRequestDTO)debito);
        ArrayList debitoManualTributoDTOs = new ArrayList();
        debitoTributoDTOS.forEach(tributo -> debitoManualTributoDTOs.add(DebitoManualTributoDTO.from((DebitoTributoDTO)tributo, (GerarDebitoRequestDTO)debito)));
        debitoManualDTO.setUsuario(usuario);
        debitoManualDTO.getParcelas().add(debitoManualParcelaDTO);
        debitoManualDTO.getTributos().addAll(debitoManualTributoDTOs);
        if (debito.isDebitoItbi()) {
            List tributosItbi = this.geraReceitasDeTaxaDeItbi(debitoManualDTO, debito.getIdImobiliarioItbi());
            debitoManualDTO.getTributos().addAll(tributosItbi);
        }
        DebitoIdDTO debitoIdDTO = this.geraDebitoService.geraDebitoManual(debitoManualDTO);
        return (Debito)this.debitoService.findOne((Serializable)debitoIdDTO.getIdDebito());
    }

    private List<DebitoTributoDTO> getReceitas(GerarDebitoRequestDTO debito) {
        List receitas = this.getTokensWithCollection(debito.getReceitaLista(), ";");
        ArrayList<DebitoTributoDTO> debitoTributoDTOS = new ArrayList<DebitoTributoDTO>();
        receitas.forEach(receita -> {
            ArrayList valoresReceitaWithDot = new ArrayList();
            List valoresReceita = this.getTokensWithCollection(receita, "|");
            valoresReceita.forEach(valor -> valoresReceitaWithDot.add(valor.replace(",", ".")));
            DebitoTributoDTO debitoTributoDTO = DebitoTributoDTO.fromString(valoresReceitaWithDot);
            debitoTributoDTOS.add(debitoTributoDTO);
        });
        return debitoTributoDTOS;
    }

    private List<String> getTokensWithCollection(String texto, String delim) {
        return Collections.list(new StringTokenizer(texto, delim)).stream().map(String.class::cast).collect(Collectors.toList());
    }

    private List<DebitoManualTributoDTO> geraReceitasDeTaxaDeItbi(DebitoManualDTO debitoRequest, Long idImobiliarioItbi) {
        return this.oxyAiseTaxaItbiService.geraReceitaDasTaxas(debitoRequest, idImobiliarioItbi);
    }

    @Generated
    public OxyAiseDebitoService(CadastroGeralService cadastroGeralService, SituacaoParcelaService situacaoParcelaService, DividaService dividaService, FormaCorrecaoService formaCorrecaoService, DebitoService debitoService, GeraDebitoService geraDebitoService, OxyAiseTaxaItbiService oxyAiseTaxaItbiService) {
        this.cadastroGeralService = cadastroGeralService;
        this.situacaoParcelaService = situacaoParcelaService;
        this.dividaService = dividaService;
        this.formaCorrecaoService = formaCorrecaoService;
        this.debitoService = debitoService;
        this.geraDebitoService = geraDebitoService;
        this.oxyAiseTaxaItbiService = oxyAiseTaxaItbiService;
    }
}

