/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.supersimples.pgfn;

import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.supersimples.pgfn.PgfnConfiguracao;
import br.com.elotech.tributos.domain.supersimples.pgfn.PgfnDadosDebito;
import br.com.elotech.tributos.domain.supersimples.pgfn.PgfnDadosDevedorOriginal;
import br.com.elotech.tributos.domain.supersimples.pgfn.PgfnDadosDevedorPreferencial;
import br.com.elotech.tributos.dto.supersimples.pgfn.PgfnArquivoItemDTO;
import br.com.elotech.tributos.dto.supersimples.pgfn.PgfnArquivoItemEntityDTO;
import br.com.elotech.tributos.enums.supersimples.pgfn.SituacaoItemArquivoPgfn;
import br.com.elotech.tributos.repository.supersimples.pgfn.PgfnDadosDebitoRepository;
import br.com.elotech.tributos.repository.supersimples.pgfn.PgfnDadosDevedorOriginalRepository;
import br.com.elotech.tributos.repository.supersimples.pgfn.PgfnDadosDevedorPreferencialRepository;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.supersimples.pgfn.GeracaoDebitoPgfnService;
import br.com.elotech.tributos.service.supersimples.pgfn.PgfnConfiguracaoService;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Optional;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class PgfnArquivoItemService
extends CrudService<PgfnDadosDebito, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PgfnArquivoItemService.class);
    private final PgfnDadosDebitoRepository pgfnDadosDebitoRepository;
    private final PgfnDadosDevedorPreferencialRepository pgfnDadosDevedorPreferencialRepository;
    private final PgfnDadosDevedorOriginalRepository pgfnDadosDevedorOriginalRepository;
    private final PgfnConfiguracaoService pgfnConfiguracaoService;
    private final CadastroGeralService cadastroGeralService;
    private final GeracaoDebitoPgfnService geracaoDebitoPgfnService;

    public void findItemAndVerificar(Long idItem) {
        PgfnDadosDebito dadosDebito = (PgfnDadosDebito)this.pgfnDadosDebitoRepository.findOne((Object)idItem);
        PgfnArquivoItemEntityDTO item = new PgfnArquivoItemEntityDTO(dadosDebito);
        this.verificarItem(item);
        this.salvarDadosItem(item);
    }

    public void findItemAndProcessar(Long idItem) {
        PgfnDadosDebito dadosDebito = (PgfnDadosDebito)this.pgfnDadosDebitoRepository.findOne((Object)idItem);
        PgfnConfiguracao configuracao = this.pgfnConfiguracaoService.findByEntidadePrincipalAndExercicioAtual();
        PgfnArquivoItemEntityDTO item = new PgfnArquivoItemEntityDTO(dadosDebito);
        this.geracaoDebitoPgfnService.generateNovoDebito(item, configuracao);
        this.salvarDadosItem(item);
    }

    public void verificarItem(PgfnArquivoItemEntityDTO item) {
        try {
            String cnpj = item.getDevedorOriginal().getCnpj();
            Optional cadastroGeral = this.findMaxCadastroMobiliarioOuAvulso(cnpj);
            if (cadastroGeral.isPresent()) {
                this.updateDevedores(item, (CadastroGeral)cadastroGeral.get());
                this.updateSituacaoItem(item, SituacaoItemArquivoPgfn.VALIDADO, null);
            } else {
                String mensagem = String.format("Contribuinte n\u00e3o cadastrado no sistema com cnpj '%s'", cnpj);
                this.updateSituacaoItem(item, SituacaoItemArquivoPgfn.ERRO_VALIDACAO, mensagem);
            }
        }
        catch (Exception e) {
            String mensagem = this.truncateMessageItem(String.format("Erro ao verificar item. Erro: %s", e.getMessage()));
            this.updateSituacaoItem(item, SituacaoItemArquivoPgfn.ERRO_VALIDACAO, mensagem);
        }
    }

    private String truncateMessageItem(String mensagem) {
        int MAX_LENGTH = 1000;
        return mensagem.length() > 1000 ? mensagem.substring(0, 1000) : mensagem;
    }

    private Optional<CadastroGeral> findMaxCadastroMobiliarioOuAvulso(String cnpj) {
        return this.cadastroGeralService.findByPessoaCnpjCpf(cnpj).stream().filter(cadastro -> EnumSet.of(TipoCadastro.MOBILIARIO, TipoCadastro.AVULSO).contains(cadastro.getTipoCadastro())).min(Comparator.comparing(CadastroGeral::getTipoCadastro).thenComparing(CadastroGeral::getCadastroGeral, Comparator.reverseOrder()));
    }

    private void updateDevedores(PgfnArquivoItemEntityDTO item, CadastroGeral cadastro) {
        this.updateDevedorPreferencial(item.getDevedorPreferencial(), cadastro);
        this.updateDevedorOriginal(item.getDevedorOriginal(), cadastro);
    }

    private void updateDevedorPreferencial(PgfnDadosDevedorPreferencial devedor, CadastroGeral cadastro) {
        devedor.setTipoCadastro(cadastro.getTipoCadastro().getValue());
        devedor.setCadastroGeral(cadastro.getCadastroGeral());
    }

    private void updateDevedorOriginal(PgfnDadosDevedorOriginal devedor, CadastroGeral cadastro) {
        devedor.setTipoCadastro(cadastro.getTipoCadastro().getValue());
        devedor.setCadastroGeral(cadastro.getCadastroGeral());
    }

    private void updateSituacaoItem(PgfnArquivoItemEntityDTO item, SituacaoItemArquivoPgfn situacao, String mensagem) {
        item.getDadosDebito().setSituacao(situacao);
        item.getDadosDebito().setMensagem(mensagem);
    }

    private void salvarDadosItem(PgfnArquivoItemEntityDTO item) {
        this.pgfnDadosDebitoRepository.save((Object)item.getDadosDebito());
        this.pgfnDadosDevedorPreferencialRepository.save((Object)item.getDevedorPreferencial());
        this.pgfnDadosDevedorOriginalRepository.save((Object)item.getDevedorOriginal());
    }

    public Page<PgfnArquivoItemDTO> searchItens(Long id, String search, Pageable pageable) {
        String queryId = String.format("pgfnArquivo.id==%d", id);
        String queryFinal = StringUtils.isBlank((CharSequence)search) ? queryId : String.format("(%s) and (%s)", queryId, search);
        Specification specification = RsqlUtils.createSpecFrom((EntityManager)this.getEm(), (String)queryFinal);
        return this.pgfnDadosDebitoRepository.findAll(specification, pageable).map(PgfnArquivoItemDTO::new);
    }

    @Generated
    public PgfnArquivoItemService(PgfnDadosDebitoRepository pgfnDadosDebitoRepository, PgfnDadosDevedorPreferencialRepository pgfnDadosDevedorPreferencialRepository, PgfnDadosDevedorOriginalRepository pgfnDadosDevedorOriginalRepository, PgfnConfiguracaoService pgfnConfiguracaoService, CadastroGeralService cadastroGeralService, GeracaoDebitoPgfnService geracaoDebitoPgfnService) {
        this.pgfnDadosDebitoRepository = pgfnDadosDebitoRepository;
        this.pgfnDadosDevedorPreferencialRepository = pgfnDadosDevedorPreferencialRepository;
        this.pgfnDadosDevedorOriginalRepository = pgfnDadosDevedorOriginalRepository;
        this.pgfnConfiguracaoService = pgfnConfiguracaoService;
        this.cadastroGeralService = cadastroGeralService;
        this.geracaoDebitoPgfnService = geracaoDebitoPgfnService;
    }
}

