/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.supersimples.dassenda;

import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.supersimples.dassenda.DassendaArquivo;
import br.com.elotech.tributos.domain.supersimples.dassenda.DassendaArquivoCalculo;
import br.com.elotech.tributos.dto.supersimples.dassenda.DassendaArquivoCalculoDTO;
import br.com.elotech.tributos.enums.supersimples.dassenda.SituacaoArquivoDassenda;
import br.com.elotech.tributos.enums.supersimples.dassenda.SituacaoCalculoArquivoDassenda;
import br.com.elotech.tributos.repository.supersimples.dassenda.DassendaArquivoCalculoRepository;
import br.com.elotech.tributos.repository.supersimples.dassenda.DassendaArquivoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DassendaArquivoService
extends CrudService<DassendaArquivo, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DassendaArquivoService.class);
    private final DassendaArquivoRepository repository;
    private final DassendaArquivoCalculoRepository calculoRepository;
    private final ParametroGeralService parametroGeralService;
    private final CadastroGeralService cadastroGeralService;
    private final ArquivoStorageFeignClient arquivoStorageFeignClient;

    public DassendaArquivo validateAndSaveArquivo(MultipartFile file) throws IOException {
        this.validateParametroCodigoTomMunicipio();
        String hash = this.calculateHashArquivo(file);
        this.validateHashArquivo(hash);
        DassendaArquivo dassendaArquivo = this.createAndSave(file);
        this.uploadArquivo(dassendaArquivo, file, hash);
        return dassendaArquivo;
    }

    private void validateParametroCodigoTomMunicipio() {
        String codigoTom = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.CODIGO_TOM_MUNICIPIO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (StringUtils.isBlank((CharSequence)codigoTom)) {
            throw new EloValidationException("Par\u00e2metro 'CODIGOTOM' n\u00e3o configurado.");
        }
    }

    private String calculateHashArquivo(MultipartFile file) throws IOException {
        String fileContent = new String(file.getBytes(), StandardCharsets.UTF_8);
        return DigestUtils.sha256Hex((String)fileContent);
    }

    private void validateHashArquivo(String hash) {
        this.repository.findByHash(hash).ifPresent(existingFile -> {
            throw new EloValidationException(String.format("O arquivo j\u00e1 foi importado com o c\u00f3digo %d.", existingFile.getId()));
        });
    }

    private DassendaArquivo createAndSave(MultipartFile file) {
        DassendaArquivo dassendaArquivo = new DassendaArquivo();
        dassendaArquivo.setData(LocalDate.now());
        dassendaArquivo.setUsuario(SecurityUtils.getUserAise());
        dassendaArquivo.setNomeArquivo(file.getOriginalFilename());
        dassendaArquivo.setSituacao(SituacaoArquivoDassenda.CRIADO);
        return (DassendaArquivo)this.save((EloEntity)dassendaArquivo, null);
    }

    private void uploadArquivo(DassendaArquivo dassendaArquivo, MultipartFile file, String hash) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("idDassendaArquivo", dassendaArquivo.getId().toString());
        ArquivoDTO arquivoDTO = new ArquivoDTO(null, file.getOriginalFilename(), SecurityUtils.getUserId(), TipoArquivoEnum.OUTROS, Modulo.OXY_TRIBUTOS, "/dassenda-arquivos", LocalDate.now(), "text/plain", null, null, metadata);
        ArquivoDTO storageResponse = this.arquivoStorageFeignClient.createWithFile(arquivoDTO, file);
        dassendaArquivo.setIdArquivo(storageResponse.getId());
        dassendaArquivo.setHash(hash);
        this.save((EloEntity)dassendaArquivo, null);
    }

    private void updateSituacaoArquivo(Long id, SituacaoArquivoDassenda situacao) {
        DassendaArquivo dassendaArquivo = (DassendaArquivo)this.findOne((Serializable)id);
        dassendaArquivo.setSituacao(situacao);
        if (SituacaoArquivoDassenda.ERRO_IMPORTACAO.equals((Object)situacao)) {
            dassendaArquivo.setHash(null);
        }
        this.save((EloEntity)dassendaArquivo, null);
    }

    public void iniciarImportacao(Long id) {
        this.updateSituacaoArquivo(id, SituacaoArquivoDassenda.IMPORTANDO);
    }

    public void finalizarImportacao(Long id) {
        this.updateSituacaoArquivo(id, SituacaoArquivoDassenda.IMPORTADO);
    }

    public void finalizarImportacaoComErro(Long id) {
        this.updateSituacaoArquivo(id, SituacaoArquivoDassenda.ERRO_IMPORTACAO);
    }

    public void iniciarValidacao(Long id) {
        this.updateSituacaoArquivo(id, SituacaoArquivoDassenda.VALIDANDO);
    }

    public void finalizarValidacao(Long id) {
        this.updateSituacaoArquivo(id, SituacaoArquivoDassenda.VALIDADO);
    }

    public void finalizarValidacaoComErro(Long id) {
        this.updateSituacaoArquivo(id, SituacaoArquivoDassenda.ERRO_VALIDACAO);
    }

    public void findCalculoAndVerificar(Long id) {
        DassendaArquivoCalculo calculo = (DassendaArquivoCalculo)this.calculoRepository.findOne((Object)id);
        this.verificarCalculo(calculo);
        this.calculoRepository.save((Object)calculo);
    }

    private String getCnpjCpfbyCalculo(DassendaArquivoCalculo calculo) {
        return !StringUtils.isBlank((CharSequence)calculo.getCnpjMatriz()) ? calculo.getCnpjMatriz() : calculo.getCpf().toString();
    }

    public void verificarCalculo(DassendaArquivoCalculo calculo) {
        try {
            String cnpjCpf = this.getCnpjCpfbyCalculo(calculo);
            Optional cadastroGeral = this.findMaxCadastro(cnpjCpf);
            if (cadastroGeral.isPresent()) {
                this.updateSituacaoCalculo(calculo, SituacaoCalculoArquivoDassenda.VALIDADO, null);
            } else {
                String mensagem = "Contribuinte n\u00e3o cadastrado no sistema.";
                this.updateSituacaoCalculo(calculo, SituacaoCalculoArquivoDassenda.ERRO_VALIDACAO, mensagem);
            }
        }
        catch (Exception e) {
            String mensagem = this.truncateMessageItem(String.format("Erro ao verificar item. Erro: %s", e.getMessage()));
            this.updateSituacaoCalculo(calculo, SituacaoCalculoArquivoDassenda.ERRO_VALIDACAO, mensagem);
        }
    }

    private void updateSituacaoCalculo(DassendaArquivoCalculo calculo, SituacaoCalculoArquivoDassenda situacao, String mensagem) {
        calculo.setSituacao(situacao);
        calculo.setMensagem(mensagem);
    }

    private Optional<CadastroGeral> findMaxCadastro(String cnpj) {
        return this.cadastroGeralService.findByPessoaCnpjCpf(cnpj).stream().max(Comparator.comparing(CadastroGeral::getCadastroGeral));
    }

    private String truncateMessageItem(String mensagem) {
        int MAX_LENGTH = 1000;
        return mensagem.length() > 1000 ? mensagem.substring(0, 1000) : mensagem;
    }

    public Page<DassendaArquivoCalculoDTO> searchCalculos(Long id, String search, Pageable pageable) {
        String queryId = String.format("dassendaArquivo.id==%d", id);
        String queryFinal = org.openl.util.StringUtils.isBlank((CharSequence)search) ? queryId : String.format("(%s) and (%s)", queryId, search);
        Specification specification = RsqlUtils.createSpecFrom((EntityManager)this.getEm(), (String)queryFinal);
        return this.calculoRepository.findAll(specification, pageable).map(DassendaArquivoCalculoDTO::new);
    }

    public Optional<DassendaArquivoCalculo> findCalculoById(Long id) {
        return this.calculoRepository.findById((Object)id);
    }

    @Generated
    public DassendaArquivoService(DassendaArquivoRepository repository, DassendaArquivoCalculoRepository calculoRepository, ParametroGeralService parametroGeralService, CadastroGeralService cadastroGeralService, ArquivoStorageFeignClient arquivoStorageFeignClient) {
        this.repository = repository;
        this.calculoRepository = calculoRepository;
        this.parametroGeralService = parametroGeralService;
        this.cadastroGeralService = cadastroGeralService;
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
    }
}

