/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.supersimples;

import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacao;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoCnae;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoCnaeId;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoCnpj;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoCnpjId;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ImportacaoSuperSimplesService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoSuperSimplesService.class);
    private final EntityManager entityManager;

    public void processarBatch(SuperSimplesSolicitacaoCnpj item, Long idSolicitacao, long sequencia) {
        SuperSimplesSolicitacao solicitacao = (SuperSimplesSolicitacao)this.entityManager.getReference(SuperSimplesSolicitacao.class, (Object)idSolicitacao);
        this.createSolicitacaoCnpj(item, solicitacao, sequencia);
    }

    private void createSolicitacaoCnpj(SuperSimplesSolicitacaoCnpj item, SuperSimplesSolicitacao solicitacao, long sequencia) {
        SuperSimplesSolicitacaoCnpjId superSimplesSolicitacaoCnpjId = new SuperSimplesSolicitacaoCnpjId();
        superSimplesSolicitacaoCnpjId.setSolicitacao(solicitacao);
        superSimplesSolicitacaoCnpjId.setSequencia(Long.valueOf(sequencia));
        item.setId(superSimplesSolicitacaoCnpjId);
        for (SuperSimplesSolicitacaoCnae cnae : item.getCnaes()) {
            this.createSolicitacaoCnae(cnae, solicitacao, sequencia);
            cnae.setSolicitacaoCnpj(item);
        }
    }

    private void createSolicitacaoCnae(SuperSimplesSolicitacaoCnae cnae, SuperSimplesSolicitacao solicitacao, long sequencia) {
        SuperSimplesSolicitacaoCnaeId superSimplesSolicitacaoCnaeId = new SuperSimplesSolicitacaoCnaeId();
        superSimplesSolicitacaoCnaeId.setSolicitacao(solicitacao);
        superSimplesSolicitacaoCnaeId.setSequencia(Long.valueOf(sequencia));
        superSimplesSolicitacaoCnaeId.setCnae(cnae.getId().getCnae());
        cnae.setId(superSimplesSolicitacaoCnaeId);
    }

    @Generated
    public ImportacaoSuperSimplesService(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

