/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.supersimples;

import br.com.elotech.tributos.enums.supersimples.TipoOperacaoSuperSimplesSolicitacao;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.time.LocalDate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;

public class ArquivoCnpjVedadosSuperSimples {
    private ByteArrayOutputStream outStream;
    private ZipOutputStream zipOutStream;
    private String nomeArquivo;

    public ArquivoCnpjVedadosSuperSimples(String tipoOperacao) {
        try {
            this.nomeArquivo = this.getNomeArquivo(tipoOperacao);
            this.outStream = new ByteArrayOutputStream();
            this.zipOutStream = new ZipOutputStream(this.outStream);
            ZipEntry e = new ZipEntry(this.nomeArquivo);
            this.zipOutStream.putNextEntry(e);
        }
        catch (IOException ex) {
            throw new RuntimeException("N\u00e3o foi poss\u00edvel criar o arquivo CNPJ vedados para super simples.", ex);
        }
    }

    private String getNomeArquivo(String tipoOperacao) {
        LocalDate dataAtual = LocalDate.now();
        if (TipoOperacaoSuperSimplesSolicitacao.INICIAL.getDescricao().equals(tipoOperacao)) {
            return String.format("CNPJsVedados_%s.txt", dataAtual);
        }
        if (TipoOperacaoSuperSimplesSolicitacao.COMPLEMENTAR.getDescricao().equals(tipoOperacao)) {
            return String.format("CNPJsVedadosComplementar_%s.txt", dataAtual);
        }
        return String.format("CNPJsVedadosExclusao_%s.txt", dataAtual);
    }

    private void escreverLinha(String ... campos) {
        String linha = String.join((CharSequence)"", campos) + "\n";
        try {
            byte[] data = linha.getBytes();
            this.zipOutStream.write(data, 0, data.length);
        }
        catch (IOException ex) {
            throw new RuntimeException("Erro ao escrever no arquivo CNPJ vedados para super simples.", ex);
        }
    }

    public void gerarCabecalho(String tipoOperacao) {
        if (TipoOperacaoSuperSimplesSolicitacao.INICIAL.getDescricao().equals(tipoOperacao)) {
            this.escreverLinha(new String[]{"INI00000000000"});
        } else if (TipoOperacaoSuperSimplesSolicitacao.COMPLEMENTAR.getDescricao().equals(tipoOperacao)) {
            this.escreverLinha(new String[]{"ADC00000000000"});
        } else if (TipoOperacaoSuperSimplesSolicitacao.EXCLUSAO.getDescricao().equals(tipoOperacao)) {
            this.escreverLinha(new String[]{"EXC00000000000"});
        }
    }

    public void gerarRodape() {
        this.escreverLinha(new String[]{"99999999999999"});
    }

    public void gerarDetalhe(String cnpj) {
        this.escreverLinha(new String[]{cnpj});
    }

    public void finalizarGeracaoArquivo() {
        try {
            this.zipOutStream.closeEntry();
            this.zipOutStream.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Erro ao finalizar gera\u00e7\u00e3o do arquivo CNPJ vedados para super simples.", ex);
        }
    }

    @Generated
    public ByteArrayOutputStream getOutStream() {
        return this.outStream;
    }

    @Generated
    public String getNomeArquivo() {
        return this.nomeArquivo;
    }
}

