/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.validacaoregrasimportacao;

import br.com.elotech.tributos.domain.simam.validacoes.ErrosImportacaoSIMAM;
import br.com.elotech.tributos.dto.simam.validacaoimportacao.EstornoDeducaoCreditoDaValidacaoDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.stereotype.Service;

@Service
public class EstornoDeducaoCreditoDaValidacaoAmService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EstornoDeducaoCreditoDaValidacaoAmService.class);
    private static final Long ESCOPO_LEI_MUNICIPAIS = 22L;
    private static final Long EXERCICIO_VALIDACAO_DIVIDA = 2023L;

    public List<ErrosImportacaoSIMAM> validate(EstornoDeducaoCreditoDaValidacaoDTO estornoDeducaoCreditoDaValidacaoDTO, StepExecution stepExecution) {
        log.debug("Iniciando valida\u00e7\u00e3o de EstornoDeducaoDividaAtiva do registro {}", (Object)estornoDeducaoCreditoDaValidacaoDTO);
        ArrayList<Optional> erros = new ArrayList<Optional>();
        erros.add(this.validateRegistroEstornoDuplicado(estornoDeducaoCreditoDaValidacaoDTO));
        erros.add(this.validateDeducao(estornoDeducaoCreditoDaValidacaoDTO));
        erros.add(this.validateLeiAto(estornoDeducaoCreditoDaValidacaoDTO));
        erros.add(this.validateDataEstorno(estornoDeducaoCreditoDaValidacaoDTO, stepExecution));
        erros.add(this.validateValorEstorno(estornoDeducaoCreditoDaValidacaoDTO));
        erros.add(this.validateDescricaoMotivo(estornoDeducaoCreditoDaValidacaoDTO));
        erros.add(this.validateRegistroDeducaoDuplicado(estornoDeducaoCreditoDaValidacaoDTO));
        erros.add(this.validateVinculoAnoDivida(estornoDeducaoCreditoDaValidacaoDTO));
        return erros.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<ErrosImportacaoSIMAM> validateRegistroEstornoDuplicado(EstornoDeducaoCreditoDaValidacaoDTO estornoDeducaoCreditoDaValidacaoDTO) {
        if (estornoDeducaoCreditoDaValidacaoDTO.getQtdRegistrosEstorno() > 1L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)estornoDeducaoCreditoDaValidacaoDTO.getIdTceDeducaoCreditoDaEst(), (String)"O conjunto (nrEstorno e nrAnoEstorno) declarado na tabela (EstornoDeducaoDividaAtiva) apresenta-se com registro duplicado.", (Long)1397L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateDeducao(EstornoDeducaoCreditoDaValidacaoDTO estornoDeducaoCreditoDaValidacaoDTO) {
        if (Objects.isNull(estornoDeducaoCreditoDaValidacaoDTO.getNrDeducao()) || Objects.isNull(estornoDeducaoCreditoDaValidacaoDTO.getNrAnoDeducao())) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)estornoDeducaoCreditoDaValidacaoDTO.getIdTceDeducaoCreditoDaEst(), (String)"O N\u00famero e Ano da Dedu\u00e7\u00e3o da D\u00edvida Ativa (nrDeducao e nrAnoDeducao) declarados na tabela (EstornoDeducaoDividaAtiva) n\u00e3o existem na tabela (DeducaoDividaAtiva).", (Long)1398L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateLeiAto(EstornoDeducaoCreditoDaValidacaoDTO estornoDeducaoCreditoDaValidacaoDTO) {
        if (Objects.isNull(estornoDeducaoCreditoDaValidacaoDTO.getEscopolei()) || !estornoDeducaoCreditoDaValidacaoDTO.getEscopolei().equals(ESCOPO_LEI_MUNICIPAIS)) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)estornoDeducaoCreditoDaValidacaoDTO.getIdTceDeducaoCreditoDaEst(), (String)"O Controle de Lei/Ato (cdControleLeiAto) declarado na tabela (EstornoDeducaoDividaAtiva) n\u00e3o existe na tabela (LeiAto) com (idEscopo) = 22.", (Long)1399L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateDataEstorno(EstornoDeducaoCreditoDaValidacaoDTO estornoDeducaoCreditoDaValidacaoDTO, StepExecution stepExecution) {
        LocalDate dataReferencia = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        if (Objects.isNull(estornoDeducaoCreditoDaValidacaoDTO.getDtEstorno()) || Objects.isNull(estornoDeducaoCreditoDaValidacaoDTO.getDtDeducao()) || estornoDeducaoCreditoDaValidacaoDTO.getDtEstorno().isBefore(estornoDeducaoCreditoDaValidacaoDTO.getDtDeducao()) || YearMonth.from(estornoDeducaoCreditoDaValidacaoDTO.getDtEstorno()).isAfter(YearMonth.from(dataReferencia))) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)estornoDeducaoCreditoDaValidacaoDTO.getIdTceDeducaoCreditoDaEst(), (String)"A data do estorno da dedu\u00e7\u00e3o da d\u00edvida ativa (dtEstorno) declarada na tabela (EstornoDeducaoDividaAtiva) n\u00e3o pode ser menor que (dtDeducao) informada na tabela (DeducaoDividaAtiva) e nem maior que o m\u00eas/ano de trabalho.", (Long)1400L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateValorEstorno(EstornoDeducaoCreditoDaValidacaoDTO estornoDeducaoCreditoDaValidacaoDTO) {
        if (Objects.isNull(estornoDeducaoCreditoDaValidacaoDTO.getVlEstorno()) || estornoDeducaoCreditoDaValidacaoDTO.getVlEstorno().signum() == -1) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)estornoDeducaoCreditoDaValidacaoDTO.getIdTceDeducaoCreditoDaEst(), (String)"O valor do estorno da dedu\u00e7\u00e3o da d\u00edvida ativa (vlEstorno) declarado na tabela (EstornoDeducaoDividaAtiva) n\u00e3o pode ser negativo.", (Long)1401L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateDescricaoMotivo(EstornoDeducaoCreditoDaValidacaoDTO estornoDeducaoCreditoDaValidacaoDTO) {
        if (Objects.isNull(estornoDeducaoCreditoDaValidacaoDTO.getDsMotivo()) || estornoDeducaoCreditoDaValidacaoDTO.getDsMotivo().length() < 20) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)estornoDeducaoCreditoDaValidacaoDTO.getIdTceDeducaoCreditoDaEst(), (String)"A descri\u00e7\u00e3o do motivo do estorno da dedu\u00e7\u00e3o da d\u00edvida ativa (dsMotivo) declarado na tabela (EstornoDeducaoDividaAtiva) deve possuir no m\u00ednimo 20 (vinte) caracteres.", (Long)1402L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateRegistroDeducaoDuplicado(EstornoDeducaoCreditoDaValidacaoDTO estornoDeducaoCreditoDaValidacaoDTO) {
        if (Objects.isNull(estornoDeducaoCreditoDaValidacaoDTO.getQtdRegistrosEstornoDeducao()) || estornoDeducaoCreditoDaValidacaoDTO.getQtdRegistrosEstornoDeducao() > 1L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)estornoDeducaoCreditoDaValidacaoDTO.getIdTceDeducaoCreditoDaEst(), (String)"O registro da tabela (EstornoDeducaoDividaAtiva) para o conjunto (nrAnoEstorno, nrDeducao,nrAnoDeducao, cdControleLeiAto, dtEstorno) n\u00e3o pode ser duplicado.", (Long)2239L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateVinculoAnoDivida(EstornoDeducaoCreditoDaValidacaoDTO estornoDeducaoCreditoDaValidacaoDTO) {
        if (Objects.isNull(estornoDeducaoCreditoDaValidacaoDTO.getNrAnoDivida()) || estornoDeducaoCreditoDaValidacaoDTO.getNrAnoDivida() < EXERCICIO_VALIDACAO_DIVIDA) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)estornoDeducaoCreditoDaValidacaoDTO.getIdTceDeducaoCreditoDaEst(), (String)"O registro da tabela (EstornoDeducaoDividaAtiva) n\u00e3o pode estar vinculado com ano de d\u00edvida (nrAnoDivida) menor que o exerc\u00edcio financeiro de 2023.", (Long)2252L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }
}

