/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.projeto;

import br.com.elotech.tributos.domain.projeto.Projeto;
import br.com.elotech.tributos.domain.projeto.ProjetoItem;
import br.com.elotech.tributos.domain.projeto.ProjetoPK;
import br.com.elotech.tributos.dto.DocumentoCertidaoItemDTO;
import br.com.elotech.tributos.repository.projeto.ProjetoRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.exception.projeto.ProjetoNotFoundException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ProjetoItemService {
    private final ProjetoRepository projetoRepository;
    private final ContextService contextService;

    public List<DocumentoCertidaoItemDTO> loadItensDocumentoCertidao(Long numeroProjeto, Long exercicioProjeto) {
        ProjetoPK projetoPK = new ProjetoPK();
        projetoPK.setEntidade(this.contextService.getEntidadePrincipal());
        projetoPK.setProjeto(numeroProjeto);
        projetoPK.setExercicio(exercicioProjeto);
        Projeto projeto = (Projeto)this.projetoRepository.findById((Object)projetoPK).orElseThrow(() -> new ProjetoNotFoundException(projetoPK));
        return Optional.ofNullable(projeto.getItens()).stream().flatMap(Collection::stream).map(arg_0 -> this.buildItemDocumentoCertidao(arg_0)).collect(Collectors.toList());
    }

    private DocumentoCertidaoItemDTO buildItemDocumentoCertidao(ProjetoItem projetoItem) {
        DocumentoCertidaoItemDTO dto = new DocumentoCertidaoItemDTO();
        Optional.ofNullable(projetoItem.getTipoSegmento()).ifPresent(tipo -> dto.setIdTipoSegmento(tipo.getId()));
        Optional.ofNullable(projetoItem.getUtilizacao()).ifPresent(util -> dto.setIdUtilizacao(util.getId()));
        Optional.ofNullable(projetoItem.getTipoConstrucao()).ifPresent(tipo -> dto.setIdTipoConstrucao(tipo.getId()));
        dto.setArea(projetoItem.getArea());
        dto.setAreaCoberta(projetoItem.getAreaCoberta());
        dto.setAreaDescoberta(projetoItem.getAreaDescoberta());
        dto.setAtualizado(Boolean.FALSE);
        dto.setRegular(Boolean.FALSE);
        return dto;
    }

    @Generated
    public ProjetoItemService(ProjetoRepository projetoRepository, ContextService contextService) {
        this.projetoRepository = projetoRepository;
        this.contextService = contextService;
    }
}

