/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.manutencaobancariacef;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.soap.webservice.caixa.manutencao.DadosSaidaType;
import br.com.elotech.soap.webservice.caixa.manutencao.IncluiBoletoSaidaType;
import br.com.elotech.soap.webservice.caixa.manutencao.ServicoEntradaNegocialType;
import br.com.elotech.soap.webservice.caixa.manutencao.ServicoSaidaNegocialType;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.TipoCodigoBarras;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.domain.registroboletoonline.ErroBoletoRegistroOnline;
import br.com.elotech.tributos.dto.CodigoBarrasDTO;
import br.com.elotech.tributos.exception.ManutencaoBancariaCEFException;
import br.com.elotech.tributos.repository.BancoRepository;
import br.com.elotech.tributos.repository.cnab240.ParametroCNAB240Repository;
import br.com.elotech.tributos.repository.registroboletoonline.ErroBoletoRegistradoOnlineRepository;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoBoletoRegistrado;
import br.com.elotech.tributos.ws.soap.client.ManutencaoBancariaCEFClient;
import br.com.elotech.tributos.ws.soap.client.dto.ManutecaoCobrancaBancariaCEFDTO;
import br.gov.caixa.sibar.CONTROLENEGOCIALTYPE;
import br.gov.caixa.sibar.MensagensControleNegocialType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ManutencaoBancariaCEFService
implements IntegracaoBoletoRegistrado {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ManutencaoBancariaCEFService.class);
    private static final String CODIGO_RETORNO_SUCESSO = "00";
    private static final String MENSAGEM_ERRO_ENVIO_BOLETO_REGISTRADO_PARA_CEF = "Erro ao enviar o boleto registrado para CEF";
    private static final String MODALIDADE_CARTEIRA_CEF = "14";
    private static final Integer CODIGO_RETORNO_SUCESSO_CONTROLE_NEGOCIO = 0;
    private final ManutencaoBancariaCEFClient manutencaoBancariaCEFClient;
    private final ErroBoletoRegistradoOnlineRepository erroBoletoRegistradoOnlineRepository;
    private final ParametroCNAB240Repository parametroCNAB240Repository;
    private final BancoRepository bancoRepository;
    private final ObjectMapper mapper;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);

    public ParametroCNAB240 getParametroCnab240ByBanco() {
        return this.parametroCNAB240Repository.findByBanco((Banco)this.bancoRepository.findOne((Object)Banco.CODIGO_CAIXA_ECONOMICA)).stream().filter(Objects::nonNull).findFirst().orElseThrow(() -> new EloValidationException("Par\u00e2metro CNAB 240 n\u00e3o encontrado para o banco CEF!"));
    }

    public CodigoBarrasDTO generateBoleto(Bloqueto boleto, ParametroCNAB240 parametroCNAB240) {
        CodigoBarrasDTO codigoBarrasDTO = new CodigoBarrasDTO();
        try {
            if (Objects.isNull(boleto)) {
                throw new EloValidationException("Boleto n\u00e3o informado!");
            }
            log.debug("generateBoleto - Boleto - id: {}, bloqueto: {}, exercicio: {}, tipoCadastro: {}, cadastroGeral: {}, nossoNumero: {}, dataVencimento: {}, valor: {}", new Object[]{boleto.getId(), boleto.getBloqueto(), boleto.getExercicioBloqueto(), Optional.ofNullable(boleto.getCadastroGeral()).map(c -> c.getTipoCadastro().getValue()).orElse(0L), Optional.ofNullable(boleto.getCadastroGeral()).map(CadastroGeral::getCadastroGeral).orElse(0L), boleto.getNossoNumero(), boleto.getDataVencimento(), boleto.getValorBloqueto()});
            this.validarModeloBoletoEntidadeRegistro(boleto);
            Entidade entidade = boleto.getModeloBloqueto().getConvenio().getEntidadeRegistro();
            log.debug("generateBoleto - Entidade - entidade: {}, cnpj: {}", (Object)entidade.getId(), (Object)entidade.getCnpj());
            ServicoEntradaNegocialType request = ManutecaoCobrancaBancariaCEFDTO.from((Bloqueto)boleto, (ParametroCNAB240)parametroCNAB240, (Entidade)entidade).getRequest();
            ServicoSaidaNegocialType response = this.manutencaoBancariaCEFClient.includeRegistryBoleto(request);
            if (this.isResponseSucess(response)) {
                log.info("Boleto registrado CEF enviado com sucesso!");
                codigoBarrasDTO.setCodigoBarras((String)Optional.ofNullable(response.getDADOS()).map(DadosSaidaType::getINCLUIBOLETO).map(IncluiBoletoSaidaType::getCODIGOBARRAS).orElse(null));
                codigoBarrasDTO.setLinhaDigitavel((String)Optional.ofNullable(response.getDADOS()).map(DadosSaidaType::getINCLUIBOLETO).map(IncluiBoletoSaidaType::getLINHADIGITAVEL).orElse(null));
                codigoBarrasDTO.setCampo1(StringUtils.substring((String)codigoBarrasDTO.getLinhaDigitavel(), (int)0, (int)10));
                codigoBarrasDTO.setCampo2(StringUtils.substring((String)codigoBarrasDTO.getLinhaDigitavel(), (int)10, (int)21));
                codigoBarrasDTO.setCampo3(StringUtils.substring((String)codigoBarrasDTO.getLinhaDigitavel(), (int)21, (int)32));
                codigoBarrasDTO.setCampo4(StringUtils.substring((String)codigoBarrasDTO.getLinhaDigitavel(), (int)32, (int)33));
                codigoBarrasDTO.setCampo5(StringUtils.substring((String)codigoBarrasDTO.getLinhaDigitavel(), (int)33, (int)47));
                codigoBarrasDTO.setNossoNumero(boleto.getNossoNumero());
                codigoBarrasDTO.generateCodigoBarrasFormatadoIntervalo2Of5();
                codigoBarrasDTO.generateDigitoVerificadorMod11(boleto.getModalidadeCarteira());
                if (boleto.getModeloBloqueto().getConvenio().getUtilizaPix().booleanValue()) {
                    boleto.setTextoQrCode((String)Optional.ofNullable(response.getDADOS()).map(DadosSaidaType::getINCLUIBOLETO).map(IncluiBoletoSaidaType::getQRCODE).orElse(null));
                }
                return codigoBarrasDTO;
            }
            this.insertErroRegistroBoletoOnline(request, response, boleto, this.getErrorResponse(response));
            throw new EloValidationException(this.getErrorResponse(response));
        }
        catch (Exception ex) {
            String mensagemError = String.format("%s: %s", MENSAGEM_ERRO_ENVIO_BOLETO_REGISTRADO_PARA_CEF, ex.getMessage());
            log.error(mensagemError, (Throwable)ex);
            throw new ManutencaoBancariaCEFException(HttpStatus.BAD_REQUEST, mensagemError, ex);
        }
    }

    private boolean isResponseSucess(ServicoSaidaNegocialType response) {
        return Objects.nonNull(response) && Objects.nonNull(response.getCODRETORNO()) && response.getCODRETORNO().equals(CODIGO_RETORNO_SUCESSO) && Objects.nonNull(response.getDADOS()) && Optional.ofNullable(response.getDADOS().getCONTROLENEGOCIAL()).filter(controleNegocial -> !controleNegocial.isEmpty()).map(controleNegocial -> (CONTROLENEGOCIALTYPE)controleNegocial.get(CODIGO_RETORNO_SUCESSO_CONTROLE_NEGOCIO)).map(CONTROLENEGOCIALTYPE::getCODRETORNO).map(codRetorno -> codRetorno.equals(CODIGO_RETORNO_SUCESSO_CONTROLE_NEGOCIO.toString())).orElse(false) != false;
    }

    private String getErrorResponse(ServicoSaidaNegocialType response) {
        if (Objects.isNull(response)) {
            return "Retorno da integra\u00e7\u00e3o boleto registrado CEF inv\u00e1lido!";
        }
        if (Objects.nonNull(response.getCODRETORNO()) && !response.getCODRETORNO().equals(CODIGO_RETORNO_SUCESSO)) {
            StringBuilder messageError = new StringBuilder(String.format("%s - %s", response.getCODRETORNO(), response.getMSGRETORNO()));
            if (Objects.nonNull(response.getDADOS())) {
                messageError.append(String.format("%n%s", response.getDADOS().getEXCECAO()));
            }
            return messageError.toString();
        }
        if (Objects.nonNull(response.getDADOS()) && Objects.nonNull(response.getDADOS().getCONTROLENEGOCIAL()) && !response.getDADOS().getCONTROLENEGOCIAL().isEmpty()) {
            CONTROLENEGOCIALTYPE businessControl = (CONTROLENEGOCIALTYPE)response.getDADOS().getCONTROLENEGOCIAL().get(CODIGO_RETORNO_SUCESSO_CONTROLE_NEGOCIO);
            return String.format("%s - %s", businessControl.getCODRETORNO(), Optional.ofNullable(businessControl.getMENSAGENS()).map(MensagensControleNegocialType::getRETORNO).orElse(businessControl.getMSGRETORNO()));
        }
        return "";
    }

    private void insertErroRegistroBoletoOnline(ServicoEntradaNegocialType request, ServicoSaidaNegocialType response, Bloqueto boleto, String observacao) {
        try {
            ErroBoletoRegistroOnline erroRegistroBoletoOnlineEntity = new ErroBoletoRegistroOnline();
            erroRegistroBoletoOnlineEntity.setRequest(this.mapper.writeValueAsBytes((Object)request));
            erroRegistroBoletoOnlineEntity.setResponse(this.mapper.writeValueAsBytes((Object)response));
            erroRegistroBoletoOnlineEntity.setDataHoraIntegracao(LocalDateTime.now());
            erroRegistroBoletoOnlineEntity.setIdBoleto(boleto.getId());
            erroRegistroBoletoOnlineEntity.setDetalhes(observacao);
            new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> (ErroBoletoRegistroOnline)this.erroBoletoRegistradoOnlineRepository.save((Object)erroRegistroBoletoOnlineEntity));
        }
        catch (Exception ex) {
            log.error("Erro ao salvar log de emiss\u00e3o resposta no registro de boleto CEF", (Throwable)ex);
        }
    }

    private void validarModeloBoletoEntidadeRegistro(Bloqueto boleto) {
        Convenio convenio = Optional.ofNullable(boleto).map(Bloqueto::getModeloBloqueto).map(ModeloBoleto::getConvenio).orElseThrow(() -> new EloValidationException("N\u00e3o existe um conv\u00eanio vinculado ao modelo de bloqueto!"));
        Optional.ofNullable(convenio.getEntidadeRegistro()).orElseThrow(() -> new EloValidationException(String.format("Necess\u00e1rio vincular a entidade para registro do boleto ao conv\u00eanio %s!", convenio.getNumeroConvenio())));
    }

    public TipoCodigoBarras getTipoCodigoBarras() {
        return TipoCodigoBarras.BOLETO_BANCARIO_CAIXA_SIGCB_REGISTRADA;
    }

    public void beforeGenerateBoleto(Bloqueto boleto) {
        if (StringUtils.isBlank((CharSequence)boleto.getNossoNumero())) {
            boleto.setNossoNumero(String.format("%s%s%s", boleto.getEntidade(), StringUtils.substring((String)boleto.getExercicioBloqueto().toString(), (int)2), StringUtils.leftPad((String)Optional.ofNullable(boleto.getBloqueto()).orElse(0L).toString(), (int)12, (String)"0")));
        }
        boleto.setModalidadeCarteira(MODALIDADE_CARTEIRA_CEF);
    }

    @Generated
    public ManutencaoBancariaCEFService(ManutencaoBancariaCEFClient manutencaoBancariaCEFClient, ErroBoletoRegistradoOnlineRepository erroBoletoRegistradoOnlineRepository, ParametroCNAB240Repository parametroCNAB240Repository, BancoRepository bancoRepository, ObjectMapper mapper, PlatformTransactionManager transactionManager) {
        this.manutencaoBancariaCEFClient = manutencaoBancariaCEFClient;
        this.erroBoletoRegistradoOnlineRepository = erroBoletoRegistradoOnlineRepository;
        this.parametroCNAB240Repository = parametroCNAB240Repository;
        this.bancoRepository = bancoRepository;
        this.mapper = mapper;
        this.transactionManager = transactionManager;
    }
}

