/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaofintelsgo.integracao.impl;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.integracaofintelsgo.CadastroRuralFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.FiltroIntegracaoFintelSgoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.ProprietarioRuralFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.service.integracaofintelsgo.integracao.ClassificacaoIntegracaoFintelSgo;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.util.tuple.TupleUtils;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openl.util.StringUtils;
import org.postgresql.util.PGobject;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;

public class IntegracaoCadastroRuralFintelSgoService
implements ClassificacaoIntegracaoFintelSgo<CadastroRuralFintelSgoIntegracaoDTO> {
    private static final String SQLPATH = "br/com/elotech/tributos/repository/integracaofintelsgo/find-cadastrorural-fintel-sgo.sql";

    private String sourceSqlFile() {
        return FileUtils.readResourceAsString((String)SQLPATH);
    }

    public String getCountSql(FiltroIntegracaoFintelSgoDTO filtro) {
        String sql = this.sourceSqlFile();
        String sqlFiltro = this.getBuildFiltro(filtro.getDataInicial(), filtro.getDataFinal());
        sql = sql.replace(":filtro", sqlFiltro);
        String sqlFinal = sql.replace(":pageable", "");
        return String.format(" WITH totalregistros AS ( %s ) SELECT COUNT(*) FROM totalregistros ", sqlFinal);
    }

    public String getSql(FiltroIntegracaoFintelSgoDTO filtro, Pageable pageable) {
        String sql = this.sourceSqlFile();
        String sqlFiltro = this.getBuildFiltro(filtro.getDataInicial(), filtro.getDataFinal());
        String sqlPagination = this.getSqlPagination(pageable);
        sql = sql.replace(":filtro", sqlFiltro);
        return sql.replace(":pageable", sqlPagination);
    }

    public RowMapper<CadastroRuralFintelSgoIntegracaoDTO> getMapper() {
        return (rs, rowNum) -> {
            CadastroRuralFintelSgoIntegracaoDTO rural = this.mapperRural(rs);
            rural.setProprietarioRural(this.mapperProprietario(rs));
            return rural;
        };
    }

    private CadastroRuralFintelSgoIntegracaoDTO mapperRural(ResultSet rs) throws SQLException {
        CadastroRuralFintelSgoIntegracaoDTO rural = new CadastroRuralFintelSgoIntegracaoDTO();
        Optional.ofNullable(rs.getString("tipoCadastro")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setTipoCadastro(arg_0));
        Optional.ofNullable(rs.getString("cadastroGeral")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setCadastroGeral(arg_0));
        Optional.ofNullable(rs.getString("exclusaoLogica")).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setExclusaoLogica(arg_0));
        Optional.ofNullable(rs.getString("dataInclusao")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setDataInclusao(arg_0));
        Optional.ofNullable(rs.getString("dataAlteracao")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setDataAlteracao(arg_0));
        Optional.ofNullable(rs.getString("cidadeDescr")).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setCidadeDescr(arg_0));
        Optional.ofNullable(rs.getString("pessoa")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setPessoa(arg_0));
        Optional.ofNullable(rs.getString("proprietario")).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setProprietario(arg_0));
        Optional.ofNullable(rs.getString("tipoPessoa")).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setTipoPessoa(arg_0));
        Optional.ofNullable(rs.getString("cnpjCpf")).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setCnpjCpf(arg_0));
        Optional.ofNullable(rs.getString("usuario")).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setUsuario(arg_0));
        Optional.ofNullable(rs.getString("numeroImovelReceita")).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setNumeroImovelReceita(arg_0));
        Optional.ofNullable(rs.getString("codigoIncra")).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setCodigoIncra(arg_0));
        Optional.ofNullable(rs.getString("nome")).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setNome(arg_0));
        Optional.ofNullable(rs.getString("areaTotal")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setAreaTotal(arg_0));
        Optional.ofNullable(rs.getString("areaArrendada")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setAreaArrendada(arg_0));
        Optional.ofNullable(rs.getString("areaCultivo")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setAreaCultivo(arg_0));
        Optional.ofNullable(rs.getString("areaPasto")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setAreaPasto(arg_0));
        Optional.ofNullable(rs.getString("valorTerreno")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setValorTerreno(arg_0));
        Optional.ofNullable(rs.getString("qtdeAlqueires")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setQtdeAlqueires(arg_0));
        Optional.ofNullable(rs.getString("lote")).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setLote(arg_0));
        Optional.ofNullable(rs.getString("matricula")).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setMatricula(arg_0));
        Optional.ofNullable(rs.getString("oficio")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setOficio(arg_0));
        Optional.ofNullable(rs.getString("origemInscricao")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setOrigemInscricao(arg_0));
        Optional.ofNullable(rs.getString("detencao")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setDetencao(arg_0));
        Optional.ofNullable(rs.getString("resideImovel")).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setResideImovel(arg_0));
        Optional.ofNullable(rs.getString("dataAquisicao")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setDataAquisicao(arg_0));
        Optional.ofNullable(rs.getString("distrito")).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setDistrito(arg_0));
        Optional.ofNullable(rs.getString("setor")).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setSetor(arg_0));
        Optional.ofNullable(rs.getString("setorDescr")).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setSetorDescr(arg_0));
        Optional.ofNullable(rs.getString("endereco")).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setEndereco(arg_0));
        Optional.ofNullable(rs.getString("complemento")).ifPresent(arg_0 -> ((CadastroRuralFintelSgoIntegracaoDTO)rural).setComplemento(arg_0));
        return rural;
    }

    private List<ProprietarioRuralFintelSgoIntegracaoDTO> mapperProprietario(ResultSet rs) throws SQLException {
        Object[] proprietarios;
        HashMap<String, ProprietarioRuralFintelSgoIntegracaoDTO> proprietarioMapeado = new HashMap<String, ProprietarioRuralFintelSgoIntegracaoDTO>();
        Array proprietarioArray = rs.getArray("proprietarios");
        if (proprietarioArray == null) {
            return Collections.emptyList();
        }
        for (Object element : proprietarios = (Object[])proprietarioArray.getArray()) {
            List proprietario;
            String id;
            PGobject pgObj;
            String tuple;
            if (!(element instanceof PGobject) || (tuple = (pgObj = (PGobject)element).getValue()) == null || proprietarioMapeado.containsKey(id = String.format("%s-%s-%s", (proprietario = TupleUtils.parse((String)tuple)).get(0), proprietario.get(1), proprietario.get(2)))) continue;
            ProprietarioRuralFintelSgoIntegracaoDTO objectProprietario = new ProprietarioRuralFintelSgoIntegracaoDTO();
            Optional.ofNullable((String)proprietario.get(0)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setTipoCadastro(arg_0));
            Optional.ofNullable((String)proprietario.get(1)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setCadastroGeral(arg_0));
            Optional.ofNullable((String)proprietario.get(2)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setPessoa(arg_0));
            Optional.ofNullable((String)proprietario.get(3)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setTipoPessoa(arg_0));
            Optional.ofNullable((String)proprietario.get(4)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setCnpjCpf(arg_0));
            Optional.ofNullable((String)proprietario.get(5)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setRg(arg_0));
            Optional.ofNullable((String)proprietario.get(6)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setOrgaoEmissor(arg_0));
            Optional.ofNullable((String)proprietario.get(7)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setVinculo(arg_0));
            Optional.ofNullable((String)proprietario.get(8)).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setPercentual(arg_0));
            Optional.ofNullable((String)proprietario.get(9)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setPrincipal(arg_0));
            Optional.ofNullable((String)proprietario.get(10)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setProprietario(arg_0));
            Optional.ofNullable((String)proprietario.get(11)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setVinculoDescr(arg_0));
            Optional.ofNullable((String)proprietario.get(12)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setCidade(arg_0));
            Optional.ofNullable((String)proprietario.get(13)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setEstado(arg_0));
            Optional.ofNullable((String)proprietario.get(14)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setBairro(arg_0));
            Optional.ofNullable((String)proprietario.get(15)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setCep(arg_0));
            Optional.ofNullable((String)proprietario.get(16)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setSigla(arg_0));
            Optional.ofNullable((String)proprietario.get(17)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setNumero(arg_0));
            Optional.ofNullable((String)proprietario.get(18)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setComplemento(arg_0));
            Optional.ofNullable((String)proprietario.get(19)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setTelefoneCelular(arg_0));
            Optional.ofNullable((String)proprietario.get(20)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setTelefoneResidencial(arg_0));
            Optional.ofNullable((String)proprietario.get(21)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setTelefoneComercial(arg_0));
            Optional.ofNullable((String)proprietario.get(22)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setCidadeDescricao(arg_0));
            Optional.ofNullable((String)proprietario.get(23)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setBairroDescricao(arg_0));
            Optional.ofNullable((String)proprietario.get(24)).ifPresent(arg_0 -> ((ProprietarioRuralFintelSgoIntegracaoDTO)objectProprietario).setLogradouroDescricao(arg_0));
            proprietarioMapeado.put(id, objectProprietario);
        }
        ArrayList<ProprietarioRuralFintelSgoIntegracaoDTO> list = new ArrayList<ProprietarioRuralFintelSgoIntegracaoDTO>(proprietarioMapeado.values());
        list.sort(Comparator.comparing(ProprietarioRuralFintelSgoIntegracaoDTO::getId));
        return list;
    }

    private Long parseLong(String value) {
        return StringUtils.isNotBlank((CharSequence)value) ? Long.valueOf(value) : null;
    }

    private BigDecimal parseBigDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private LocalDate parseStringToLocalDate(String data) {
        return Objects.nonNull(data) ? LocalDate.parse(data) : null;
    }

    private String getBuildFiltro(LocalDate dataInicial, LocalDate dataFinal) {
        if (Objects.nonNull(dataInicial) && Objects.nonNull(dataFinal)) {
            String filtro = " and (((':dataInicial' = '1899-12-30') AND (':dataFinal' = '1899-12-30')) OR      (((':dataInicial' <> '1899-12-30') AND (':dataFinal' <> '1899-12-30'))  AND       ((tcg.dataalteracao between ':dataInicial' and ':dataFinal') or        (tcg.dataexclusaologica between ':dataInicial' and ':dataFinal'))))";
            filtro = filtro.replace(":dataInicial", DateUtils.localDateToString((LocalDate)dataInicial));
            filtro = filtro.replace(":dataFinal", DateUtils.localDateToString((LocalDate)dataFinal));
            return filtro;
        }
        return "";
    }

    private String getSqlPagination(Pageable pageable) {
        return "LIMIT " + pageable.getPageSize() + " OFFSET " + pageable.getOffset();
    }
}

