/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaocontabil;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.outbox.domain.EntityEvent;
import br.com.elotech.outbox.domain.OutboxActions;
import br.com.elotech.outbox.publisher.Publisher;
import br.com.elotech.tributos.domain.integracaocontabil.IntegracaoPatrimonial;
import br.com.elotech.tributos.domain.integracaocontabil.IntegracaoPatrimonialPorTipoMovimentoDTO;
import br.com.elotech.tributos.domain.integracaocontabil.ItemIntegracaoPatrimonial;
import br.com.elotech.tributos.domain.movimentacaodiaria.SituacaoMovimentacaoDiaria;
import br.com.elotech.tributos.dto.EntidadeDTO;
import br.com.elotech.tributos.dto.integracaocontabil.IntegracaoPatrimonialContabilidadeDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ItemIntegracaoPatrimonialAgrupadorDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ItemIntegracaoPatrimonialDTO;
import br.com.elotech.tributos.dto.integracaocontabil.SituacaoIntegracaoContabil;
import br.com.elotech.tributos.dto.integracaocontabil.TotalizadorIntegracaoPatrimonialDTO;
import br.com.elotech.tributos.repository.integracaocontabil.IntegracaoPatrimonialRepository;
import br.com.elotech.tributos.repository.integracaocontabil.ItemIntegracaoPatrimonialRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.MovimentacaoDiariaService;
import br.com.elotech.tributos.service.impl.EntidadeServiceImpl;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IntegracaoPatrimonialService
extends CrudService<IntegracaoPatrimonial, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoPatrimonialService.class);
    private final IntegracaoPatrimonialRepository integracaoPatrimonialRepository;
    private final ItemIntegracaoPatrimonialRepository itemIntegracaoPatrimonialRepository;
    private final MovimentacaoDiariaService movimentacaoDiariaService;
    private final EntidadeServiceImpl entidadeService;
    private final Publisher publisher;

    public Optional<IntegracaoPatrimonialContabilidadeDTO> findByIdDTO(Long id) {
        String uf = this.entidadeService.getInfoEntidadePrincipal().map(EntidadeDTO::getUnidadeFederacao).orElse(null);
        return this.integracaoPatrimonialRepository.findById((Object)id).map(ip -> ip.toDto(uf));
    }

    public List<IntegracaoPatrimonial> geraIntegracaoPatrimonial(List<LocalDate> datasMovimento) {
        log.debug("Iniciando integra\u00e7\u00e3o patrimonial das datas {}", datasMovimento);
        List movimentacoes = this.integracaoPatrimonialRepository.findInscricoesDiversas(datasMovimento);
        log.debug("Carregou movimenta\u00e7\u00e3o de inscri\u00e7\u00e3o. Movimenta\u00e7\u00f5es at\u00e9 o momento: {}", (Object)movimentacoes.size());
        movimentacoes.addAll(this.integracaoPatrimonialRepository.findCancelamentos(datasMovimento));
        log.debug("Carregou movimenta\u00e7\u00e3o de cancelamentos. Movimenta\u00e7\u00f5es at\u00e9 o momento: {}", (Object)movimentacoes.size());
        movimentacoes.addAll(this.integracaoPatrimonialRepository.findEstornoCancelamentos(datasMovimento));
        log.debug("Carregou movimenta\u00e7\u00e3o de estorno de cancelamentos. Movimenta\u00e7\u00f5es at\u00e9 o momento: {}", (Object)movimentacoes.size());
        movimentacoes.addAll(this.integracaoPatrimonialRepository.findParcelamentos(datasMovimento));
        log.debug("Carregou movimenta\u00e7\u00e3o de parcelamentos. Movimenta\u00e7\u00f5es at\u00e9 o momento: {}", (Object)movimentacoes.size());
        movimentacoes.addAll(this.integracaoPatrimonialRepository.findEstornosParcelamentos(datasMovimento));
        log.debug("Carregou movimenta\u00e7\u00e3o de estornos de parcelamentos. Movimenta\u00e7\u00f5es at\u00e9 o momento: {}", (Object)movimentacoes.size());
        movimentacoes.addAll(this.integracaoPatrimonialRepository.findReabilitacoesParcelamentos(datasMovimento));
        log.debug("Carregou movimenta\u00e7\u00e3o de reabilita\u00e7\u00e3o de parcelamentos. Movimenta\u00e7\u00f5es at\u00e9 o momento: {}", (Object)movimentacoes.size());
        log.debug("Foram encontrados {} registros para o periodo selecionado ", (Object)movimentacoes.size());
        List<IntegracaoPatrimonial> integracoesPatrimoniais = movimentacoes.stream().collect(Collectors.groupingBy(ItemIntegracaoPatrimonialDTO::toItemIntegracaoPatrimonialAgrupador)).entrySet().stream().map(arg_0 -> this.toIntegracaoPatrimonial(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        log.debug("Finalizada gera\u00e7\u00e3o dos itens da integra\u00e7\u00e3o patrimonial");
        return integracoesPatrimoniais;
    }

    private IntegracaoPatrimonial toIntegracaoPatrimonial(Map.Entry<ItemIntegracaoPatrimonialAgrupadorDTO, List<ItemIntegracaoPatrimonialDTO>> movimentacoes) {
        IntegracaoPatrimonial integracaoPatrimonial;
        LocalDate dataMovimento;
        Long entidade = movimentacoes.getKey().getEntidade();
        IntegracaoPatrimonial integracaoPatrimonialFound = this.integracaoPatrimonialRepository.findByEntidadeAndDataMovimento(entidade, dataMovimento = movimentacoes.getKey().getDataMovimentacao());
        if (Objects.nonNull(integracaoPatrimonialFound) && !SituacaoIntegracaoContabil.ESTORNADO_CONTABILIDADE.equals((Object)integracaoPatrimonialFound.getSituacaoIntegracaoPatrimonial())) {
            log.debug("Ignorando os resultados do dia {} pois ele est\u00e1 na situa\u00e7\u00e3o {}.", (Object)dataMovimento, (Object)integracaoPatrimonialFound.getSituacaoIntegracaoPatrimonial());
            return null;
        }
        IntegracaoPatrimonial integracaoPatrimonial2 = integracaoPatrimonial = Objects.isNull(integracaoPatrimonialFound) ? new IntegracaoPatrimonial() : integracaoPatrimonialFound;
        if (Objects.isNull(integracaoPatrimonialFound)) {
            integracaoPatrimonial.setDataMovimento(dataMovimento);
            integracaoPatrimonial.setEntidade(entidade);
            integracaoPatrimonial.setExercicio(Long.valueOf(dataMovimento.getYear()));
        } else {
            this.itemIntegracaoPatrimonialRepository.deleteByIntegracaoId(integracaoPatrimonial.getId());
        }
        integracaoPatrimonial.setDataSolicitacaoIntegracao(LocalDateTime.now());
        integracaoPatrimonial.setUsuarioCpfCnpjIntegracao(SecurityUtils.getUserAise());
        integracaoPatrimonial.setSituacaoIntegracaoPatrimonial(SituacaoIntegracaoContabil.AGUARDANDO_CONTABILIZACAO);
        this.integracaoPatrimonialRepository.save((Object)integracaoPatrimonial);
        List itens = movimentacoes.getValue().stream().map(dto -> ItemIntegracaoPatrimonial.from((ItemIntegracaoPatrimonialDTO)dto, (IntegracaoPatrimonial)integracaoPatrimonial)).collect(Collectors.toList());
        this.itemIntegracaoPatrimonialRepository.saveAll(itens);
        return integracaoPatrimonial;
    }

    public void updateStatus(Long id, SituacaoIntegracaoContabil situacao) {
        this.integracaoPatrimonialRepository.findById((Object)id).ifPresent(integracaoPatrimonial -> {
            integracaoPatrimonial.setSituacaoIntegracaoPatrimonial(situacao);
            log.info("Situa\u00e7\u00e3o do lote de integra\u00e7\u00e3o patrimonial {} atualizado.", (Object)id);
            if (SituacaoIntegracaoContabil.ESTORNADO_CONTABILIDADE.equals((Object)situacao)) {
                integracaoPatrimonial.setDataEstornoIntegracao(LocalDateTime.now());
                this.movimentacaoDiariaService.reverterIntegracaoData(integracaoPatrimonial.getDataMovimento());
                log.info("Movimenta\u00e7\u00e3o di\u00e1ria na data {}, atualizada para {}.", (Object)DateUtils.localDateToStringFormatoBrasileiro((LocalDate)integracaoPatrimonial.getDataMovimento()), (Object)SituacaoMovimentacaoDiaria.TRIBUTACAO.getDescricao());
            }
            this.integracaoPatrimonialRepository.save(integracaoPatrimonial);
        });
        log.info("Atualiza\u00e7\u00e3o de lote de integra\u00e7\u00e3o patrimonial finalizado.");
    }

    public List<IntegracaoPatrimonialPorTipoMovimentoDTO> findTotaisPorTipoMovimentoAndId(Long id) {
        IntegracaoPatrimonial integracaoPatrimonial = (IntegracaoPatrimonial)this.integracaoPatrimonialRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("Integra\u00e7\u00e3o Patrimonial %s n\u00e3o encontrada.", id)));
        List totais = this.integracaoPatrimonialRepository.findTotaisPorTipoMovimentoAndId(integracaoPatrimonial.getId());
        totais.sort(Comparator.comparing(total -> total.getTipoMovimento().getDescricao()));
        return totais;
    }

    public TotalizadorIntegracaoPatrimonialDTO getTotalSearch(String search) {
        return this.integracaoPatrimonialRepository.getTotalSearch(search);
    }

    public void republish(Long id) {
        IntegracaoPatrimonial integracaoPatrimonial = (IntegracaoPatrimonial)this.integracaoPatrimonialRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("Integra\u00e7\u00e3o Patrimonial %s n\u00e3o encontrada.", id)));
        if (!SituacaoIntegracaoContabil.AGUARDANDO_CONTABILIZACAO.equals((Object)integracaoPatrimonial.getSituacaoIntegracaoPatrimonial())) {
            throw new EloValidationException(String.format("Apenas lotes com status %s podem ser reenviados.", SituacaoIntegracaoContabil.AGUARDANDO_CONTABILIZACAO.getDescricao()));
        }
        this.publisher.publish(OutboxActions.CREATED, (EntityEvent)integracaoPatrimonial.toPayload());
    }

    @Generated
    public IntegracaoPatrimonialService(IntegracaoPatrimonialRepository integracaoPatrimonialRepository, ItemIntegracaoPatrimonialRepository itemIntegracaoPatrimonialRepository, MovimentacaoDiariaService movimentacaoDiariaService, EntidadeServiceImpl entidadeService, Publisher publisher) {
        this.integracaoPatrimonialRepository = integracaoPatrimonialRepository;
        this.itemIntegracaoPatrimonialRepository = itemIntegracaoPatrimonialRepository;
        this.movimentacaoDiariaService = movimentacaoDiariaService;
        this.entidadeService = entidadeService;
        this.publisher = publisher;
    }
}

