/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.sicoob;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.BoletoDebitoID;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.MovimentacaoDiariaId;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParametroPix;
import br.com.elotech.tributos.domain.TipoArquivoRetornoPagamento;
import br.com.elotech.tributos.domain.TipoOperacaoDebito;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoPixPagoDetalhe;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoPixPagoLog;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalheId;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.domain.pagamento.SituacaoPagamentoLote;
import br.com.elotech.tributos.domain.pagamento.TipoPagamentoLote;
import br.com.elotech.tributos.domain.solicitacaopagamento.SolicitacaoPagamento;
import br.com.elotech.tributos.domain.tipomensagem.ClassificacaoTipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagemEnum;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.DadosHeaderSicoob;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.DadosTokenSicoob;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.pagamento.MovimentoFinanceiroPagamentoSicoobDTO;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.pagamento.ResultadoSolicitacaoPagamentoSicoobResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.pagamento.SolicitacaoPagamentoSicoobRequestDTO;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.pagamento.SolicitacaoPagamentoSicoobResponseDTO;
import br.com.elotech.tributos.dto.pagamento.ImportacaoPixPagoResultadoDTO;
import br.com.elotech.tributos.dto.pagamento.solicitacaopagamento.SolicitacaoPagamentoDTO;
import br.com.elotech.tributos.dto.pix.sicoob.SicoobPixPago;
import br.com.elotech.tributos.dto.pix.sicoob.SicoobPixPagoPaginacao;
import br.com.elotech.tributos.dto.pix.sicoob.SicoobPixPagoResponse;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import br.com.elotech.tributos.enums.SituacaoSolicitacaoPagamento;
import br.com.elotech.tributos.repository.ParametroPixRepository;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoPixPagoLogRepository;
import br.com.elotech.tributos.repository.solicitacaopagamento.SolicitacaoPagamentoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.BaixaAutomaticaDetalheService;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.TipoMensagemService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoPixPagoService;
import br.com.elotech.tributos.service.integracaoboleto.sicoob.AutenticacaoSicoobService;
import br.com.elotech.tributos.service.solicitacaopagamento.SolicitacaoPagamentoService;
import br.com.elotech.tributos.util.AmbienteUtils;
import br.com.elotech.tributos.util.FileUtils;
import br.com.elotech.tributos.util.RestTemplateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.math.BigDecimal;
import java.net.URI;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class SicoobPixPagoService
implements IntegracaoPixPagoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SicoobPixPagoService.class);
    private static final DateTimeFormatter FORMATO_DATA_HORA_API = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH'%3A'mm'%3A'ss'Z'");
    private static final DateTimeFormatter FORMATO_NOME_ARQUIVO = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
    private static final String SCOPE_PIX = "cobv.write pix.read webhook.read webhook.write";
    private static final String SOLICITACAO_SEM_REGISTROS = "Solicita\u00e7\u00e3o n\u00e3o retornou nenhum registro.";
    private static final String URL_BOLETO_MOVIMENTACAO_V2 = "/boletos/solicitacoes/movimentacao";
    private static final String URL_BOLETO_MOVIMENTACAO_V3 = "/boletos/movimentacoes";
    private static final String URL_BOLETO_MOVIMENTACAO_DOWNLOAD_V2 = "/boletos/movimentacao-download";
    private static final String URL_BOLETO_MOVIMENTACAO_DOWNLOAD_V3 = "/boletos/movimentacoes/download";
    private static final String NUMERO_CONTRATO_MOVIMENTACAO = "numeroContrato";
    private static final String NUMERO_CLIENTE_MOVIMENTACAO = "numeroCliente";
    private static final String CODIGO_SOLICITACAO_MOVIMENTACAO = "codigoSolicitacao";
    private static final String ID_ARQUIVO_SOLICITACAO = "idArquivo";
    private static final String PATH_PIX = "pix";
    private static final String QUERY_PARAM_PAGINACAO_PAGINA_ATUAL = "paginacao.paginaAtual";
    private static final String QUERY_PARAM_PAGINACAO_ITENS_PAGINA = "paginacao.itensPorPagina";
    private static final String QUERY_PARAM_DATA_INICIO = "inicio";
    private static final String QUERY_PARAM_DATA_FIM = "fim";
    private static final String BODY_URL_WEB_HOOK = "webhookUrl";
    private static final String TAG_MENSAGENS = "mensagens";
    private static final String TAG_MENSAGEM = "mensagem";
    private final AutenticacaoSicoobService autenticacaoSicoobService;
    private final PagamentoLoteService pagamentoLoteService;
    private final ContextService contextService;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;
    private final BloquetoService boletoService;
    private final BaixaAutomaticaDetalheService baixaAutomaticaDetalheService;
    private final ParametroGeralService parametroGeralService;
    private final SolicitacaoPagamentoService solicitacaoPagamentoService;
    private final ParametroPixRepository parametroPixRepository;
    private final TipoMensagemService tipoMensagemService;
    private final IntegracaoPixPagoLogRepository integracaoPixPagoLogRepository;
    private final SolicitacaoPagamentoRepository solicitacaoPagamentoRepository;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    private final DebitoParcelaService debitoParcelaService;
    private final ObjectMapper objectMapper;
    private final ConfigurableEnvironment environment;

    public Boolean accept(Convenio convenio) {
        return Banco.CODIGO_SICOOB.equals(convenio.getBanco().getId());
    }

    public ImportacaoPixPagoResultadoDTO importarPixPago(Convenio convenio, LocalDate dataReferencia) {
        Long entidade = this.contextService.getEntidadePrincipal();
        ImportacaoPixPagoResultadoDTO resultado = new ImportacaoPixPagoResultadoDTO();
        IntegracaoPixPagoLog integracaoPixPagoLog = this.buildLog(convenio, dataReferencia);
        try {
            SicoobPixPagoResponse response = this.getPixPagos(dataReferencia, entidade);
            SicoobPixPagoPaginacao paginacao = response.getParametros().getPaginacao();
            integracaoPixPagoLog.setQuantidadeRegistros(paginacao.getQuantidadeTotalDeItens());
            if (paginacao.getQuantidadeTotalDeItens().equals(0)) {
                resultado.setPossuiRegistros(Boolean.FALSE);
                ImportacaoPixPagoResultadoDTO importacaoPixPagoResultadoDTO = resultado;
                return importacaoPixPagoResultadoDTO;
            }
            ArrayList itensGerados = new ArrayList();
            itensGerados.addAll(this.processarPixPagos(response.getPix(), integracaoPixPagoLog));
            if (paginacao.getQuantidadeDePaginas() > 1) {
                Integer totalPaginas = paginacao.getQuantidadeDePaginas();
                Integer pagina = 1;
                while (pagina < totalPaginas) {
                    SicoobPixPagoResponse respostaPagina = this.getPixPagos(dataReferencia, pagina, entidade);
                    itensGerados.addAll(this.processarPixPagos(respostaPagina.getPix(), integracaoPixPagoLog));
                    Integer n = pagina;
                    Integer n2 = pagina = Integer.valueOf(pagina + 1);
                }
            }
            resultado.setPossuiRegistros(Boolean.valueOf(!itensGerados.isEmpty()));
            integracaoPixPagoLog.setQuantidadeBaixasGeradas(Integer.valueOf(itensGerados.size()));
            if (!itensGerados.isEmpty()) {
                PagamentoLote lote = this.getPagamentoLote(convenio, dataReferencia, entidade, resultado, this.getNomeArquivoPixPago(convenio.getConvenio(), dataReferencia));
                resultado.setDadosLote(lote.getId());
                AtomicLong sequencia = new AtomicLong(this.baixaAutomaticaDetalheService.getUltimaSequenciaLote(lote.getId()));
                this.salvarItensGerados(itensGerados, lote, sequencia);
            }
        }
        catch (Exception e) {
            String mensagemErro = String.format("%s%n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            integracaoPixPagoLog.setErro(mensagemErro);
            throw e;
        }
        finally {
            this.saveLog(integracaoPixPagoLog);
        }
        return resultado;
    }

    public SolicitacaoPagamentoDTO solicitarArquivoPagamento(Convenio convenio, LocalDate dataReferencia) {
        return SolicitacaoPagamentoDTO.from((SolicitacaoPagamento)this.getSolicitacaoArquivoPagamento(convenio, dataReferencia));
    }

    public List<ImportacaoPixPagoResultadoDTO> importarSolicitacaoPagamento(Convenio convenio, LocalDate dataReferencia, Long idSolicitacao) {
        SolicitacaoPagamento solicitacaoPagamento = (SolicitacaoPagamento)this.solicitacaoPagamentoRepository.findById((Object)idSolicitacao).orElseThrow(() -> new EloValidationException(String.format("Solicita\u00e7\u00e3o de Pagamento Id '%d' n\u00e3o encontrada.", idSolicitacao)));
        if (!SituacaoSolicitacaoPagamento.AGUARDANDO_PROCESSAMENTO.equals((Object)solicitacaoPagamento.getSituacao())) {
            throw new EloValidationException(String.format("Solicita\u00e7\u00e3o de Pagamento Id '%d' j\u00e1 processada!", idSolicitacao));
        }
        ParametroPix parametroPix = this.getParametroPixByEntidade(this.contextService.getEntidadePrincipal());
        IntegracaoPixPagoLog integracaoPixPagoLog = this.buildLog(convenio, dataReferencia);
        try {
            SolicitacaoPagamentoSicoobResponseDTO dadosSolicitacao = this.getArquivosSolicitacaoPagamento(solicitacaoPagamento, parametroPix);
            Integer quantidadeRegistros = dadosSolicitacao.getResultado().getQuantidadeTotalRegistros();
            integracaoPixPagoLog.setQuantidadeRegistros(quantidadeRegistros);
            if (quantidadeRegistros == 0) {
                ImportacaoPixPagoResultadoDTO resultado = new ImportacaoPixPagoResultadoDTO();
                resultado.setPossuiRegistros(Boolean.FALSE);
                ArrayList<ImportacaoPixPagoResultadoDTO> listResultado = new ArrayList<ImportacaoPixPagoResultadoDTO>();
                listResultado.add(resultado);
                ArrayList<ImportacaoPixPagoResultadoDTO> arrayList = listResultado;
                return arrayList;
            }
            List list = this.importarArquivoPagamento(dadosSolicitacao, solicitacaoPagamento, parametroPix, integracaoPixPagoLog);
            return list;
        }
        catch (Exception e) {
            String mensagemErro = String.format("%s%n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            integracaoPixPagoLog.setErro(mensagemErro);
            throw e;
        }
        finally {
            this.saveLog(integracaoPixPagoLog);
        }
    }

    private SolicitacaoPagamento getSolicitacaoArquivoPagamento(Convenio convenio, LocalDate dataReferencia) {
        ParametroPix parametroPix = this.getParametroPixByEntidade(this.contextService.getEntidadePrincipal());
        IntegracaoPixPagoLog integracaoPixPagoLog = this.buildLog(convenio, dataReferencia);
        URI url = this.buildUrlSolicitacaoPagamentos();
        String clientId = this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_OAUTH_CLIENTID);
        String scope = this.autenticacaoSicoobService.getApiScope(url.toString());
        boolean apiV2 = this.autenticacaoSicoobService.isApiV2(url.toString());
        DadosTokenSicoob dadosTokenSicoob = DadosTokenSicoob.builder().clientId(clientId).scope(scope).integracaoTokenOperation(IntegracaoTokenOperation.BOLETO).build();
        DadosHeaderSicoob dadosHeaderSicoob = this.autenticacaoSicoobService.builderDadosHeaders(parametroPix, dadosTokenSicoob);
        HttpHeaders headers = this.autenticacaoSicoobService.builderHeaders(dadosHeaderSicoob);
        SolicitacaoPagamentoSicoobRequestDTO bodyRequest = this.getBodyRequestSolicitacaoPagamento(convenio, dataReferencia, apiV2);
        HttpEntity request = new HttpEntity((Object)bodyRequest, (MultiValueMap)headers);
        log.debug("Solicitando o arquivo de pagamento na url {}, com headers {} e body {}.", new Object[]{url, headers, bodyRequest});
        try {
            JsonNode bodyResponse = (JsonNode)this.autenticacaoSicoobService.getRestTemplate(dadosHeaderSicoob.getCertificadoSicoobDTO()).exchange(url, HttpMethod.POST, request, JsonNode.class).getBody();
            log.debug("Retorno da requis\u00e7\u00e3o para solicitar arquivo de pagamento : {} ", (Object)bodyResponse);
            SolicitacaoPagamentoSicoobResponseDTO response = (SolicitacaoPagamentoSicoobResponseDTO)this.objectMapper.treeToValue((TreeNode)bodyResponse, SolicitacaoPagamentoSicoobResponseDTO.class);
            SolicitacaoPagamento solicitacaoPagamento = this.solicitacaoPagamentoService.createSolicitacao(response, convenio, dataReferencia);
            return solicitacaoPagamento;
        }
        catch (RestException e) {
            log.debug("Erro ao Solicitar Arquivo de Pagamento m\u00e9todo getSolicitacaoArquivoPagamento: ", (Throwable)e);
            integracaoPixPagoLog.setErro(String.format("Erro ao Realizar Solicita\u00e7\u00e3o de Pagamento no Banco Sicoob: %s", e.getMessage()));
            throw new RestException(e.getStatus(), String.format("Erro ao Realizar Solicita\u00e7\u00e3o de Pagamento no Banco Sicoob: %s", e.getMessage()), (Throwable)e);
        }
        catch (JsonProcessingException e) {
            log.debug("Erro ao traduzir o retorno do m\u00e9todo getSolicitacaoArquivoPagamento para String: ", (Throwable)e);
            throw new RuntimeException("Erro ao traduzir o retorno do m\u00e9todo getSolicitacaoArquivoPagamento para String: ", e);
        }
        finally {
            this.saveLog(integracaoPixPagoLog);
        }
    }

    private URI builderUrlSolicitacaoArquivoPagamento(UriComponentsBuilder uri, SolicitacaoPagamento solicitacaoPagamento) {
        boolean isApiV2 = this.autenticacaoSicoobService.isApiV2(uri.toUriString());
        return uri.queryParam(isApiV2 ? NUMERO_CONTRATO_MOVIMENTACAO : NUMERO_CLIENTE_MOVIMENTACAO, new Object[]{solicitacaoPagamento.getConvenio().getCodigoCedente()}).queryParam(CODIGO_SOLICITACAO_MOVIMENTACAO, new Object[]{solicitacaoPagamento.getCodigoSolicitacao()}).build(true).toUri();
    }

    private SolicitacaoPagamentoSicoobResponseDTO getArquivosSolicitacaoPagamento(SolicitacaoPagamento solicitacaoPagamento, ParametroPix parametroPix) {
        UriComponentsBuilder uri = this.builderUrlSolicitacao();
        String scope = this.autenticacaoSicoobService.getApiScope(uri.toUriString());
        URI url = this.builderUrlSolicitacaoArquivoPagamento(uri, solicitacaoPagamento);
        String clientId = this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_OAUTH_CLIENTID);
        DadosTokenSicoob dadosTokenSicoob = DadosTokenSicoob.builder().clientId(clientId).scope(scope).integracaoTokenOperation(IntegracaoTokenOperation.BOLETO).build();
        DadosHeaderSicoob dadosHeaderSicoob = this.autenticacaoSicoobService.builderDadosHeaders(parametroPix, dadosTokenSicoob);
        HttpHeaders headers = this.autenticacaoSicoobService.builderHeaders(dadosHeaderSicoob);
        try {
            log.debug("Consultando Solicita\u00e7\u00e3o de Pagamento {} na url {} e headers {}.", new Object[]{solicitacaoPagamento.getCodigoSolicitacao(), url, headers});
            JsonNode bodyResponse = (JsonNode)this.autenticacaoSicoobService.getRestTemplate(dadosHeaderSicoob.getCertificadoSicoobDTO()).exchange(url, HttpMethod.GET, new HttpEntity(null, (MultiValueMap)headers), JsonNode.class).getBody();
            log.debug("Retorno da Consulta da Solicitacao {} arquivo de pagamento : {} ", (Object)solicitacaoPagamento.getCodigoSolicitacao(), (Object)bodyResponse);
            SolicitacaoPagamentoSicoobResponseDTO response = (SolicitacaoPagamentoSicoobResponseDTO)this.objectMapper.treeToValue((TreeNode)bodyResponse, SolicitacaoPagamentoSicoobResponseDTO.class);
            this.solicitacaoPagamentoService.updateSolicitacao(response, solicitacaoPagamento, SituacaoSolicitacaoPagamento.PROCESSADO);
            return response;
        }
        catch (RestException e) {
            if (this.isRetornoArquivoVazio(e.getMessage()).booleanValue()) {
                SolicitacaoPagamentoSicoobResponseDTO response = new SolicitacaoPagamentoSicoobResponseDTO();
                ResultadoSolicitacaoPagamentoSicoobResponseDTO resultado = new ResultadoSolicitacaoPagamentoSicoobResponseDTO();
                resultado.setQuantidadeArquivo(Integer.valueOf(0));
                resultado.setQuantidadeTotalRegistros("0");
                response.setResultado(resultado);
                this.solicitacaoPagamentoService.updateSolicitacao(response, solicitacaoPagamento, SituacaoSolicitacaoPagamento.SEM_REGISTROS);
                return response;
            }
            throw new RestException(e.getStatus(), String.format("Erro ao consultar Solicita\u00e7\u00e3o de Pagamento no Banco Sicoob: %s", e.getMessage()), (Throwable)e);
        }
        catch (JsonProcessingException e) {
            log.debug("Erro ao traduzir o retorno do m\u00e9todo getArquivosSolicitacaoPagamento para String: ", (Throwable)e);
            throw new RuntimeException("Erro ao traduzir o retorno da Consulta Pagamento para String: ", e);
        }
    }

    private Boolean isRetornoArquivoVazio(String messageException) {
        try {
            JsonNode jsonNode = (JsonNode)this.objectMapper.readValue(messageException, JsonNode.class);
            if (jsonNode.has(TAG_MENSAGENS)) {
                String mensagem = jsonNode.get(TAG_MENSAGENS).findValuesAsText(TAG_MENSAGEM).stream().findFirst().orElse("");
                return mensagem.equals(SOLICITACAO_SEM_REGISTROS);
            }
            return Boolean.FALSE;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Erro ao traduzir o retorno do m\u00e9todo verificaArquivoVazio para String: ", e);
        }
    }

    private List<ImportacaoPixPagoResultadoDTO> importarArquivoPagamento(SolicitacaoPagamentoSicoobResponseDTO dadosArquivo, SolicitacaoPagamento solicitacaoPagamento, ParametroPix parametroPix, IntegracaoPixPagoLog integracaoPixPagoLog) {
        String baseUrl = this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_API_REGPIX_URL);
        String scope = this.autenticacaoSicoobService.getApiScope(baseUrl);
        String clientId = this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_OAUTH_CLIENTID);
        DadosTokenSicoob dadosTokenSicoob = DadosTokenSicoob.builder().clientId(clientId).scope(scope).integracaoTokenOperation(IntegracaoTokenOperation.BOLETO).build();
        DadosHeaderSicoob dadosHeaderSicoob = this.autenticacaoSicoobService.builderDadosHeaders(parametroPix, dadosTokenSicoob);
        HttpHeaders headers = this.autenticacaoSicoobService.builderHeaders(dadosHeaderSicoob);
        ArrayList<ImportacaoPixPagoResultadoDTO> resultado = new ArrayList<ImportacaoPixPagoResultadoDTO>();
        for (int arquivo = 0; arquivo < dadosArquivo.getResultado().getIdArquivos().size(); ++arquivo) {
            URI url = this.builderUrlArquivoSolicitacaoPagamento(solicitacaoPagamento.getConvenio().getCodigoCedente(), solicitacaoPagamento.getCodigoSolicitacao(), (Long)dadosArquivo.getResultado().getIdArquivos().get(arquivo), baseUrl);
            log.debug("Consultando Solicita\u00e7\u00e3o de Pagamento {} na url {} e headers {}.", new Object[]{solicitacaoPagamento.getCodigoSolicitacao(), url, headers});
            try {
                JsonNode bodyResponse = (JsonNode)this.autenticacaoSicoobService.getRestTemplate(dadosHeaderSicoob.getCertificadoSicoobDTO()).exchange(url, HttpMethod.GET, new HttpEntity(null, (MultiValueMap)headers), JsonNode.class).getBody();
                log.debug("Retorno da Consulta da Solicitacao {} arquivo de pagamento : {} ", (Object)solicitacaoPagamento.getCodigoSolicitacao(), (Object)bodyResponse);
                SolicitacaoPagamentoSicoobResponseDTO response = (SolicitacaoPagamentoSicoobResponseDTO)this.objectMapper.treeToValue((TreeNode)bodyResponse, SolicitacaoPagamentoSicoobResponseDTO.class);
                this.solicitacaoPagamentoService.insertArquivoSolicitacao(solicitacaoPagamento, response, (Long)dadosArquivo.getResultado().getIdArquivos().get(arquivo));
                resultado.add(this.processarSolicitacaoArquivoRetorno(response, solicitacaoPagamento, integracaoPixPagoLog));
                continue;
            }
            catch (RestException e) {
                log.debug("Erro ao importar Arquivo de Pagamento m\u00e9todo importarArquivoPagamento: ", (Throwable)e);
                throw new RestException(e.getStatus(), String.format("Erro ao importar Arquivo de Pagamento no Banco Sicoob: %s", e.getMessage()), (Throwable)e);
            }
            catch (JsonProcessingException e) {
                log.debug("Erro ao traduzir o retorno do m\u00e9todo getArquivoPagamento para String: ", (Throwable)e);
                throw new RuntimeException("Erro ao traduzir o retorno do m\u00e9todo getArquivoPagamento para String: ", e);
            }
        }
        return resultado;
    }

    private ImportacaoPixPagoResultadoDTO processarSolicitacaoArquivoRetorno(SolicitacaoPagamentoSicoobResponseDTO dadosArquivos, SolicitacaoPagamento solicitacaoPagamento, IntegracaoPixPagoLog integracaoPixPagoLog) {
        byte[] decodedDase64 = Base64.getDecoder().decode(dadosArquivos.getResultado().getArquivo());
        String nomeArquivo = dadosArquivos.getResultado().getNomeArquivo().replace(".zip", ".json");
        String dadosArquivo = FileUtils.unzipFileToString((byte[])decodedDase64, (String)nomeArquivo);
        ImportacaoPixPagoResultadoDTO resultado = new ImportacaoPixPagoResultadoDTO();
        try {
            CollectionType type = this.objectMapper.getTypeFactory().constructCollectionType(List.class, MovimentoFinanceiroPagamentoSicoobDTO.class);
            List pagamentos = (List)this.objectMapper.readValue(dadosArquivo, (JavaType)type);
            ArrayList itensGerados = new ArrayList();
            itensGerados.addAll(this.createBaixaAutomaticaDetalhe(pagamentos, integracaoPixPagoLog));
            resultado.setPossuiRegistros(Boolean.valueOf(!itensGerados.isEmpty()));
            integracaoPixPagoLog.setQuantidadeBaixasGeradas(Integer.valueOf(itensGerados.size()));
            if (!itensGerados.isEmpty()) {
                PagamentoLote lote = this.getPagamentoLote(solicitacaoPagamento.getConvenio(), solicitacaoPagamento.getDataReferencia(), this.contextService.getEntidadePrincipal(), resultado, nomeArquivo);
                resultado.setDadosLote(lote.getId());
                AtomicLong sequencia = new AtomicLong(this.baixaAutomaticaDetalheService.getUltimaSequenciaLote(lote.getId()));
                this.salvarItensGerados(itensGerados, lote, sequencia);
            }
            return resultado;
        }
        catch (JsonProcessingException e) {
            String mensagemErro = String.format("Erro ao traduzir cont\u00e9udo do arquivo de pagamento para String: %s", e.getMessage());
            log.debug(mensagemErro, (Throwable)e);
            throw new RuntimeException(mensagemErro, e);
        }
    }

    private List<BaixaAutomaticaDetalhe> createBaixaAutomaticaDetalhe(List<MovimentoFinanceiroPagamentoSicoobDTO> pagamentos, IntegracaoPixPagoLog log) {
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.IMPORTADO);
        return pagamentos.stream().map(pagamento -> {
            IntegracaoPixPagoDetalhe detalhe = new IntegracaoPixPagoDetalhe();
            log.getDetalhes().add(detalhe);
            try {
                detalhe.setBuscaPorE2E(Boolean.FALSE);
                Optional boleto = this.boletoService.findByNossoNumero(pagamento.getSeuNumero());
                if (boleto.isEmpty()) {
                    detalhe.setObservacao("Boleto n\u00e3o encontrado.");
                    return null;
                }
                detalhe.setBoleto(((Bloqueto)boleto.get()).getBloqueto());
                detalhe.setExercicioboleto(((Bloqueto)boleto.get()).getExercicioBloqueto());
                detalhe.setEntidade(((Bloqueto)boleto.get()).getEntidade());
                if (this.baixaAutomaticaDetalheService.existsByBoleto((Bloqueto)boleto.get())) {
                    detalhe.setObservacao("Boleto j\u00e1 importado.");
                    return null;
                }
                detalhe.setObservacao("Boleto importado corretamente.");
                BaixaAutomaticaDetalhe baixaAutomaticaDetalhe = new BaixaAutomaticaDetalhe();
                baixaAutomaticaDetalhe.setBoleto((Bloqueto)boleto.get());
                baixaAutomaticaDetalhe.setNossoNumero(((Bloqueto)boleto.get()).getNossoNumero());
                baixaAutomaticaDetalhe.setSituacao(ClassificacaoTipoMensagem.IMPORTADO);
                baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.IMPORTADO.getDescricao());
                baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
                baixaAutomaticaDetalhe.setDataVencimento(((Bloqueto)boleto.get()).getDataVencimento());
                baixaAutomaticaDetalhe.setDataCreditoArquivo(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setDataPagamentoArquivo(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setDiferencaEmValor(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setDiferencaMaxima(BigDecimal.ZERO);
                baixaAutomaticaDetalhe.setAlterado(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setDescontoConcedido(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setCreditoConcedido(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setValor(BigDecimal.ZERO);
                baixaAutomaticaDetalhe.setValorPago(pagamento.getValorLiquido());
                baixaAutomaticaDetalhe.setValorPagoPrincipal(pagamento.getValorLiquido());
                baixaAutomaticaDetalhe.setValorPagoJuros(BigDecimal.ZERO);
                baixaAutomaticaDetalhe.setValorPagoMulta(BigDecimal.ZERO);
                baixaAutomaticaDetalhe.setTipoOperacao(TipoOperacaoDebito.NENHUMA_OPERACAO);
                return baixaAutomaticaDetalhe;
            }
            catch (Exception e) {
                detalhe.setMensagemErro(e.toString());
                SicoobPixPagoService.log.error("Ocorreu um erro ao processar arquivo de pagamento ", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private SolicitacaoPagamentoSicoobRequestDTO getBodyRequestSolicitacaoPagamento(Convenio convenio, LocalDate dataReferencia, boolean isApiV2) {
        return SolicitacaoPagamentoSicoobRequestDTO.from((Convenio)convenio, (LocalDate)dataReferencia, (boolean)isApiV2);
    }

    private void salvarItensGerados(List<BaixaAutomaticaDetalhe> itensGerados, PagamentoLote lote, AtomicLong sequencia) {
        itensGerados.forEach(baixaAutomaticaDetalhe -> {
            BaixaAutomaticaDetalheId id = new BaixaAutomaticaDetalheId();
            id.setSequenciaArquivo(Long.valueOf(sequencia.incrementAndGet()));
            id.setLote(lote.getId().getLote());
            id.setEntidade(lote.getId().getEntidade());
            id.setExercicio(lote.getId().getExercicio());
            baixaAutomaticaDetalhe.setId(id);
            baixaAutomaticaDetalhe.setPagamentoLote(lote);
            baixaAutomaticaDetalhe.setDataCredito(lote.getDataCredito());
            baixaAutomaticaDetalhe.setDataPagamento(lote.getDataMovimento());
            baixaAutomaticaDetalhe.setContaBancaria(lote.getContaBancaria());
            baixaAutomaticaDetalhe.setConvenio(lote.getConvenio());
            baixaAutomaticaDetalhe.setBanco(lote.getBanco());
            this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
        });
        Long numeroBaixasAtual = Optional.ofNullable(lote.getNumeroBaixas()).orElse(0L);
        lote.setNumeroBaixas(Long.valueOf(numeroBaixasAtual + (long)itensGerados.size()));
    }

    private void saveLog(IntegracaoPixPagoLog integracaoPixPagoLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoPixPagoLog)this.integracaoPixPagoLogRepository.save((Object)integracaoPixPagoLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    private List<BaixaAutomaticaDetalhe> processarPixPagos(List<SicoobPixPago> pixPagos, IntegracaoPixPagoLog log) {
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.IMPORTADO);
        return pixPagos.stream().map(pix -> {
            IntegracaoPixPagoDetalhe detalhe = new IntegracaoPixPagoDetalhe();
            log.getDetalhes().add(detalhe);
            try {
                detalhe.setE2eid(pix.getEndToEndId());
                if (StringUtils.isNotBlank((String)pix.getTxid())) {
                    detalhe.setTxid(pix.getTxid());
                    detalhe.setBuscaPorE2E(Boolean.FALSE);
                } else {
                    SicoobPixPago pagamentoByE2E = this.getPagamentoByE2E(pix.getEndToEndId());
                    detalhe.setTxid(pagamentoByE2E.getTxid());
                    detalhe.setBuscaPorE2E(Boolean.TRUE);
                }
                if (StringUtils.isBlank((String)detalhe.getTxid())) {
                    detalhe.setObservacao("N\u00e3o foi possivel encontrar o Txid do pagamento Pix");
                    return null;
                }
                Optional boleto = this.boletoService.findByTxid(detalhe.getTxid());
                if (boleto.isEmpty()) {
                    detalhe.setObservacao("Boleto n\u00e3o encontrado.");
                    return null;
                }
                detalhe.setBoleto(((Bloqueto)boleto.get()).getBloqueto());
                detalhe.setExercicioboleto(((Bloqueto)boleto.get()).getExercicioBloqueto());
                detalhe.setEntidade(((Bloqueto)boleto.get()).getEntidade());
                if (this.baixaAutomaticaDetalheService.existsByBoleto((Bloqueto)boleto.get())) {
                    detalhe.setObservacao("Boleto j\u00e1 importado.");
                    return null;
                }
                detalhe.setObservacao("Boleto importado corretamente.");
                BaixaAutomaticaDetalhe baixaAutomaticaDetalhe = new BaixaAutomaticaDetalhe();
                baixaAutomaticaDetalhe.setBoleto((Bloqueto)boleto.get());
                baixaAutomaticaDetalhe.setNossoNumero(((Bloqueto)boleto.get()).getNossoNumero());
                baixaAutomaticaDetalhe.setSituacao(ClassificacaoTipoMensagem.IMPORTADO);
                baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.IMPORTADO.getDescricao());
                baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
                baixaAutomaticaDetalhe.setDataVencimento(((Bloqueto)boleto.get()).getDataVencimento());
                baixaAutomaticaDetalhe.setDataCreditoArquivo(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setDataPagamentoArquivo(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setDiferencaEmValor(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setDiferencaMaxima(BigDecimal.ZERO);
                baixaAutomaticaDetalhe.setAlterado(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setDescontoConcedido(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setCreditoConcedido(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setValor(BigDecimal.ZERO);
                baixaAutomaticaDetalhe.setValorPago(new BigDecimal(pix.getValor()));
                baixaAutomaticaDetalhe.setValorPagoPrincipal(new BigDecimal(pix.getValor()));
                baixaAutomaticaDetalhe.setValorPagoJuros(BigDecimal.ZERO);
                baixaAutomaticaDetalhe.setValorPagoMulta(BigDecimal.ZERO);
                baixaAutomaticaDetalhe.setTipoOperacao(TipoOperacaoDebito.NENHUMA_OPERACAO);
                return baixaAutomaticaDetalhe;
            }
            catch (Exception ex) {
                detalhe.setMensagemErro(ex.toString());
                SicoobPixPagoService.log.error("Ocorreu um erro ao processar pix pagos ", (Object)ex.getMessage(), (Object)ex);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private IntegracaoPixPagoLog buildLog(Convenio convenio, LocalDate dataReferencia) {
        IntegracaoPixPagoLog log = new IntegracaoPixPagoLog();
        log.setConvenio(convenio.getId());
        log.setDataIntegracao(LocalDateTime.now());
        log.setDataReferencia(dataReferencia);
        log.setUsuario(SecurityUtils.getUserName());
        return log;
    }

    private PagamentoLote getPagamentoLote(Convenio convenio, LocalDate dataReferencia, Long entidade, ImportacaoPixPagoResultadoDTO resultado, String nomeArquivo) {
        this.validaMovimentacao(entidade, dataReferencia);
        Optional loteJaExistente = this.pagamentoLoteService.findAbertoByConvenioAndData(convenio, dataReferencia);
        resultado.setLoteNovo(Boolean.valueOf(loteJaExistente.isEmpty()));
        return loteJaExistente.orElseGet(() -> this.createPagamentoLote(convenio, entidade, dataReferencia, nomeArquivo));
    }

    private void validaMovimentacao(Long entidade, LocalDate dataReferencia) {
        MovimentacaoDiariaId movimentacaoDiariaId = new MovimentacaoDiariaId();
        movimentacaoDiariaId.setEntidade(entidade);
        movimentacaoDiariaId.setData(dataReferencia);
        this.validaDataMovimentacaoService.verificaMovimentacaoDiaria(movimentacaoDiariaId);
    }

    private PagamentoLote createPagamentoLote(Convenio convenio, Long entidade, LocalDate dataReferencia, String nomeArquivo) {
        Long exercicio = this.contextService.getExercicioAtual();
        PagamentoLoteId id = new PagamentoLoteId();
        id.setEntidade(entidade);
        id.setExercicio(exercicio);
        PagamentoLote pagamentoLote = new PagamentoLote();
        pagamentoLote.setId(id);
        pagamentoLote.setDataLote(LocalDate.now());
        pagamentoLote.setDataMovimento(dataReferencia);
        pagamentoLote.setDataCredito(dataReferencia);
        pagamentoLote.setSituacao(SituacaoPagamentoLote.ABERTO);
        pagamentoLote.setTipo(TipoPagamentoLote.PIX);
        pagamentoLote.setConvenio(convenio);
        pagamentoLote.setContaBancaria(convenio.getContaBancaria());
        pagamentoLote.setBanco(convenio.getBanco());
        pagamentoLote.setArquivoRetorno(Boolean.FALSE);
        pagamentoLote.setLoteManual(Boolean.FALSE);
        pagamentoLote.setNumeroBaixas(Long.valueOf(0L));
        pagamentoLote.setTipoArquivo(TipoArquivoRetornoPagamento.RETORNO_PIX);
        pagamentoLote.setObservacao("Lote gerado pela importa\u00e7\u00e3o de pix");
        pagamentoLote.setNomeArquivo(nomeArquivo);
        return (PagamentoLote)this.pagamentoLoteService.save((EloEntity)pagamentoLote, null);
    }

    private String getNomeArquivoPixPago(Long convenio, LocalDate dataReferencia) {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime dataReferenciaComHoraAtual = dataReferencia.atTime(now.getHour(), now.getMinute(), now.getSecond());
        return String.format("importacao_pix_%d_%s", convenio, FORMATO_NOME_ARQUIVO.format(dataReferenciaComHoraAtual));
    }

    private SicoobPixPagoResponse getPixPagos(LocalDate data, Long entidade) {
        return this.getPixPagos(data, Integer.valueOf(0), entidade);
    }

    private SicoobPixPagoResponse getPixPagos(LocalDate data, Integer page, Long entidade) {
        ParametroPix parametroPix = this.getParametroPixByEntidade(entidade);
        String clientId = this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_PIX_CONSULTA_ID);
        URI url = this.buildUrlPixPago(data, page);
        DadosTokenSicoob dadosTokenSicoob = DadosTokenSicoob.builder().clientId(clientId).scope(SCOPE_PIX).integracaoTokenOperation(IntegracaoTokenOperation.PIX).build();
        DadosHeaderSicoob dadosHeaderSicoob = this.autenticacaoSicoobService.builderDadosHeaders(parametroPix, dadosTokenSicoob);
        HttpHeaders headers = this.autenticacaoSicoobService.builderHeaders(dadosHeaderSicoob);
        log.debug("Buscando os pix pagos na url {}, com headers {}.", (Object)url, (Object)headers);
        JsonNode body = (JsonNode)this.autenticacaoSicoobService.getRestTemplate(dadosHeaderSicoob.getCertificadoSicoobDTO()).exchange(url, HttpMethod.GET, new HttpEntity(null, (MultiValueMap)headers), JsonNode.class).getBody();
        try {
            log.debug("Retorno da requis\u00e7\u00e3o para buscar pix pagos : {} ", (Object)body);
            return (SicoobPixPagoResponse)this.objectMapper.treeToValue((TreeNode)body, SicoobPixPagoResponse.class);
        }
        catch (JsonProcessingException e) {
            log.debug("Erro ao traduzir o retorno do m\u00e9todo getPixPagos para String: ", (Throwable)e);
            throw new RuntimeException("Erro ao traduzir o retorno do m\u00e9todo getPixPagos para String: ", e);
        }
    }

    private URI buildUrlPixPago(LocalDate data, Integer pagina) {
        String baseUrl = this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_API_PIX_CONSULTA);
        return UriComponentsBuilder.fromHttpUrl((String)baseUrl).path(String.format("/%s", PATH_PIX)).queryParam(QUERY_PARAM_PAGINACAO_PAGINA_ATUAL, new Object[]{pagina}).queryParam(QUERY_PARAM_PAGINACAO_ITENS_PAGINA, new Object[]{100}).queryParam(QUERY_PARAM_DATA_INICIO, new Object[]{this.localDateTimeToString(data.atStartOfDay())}).queryParam(QUERY_PARAM_DATA_FIM, new Object[]{this.localDateTimeToString(data.atTime(23, 59, 59))}).build(true).toUri();
    }

    private String getParametro(ParametroGeralEnum parametroGeralEnum) {
        try {
            String parametroInformado = this.parametroGeralService.getParamValueAsString(parametroGeralEnum, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            if (Objects.isNull(parametroInformado) || StringUtils.isEmpty((String)parametroInformado)) {
                throw new ParametroNaoEncontradoException(parametroGeralEnum.getDescricao());
            }
            return parametroInformado;
        }
        catch (ParametroNaoEncontradoException e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    private String localDateTimeToString(LocalDateTime data) {
        return FORMATO_DATA_HORA_API.format(data);
    }

    public IntegracaoPixPagoLog processarPixPagosWebHook(JsonNode pixPagos, Convenio convenio, IntegracaoPixPagoLog log) {
        if (!Boolean.TRUE.equals(convenio.getUtilizaPix()) || !Banco.CODIGO_SICOOB.equals(convenio.getBanco().getId())) {
            throw new EloValidationException(String.format("Banco %s com conv\u00eanio %d n\u00e3o possui PIX", convenio.getBanco().getDescricao(), convenio.getId()));
        }
        Long entidade = this.contextService.getEntidadePrincipal();
        List sicoobPixPagos = SicoobPixPago.to((JsonNode)pixPagos, (ObjectMapper)this.objectMapper);
        LocalDate dataReferencia = this.getDataReferencia(sicoobPixPagos);
        log.setDataReferencia(dataReferencia);
        log.setQuantidadeRegistros(Integer.valueOf(sicoobPixPagos.size()));
        ArrayList baixaAutomaticaDetalhes = new ArrayList();
        if (Boolean.TRUE.equals(convenio.getCriarLotePgtPix())) {
            this.processarLotePagamentoPix(convenio, log, baixaAutomaticaDetalhes, sicoobPixPagos, dataReferencia, entidade);
        } else {
            this.processarPixPago(sicoobPixPagos, log);
        }
        return log;
    }

    private Bloqueto getBloqueto(SicoobPixPago pix, IntegracaoPixPagoDetalhe detalhe) {
        detalhe.setE2eid(pix.getEndToEndId());
        if (StringUtils.isNotBlank((String)pix.getTxid())) {
            detalhe.setTxid(pix.getTxid());
            detalhe.setBuscaPorE2E(Boolean.FALSE);
        } else {
            SicoobPixPago pagamentoByE2E = this.getPagamentoByE2E(pix.getEndToEndId());
            detalhe.setTxid(pagamentoByE2E.getTxid());
            detalhe.setBuscaPorE2E(Boolean.TRUE);
        }
        if (StringUtils.isBlank((String)detalhe.getTxid())) {
            detalhe.setObservacao("N\u00e3o foi possivel encontrar o Txid do pagamento Pix");
            return null;
        }
        Optional bloqueto = this.boletoService.findByTxid(detalhe.getTxid());
        if (bloqueto.isEmpty()) {
            detalhe.setObservacao("N\u00e3o foi possivel encontrar o boleto com o Txid informado");
            return null;
        }
        detalhe.setBoleto(((Bloqueto)bloqueto.get()).getBloqueto());
        detalhe.setExercicioboleto(((Bloqueto)bloqueto.get()).getExercicioBloqueto());
        detalhe.setEntidade(((Bloqueto)bloqueto.get()).getEntidade());
        return (Bloqueto)bloqueto.get();
    }

    private void processarLotePagamentoPix(Convenio convenio, IntegracaoPixPagoLog log, List<BaixaAutomaticaDetalhe> baixaAutomaticaDetalhes, List<SicoobPixPago> sicoobPixPagos, LocalDate dataReferencia, Long entidade) {
        try {
            baixaAutomaticaDetalhes.addAll(this.processarPixPagos(sicoobPixPagos, log));
            if (!baixaAutomaticaDetalhes.isEmpty()) {
                PagamentoLote lote = this.getPagamentoLote(convenio, dataReferencia, entidade, new ImportacaoPixPagoResultadoDTO(), this.getNomeArquivoPixPago(convenio.getConvenio(), dataReferencia));
                AtomicLong sequencia = new AtomicLong(this.baixaAutomaticaDetalheService.getUltimaSequenciaLote(lote.getId()));
                this.salvarItensGerados(baixaAutomaticaDetalhes, lote, sequencia);
                log.setQuantidadeBaixasGeradas(Integer.valueOf(baixaAutomaticaDetalhes.size()));
            }
        }
        catch (Exception e) {
            String mensagemErro = String.format("%s%n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            log.setErro(mensagemErro);
            throw e;
        }
        finally {
            this.saveLog(log);
        }
    }

    public void togglePixBoletoPagoWebhook(Convenio convenio) {
        boolean status;
        ParametroPix parametroPix = this.getParametroPixByEntidade(convenio.getEntidade());
        String clientId = this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_OAUTH_CLIENTID);
        boolean bl = status = convenio.getWebhookPixAtivo() == false;
        if (status) {
            this.activatePixWebhook(convenio, parametroPix, clientId);
        } else {
            this.deactivatePixWebhook(convenio, parametroPix, clientId);
        }
    }

    private void processarPixPago(List<SicoobPixPago> sicoobPixPagos, IntegracaoPixPagoLog log) {
        try {
            sicoobPixPagos.forEach(pix -> {
                IntegracaoPixPagoDetalhe detalhe = new IntegracaoPixPagoDetalhe();
                Bloqueto bloqueto = this.getBloqueto(pix, detalhe);
                if (Objects.isNull(bloqueto)) {
                    return;
                }
                bloqueto.getDebitos().stream().map(BoletoDebito::getId).map(BoletoDebitoID::getDebitoParcelaTributo).map(DebitoParcelaTributo::getDebitoParcela).distinct().forEach(arg_0 -> ((DebitoParcelaService)this.debitoParcelaService).pagarParcelaWebHookPix(arg_0));
                log.getDetalhes().add(detalhe);
            });
        }
        catch (Exception e) {
            String mensagemErro = String.format("%s%n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            log.setErro(mensagemErro);
            throw e;
        }
        finally {
            this.saveLog(log);
        }
    }

    public SicoobPixPago getPagamentoByE2E(String endToendIdentification) {
        String baseUrl = this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_API_PIX_CONSULTA);
        String url = String.format("%s/%s/%s", baseUrl, PATH_PIX, endToendIdentification);
        Long entidade = this.contextService.getEntidadePrincipal();
        ParametroPix parametroPix = this.getParametroPixByEntidade(entidade);
        String clientId = this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_PIX_CONSULTA_ID);
        DadosTokenSicoob dadosTokenSicoob = DadosTokenSicoob.builder().clientId(clientId).scope(SCOPE_PIX).integracaoTokenOperation(IntegracaoTokenOperation.PIX).build();
        DadosHeaderSicoob dadosHeaderSicoob = this.autenticacaoSicoobService.builderDadosHeaders(parametroPix, dadosTokenSicoob);
        HttpHeaders headers = this.autenticacaoSicoobService.builderHeaders(dadosHeaderSicoob);
        SicoobPixPago response = (SicoobPixPago)RestTemplateUtils.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity(null, (MultiValueMap)headers), SicoobPixPago.class, new Object[0]).getBody();
        return response;
    }

    private LocalDate getDataReferencia(List<SicoobPixPago> sicoobPixPagos) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        return LocalDate.parse(sicoobPixPagos.stream().findFirst().map(SicoobPixPago::getHorario).orElseThrow(() -> new EloValidationException("N\u00e3o foi encontrado data do pix")), formatter);
    }

    public ParametroPix getParametroPixByEntidade(Long entidade) {
        return this.parametroPixRepository.getByEntidade(entidade);
    }

    private URI buildWebhookURI(Convenio convenio) {
        String baseUrl = this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_API_PIX_WEBHOOK);
        return UriComponentsBuilder.fromHttpUrl((String)baseUrl).path("/" + convenio.getChavePix()).build().toUri();
    }

    private void activatePixWebhook(Convenio convenio, ParametroPix parametroPix, String clientId) {
        DadosTokenSicoob dadosTokenSicoob = DadosTokenSicoob.builder().clientId(clientId).scope(SCOPE_PIX).integracaoTokenOperation(IntegracaoTokenOperation.PIX).build();
        DadosHeaderSicoob dadosHeaderSicoob = this.autenticacaoSicoobService.builderDadosHeaders(parametroPix, dadosTokenSicoob);
        HttpHeaders headers = this.autenticacaoSicoobService.builderHeaders(dadosHeaderSicoob);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put(BODY_URL_WEB_HOOK, String.format("%s/api/integracao-boleto/%d/webhook/pix", AmbienteUtils.getCurrentURL((ConfigurableEnvironment)this.environment), convenio.getId()));
        this.autenticacaoSicoobService.getRestTemplate(dadosHeaderSicoob.getCertificadoSicoobDTO()).exchange(this.buildWebhookURI(convenio), HttpMethod.PUT, new HttpEntity(body, (MultiValueMap)headers), SicoobPixPagoResponse.class);
    }

    private void deactivatePixWebhook(Convenio convenio, ParametroPix parametroPix, String clientId) {
        DadosTokenSicoob dadosTokenSicoob = DadosTokenSicoob.builder().clientId(clientId).scope(SCOPE_PIX).integracaoTokenOperation(IntegracaoTokenOperation.PIX).build();
        DadosHeaderSicoob dadosHeaderSicoob = this.autenticacaoSicoobService.builderDadosHeaders(parametroPix, dadosTokenSicoob);
        HttpHeaders headers = this.autenticacaoSicoobService.builderHeaders(dadosHeaderSicoob);
        try {
            this.autenticacaoSicoobService.getRestTemplate(dadosHeaderSicoob.getCertificadoSicoobDTO()).exchange(this.buildWebhookURI(convenio), HttpMethod.DELETE, new HttpEntity(null, (MultiValueMap)headers), SicoobPixPagoResponse.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private URI buildUrlSolicitacaoPagamentos() {
        UriComponentsBuilder uri = this.builderUrlSolicitacao();
        return uri.build(true).toUri();
    }

    private URI builderUrlArquivoSolicitacaoPagamento(String numeroContrato, Long codigoSolicitacao, Long idArquivo, String baseUrl) {
        UriComponentsBuilder uriDownload = this.builderUrlMovimentacaoDownload();
        boolean isApiV2 = this.autenticacaoSicoobService.isApiV2(baseUrl);
        return uriDownload.queryParam(isApiV2 ? NUMERO_CONTRATO_MOVIMENTACAO : NUMERO_CLIENTE_MOVIMENTACAO, new Object[]{numeroContrato}).queryParam(CODIGO_SOLICITACAO_MOVIMENTACAO, new Object[]{codigoSolicitacao}).queryParam(ID_ARQUIVO_SOLICITACAO, new Object[]{idArquivo}).build(true).toUri();
    }

    private UriComponentsBuilder builderUrlMovimentacaoDownload() {
        String baseUrl = this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_API_REGPIX_URL);
        boolean isApiV2 = this.autenticacaoSicoobService.isApiV2(baseUrl);
        String urlMovimentacao = URL_BOLETO_MOVIMENTACAO_DOWNLOAD_V2;
        if (!isApiV2) {
            urlMovimentacao = URL_BOLETO_MOVIMENTACAO_DOWNLOAD_V3;
        }
        return UriComponentsBuilder.fromHttpUrl((String)baseUrl).path(urlMovimentacao);
    }

    private UriComponentsBuilder builderUrlSolicitacao() {
        String baseUrl = this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_API_REGPIX_URL);
        boolean isApiV2 = this.autenticacaoSicoobService.isApiV2(baseUrl);
        String urlMovimentacao = URL_BOLETO_MOVIMENTACAO_V2;
        if (!isApiV2) {
            urlMovimentacao = URL_BOLETO_MOVIMENTACAO_V3;
        }
        return UriComponentsBuilder.fromHttpUrl((String)baseUrl).path(urlMovimentacao);
    }

    @Generated
    public SicoobPixPagoService(AutenticacaoSicoobService autenticacaoSicoobService, PagamentoLoteService pagamentoLoteService, ContextService contextService, ValidaDataMovimentacaoService validaDataMovimentacaoService, BloquetoService boletoService, BaixaAutomaticaDetalheService baixaAutomaticaDetalheService, ParametroGeralService parametroGeralService, SolicitacaoPagamentoService solicitacaoPagamentoService, ParametroPixRepository parametroPixRepository, TipoMensagemService tipoMensagemService, IntegracaoPixPagoLogRepository integracaoPixPagoLogRepository, SolicitacaoPagamentoRepository solicitacaoPagamentoRepository, PlatformTransactionManager transactionManager, DebitoParcelaService debitoParcelaService, ObjectMapper objectMapper, ConfigurableEnvironment environment) {
        this.autenticacaoSicoobService = autenticacaoSicoobService;
        this.pagamentoLoteService = pagamentoLoteService;
        this.contextService = contextService;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
        this.boletoService = boletoService;
        this.baixaAutomaticaDetalheService = baixaAutomaticaDetalheService;
        this.parametroGeralService = parametroGeralService;
        this.solicitacaoPagamentoService = solicitacaoPagamentoService;
        this.parametroPixRepository = parametroPixRepository;
        this.tipoMensagemService = tipoMensagemService;
        this.integracaoPixPagoLogRepository = integracaoPixPagoLogRepository;
        this.solicitacaoPagamentoRepository = solicitacaoPagamentoRepository;
        this.transactionManager = transactionManager;
        this.debitoParcelaService = debitoParcelaService;
        this.objectMapper = objectMapper;
        this.environment = environment;
    }
}

