/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.sicoob;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.NossoNumeroSicoob;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParametroPix;
import br.com.elotech.tributos.domain.TipoCodigoBarras;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.domain.registroboletoonline.ErroBoletoRegistroOnline;
import br.com.elotech.tributos.dto.CodigoBarrasDTO;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.DadosHeaderSicoob;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.DadosTokenSicoob;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.boletoregistrado.BoletoRegistradoSicoobDTO;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import br.com.elotech.tributos.enums.integracaoboleto.TipoIntegracaoBoletoPix;
import br.com.elotech.tributos.repository.BancoRepository;
import br.com.elotech.tributos.repository.ParametroPixRepository;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.cnab240.ParametroCNAB240Repository;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoBoletoPixLogRepository;
import br.com.elotech.tributos.repository.registroboletoonline.ErroBoletoRegistradoOnlineRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoBoletoRegistrado;
import br.com.elotech.tributos.service.integracaoboleto.sicoob.AutenticacaoSicoobService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.MultiValueMap;

@Service
public class IntegracaoBoletoRegistradoSicoobService
implements IntegracaoBoletoRegistrado {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoBoletoRegistradoSicoobService.class);
    private static final String APPLICATION_JSON = "application/json";
    private static final String ACCEPT = "Accept";
    private static final String SEQUENCE_NOSSO_NUMERO_SICOOB = "s05nossonumerosicoob";
    private static final String JSON_TAG_RESULTADO = "resultado";
    private static final String JSON_TAG_QRCODE = "qrCode";
    private static final String JSON_TAG_NOSSONUMERO = "nossoNumero";
    private static final String JSON_TAG_CODGIOBARRAS = "codigoBarras";
    private static final String JSON_TAG_LINHADIGITAVEL = "linhaDigitavel";
    private static final String JSON_TAG_V2_BOLETO = "boleto";
    private static final String JSON_TAG_V2_STATUS = "status";
    private static final String JSON_TAG_V2_STATUS_CODIGO = "codigo";
    private static final String JSON_TAG_V2_STATUS_MENSAGEM = "mensagem";
    private final AutenticacaoSicoobService autenticacaoSicoobService;
    private final ParametroGeralService parametroGeralService;
    private final ParametroCNAB240Repository parametroCNAB240Repository;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final ParametroPixRepository parametroPixRepository;
    private final BancoRepository bancoRepository;
    private final ErroBoletoRegistradoOnlineRepository erroBoletoRegistradoOnlineRepository;
    private final IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository;
    private final ObjectMapper mapper;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);

    public CodigoBarrasDTO generateBoleto(Bloqueto boleto, ParametroCNAB240 parametroCNAB240) {
        HttpEntity request = null;
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(this.getTipoIntegracao(boleto));
        String clientId = this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_OAUTH_CLIENTID);
        String url = String.format("%s/boletos", this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_API_REGPIX_URL));
        String scope = this.autenticacaoSicoobService.getApiScope(url);
        boolean isApiV2 = this.autenticacaoSicoobService.isApiV2(url);
        ParametroPix parametroPix = this.parametroPixRepository.getByEntidade(boleto.getEntidade());
        DadosTokenSicoob dadosTokenSicoob = DadosTokenSicoob.builder().clientId(clientId).scope(scope).integracaoTokenOperation(IntegracaoTokenOperation.BOLETO).build();
        DadosHeaderSicoob dadosHeaderSicoob = this.autenticacaoSicoobService.builderDadosHeaders(parametroPix, dadosTokenSicoob);
        HttpHeaders headers = this.autenticacaoSicoobService.builderHeaders(dadosHeaderSicoob);
        headers.set(ACCEPT, APPLICATION_JSON);
        try {
            integracaoBoletoPixLog.setBloqueto(boleto.getId());
            integracaoBoletoPixLog.setDataIntegracao(LocalDateTime.now());
            BoletoRegistradoSicoobDTO dto = BoletoRegistradoSicoobDTO.from((Bloqueto)boleto, (ParametroCNAB240)parametroCNAB240, (boolean)isApiV2);
            request = isApiV2 ? new HttpEntity(List.of(dto), (MultiValueMap)headers) : new HttpEntity((Object)this.mapper.writeValueAsString((Object)dto), (MultiValueMap)headers);
            integracaoBoletoPixLog.setJsonRequest(this.mapper.writeValueAsString((Object)request));
            integracaoBoletoPixLog.setUrlRequest(url);
            integracaoBoletoPixLog.setHttpMethod(HttpMethod.POST);
            JsonNode bodyResponse = (JsonNode)this.autenticacaoSicoobService.getRestTemplate(dadosHeaderSicoob.getCertificadoSicoobDTO()).exchange(url, HttpMethod.POST, request, JsonNode.class, new Object[0]).getBody();
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)bodyResponse));
            JsonNode dadosResponse = (JsonNode)this.mapper.treeToValue((TreeNode)bodyResponse, JsonNode.class);
            JsonNode resultadoNode = dadosResponse.path(JSON_TAG_RESULTADO);
            if (isApiV2) {
                JsonNode resultado = resultadoNode.get(0);
                JsonNode statusNode = resultado.path(JSON_TAG_V2_STATUS);
                resultadoNode = resultado.path(JSON_TAG_V2_BOLETO);
                Integer statusCodigo = Integer.parseInt(this.getValueTag(statusNode, JSON_TAG_V2_STATUS_CODIGO));
                String statusMensagem = this.getValueTag(statusNode, JSON_TAG_V2_STATUS_MENSAGEM);
                if (Objects.nonNull(statusNode) && !HttpStatus.valueOf((int)statusCodigo).is2xxSuccessful()) {
                    throw new RestException(HttpStatus.valueOf((int)statusCodigo), statusMensagem);
                }
            }
            String qrCode = this.getValueTag(resultadoNode, JSON_TAG_QRCODE);
            String nossoNumero = this.getValueTag(resultadoNode, JSON_TAG_NOSSONUMERO);
            String codigoBarras = this.getValueTag(resultadoNode, JSON_TAG_CODGIOBARRAS);
            String linhaDigitavel = this.getValueTag(resultadoNode, JSON_TAG_LINHADIGITAVEL);
            if (!StringUtils.isEmpty((CharSequence)qrCode)) {
                boleto.setTextoQrCode(qrCode);
            }
            CodigoBarrasDTO codigoBarrasDTO = this.builderCodigoBarras(nossoNumero, codigoBarras, linhaDigitavel);
            return codigoBarrasDTO;
        }
        catch (RestException e) {
            this.saveRespostaErro(request, integracaoBoletoPixLog.getJsonResponse(), boleto, e.getMessage());
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(e.getStatus(), String.format("Erro ao enviar o boleto registrado para o Banco Sicoob: %s", e.getMessage()), (Throwable)e);
        }
        catch (JsonProcessingException e) {
            this.saveRespostaErro(request, integracaoBoletoPixLog.getJsonResponse(), boleto, e.getMessage());
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RuntimeException("Erro ao traduzir o retorno do registro de boleto para String:  ", e);
        }
        catch (Exception e) {
            this.saveRespostaErro(request, integracaoBoletoPixLog.getJsonResponse(), boleto, e.getMessage());
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
        }
    }

    public ParametroCNAB240 getParametroCnab240ByBanco() {
        return (ParametroCNAB240)this.parametroCNAB240Repository.findFirstByBanco((Banco)this.bancoRepository.findOne((Object)Banco.CODIGO_SICOOB)).orElseThrow(() -> new EloValidationException("Par\u00e2metro CNAB 240 n\u00e3o encontrado para o Banco Sicoob!"));
    }

    public TipoCodigoBarras getTipoCodigoBarras() {
        return TipoCodigoBarras.BOLETO_BANCARIO_SICOOB_CNAB240_COM_REGISTRO;
    }

    public void beforeGenerateBoleto(Bloqueto boleto) {
        if (StringUtils.isBlank((CharSequence)boleto.getNossoNumero())) {
            boleto.setNossoNumero(StringUtils.leftPad((String)this.sequenceGeneratorRepository.getNextVal(SEQUENCE_NOSSO_NUMERO_SICOOB).toString(), (int)7, (String)"0"));
            boleto.setDvNossoNumero(new NossoNumeroSicoob().gerarDVNossoNumero(boleto));
        }
    }

    private TipoIntegracaoBoletoPix getTipoIntegracao(Bloqueto boleto) {
        return Boolean.TRUE.equals(boleto.getModeloBloqueto().getConvenio().getUtilizaPix()) ? TipoIntegracaoBoletoPix.GERA_BOLETO_COM_PIX : TipoIntegracaoBoletoPix.GERA_BOLETO;
    }

    private void saveRespostaErro(HttpEntity<?> request, String response, Bloqueto boleto, String observacao) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                ErroBoletoRegistroOnline erroRegistroBoletoOnlineEntity = new ErroBoletoRegistroOnline();
                erroRegistroBoletoOnlineEntity.setRequest(Objects.nonNull(request) ? this.mapper.writeValueAsBytes((Object)request) : null);
                erroRegistroBoletoOnlineEntity.setResponse((byte[])Optional.ofNullable(response).map(String::getBytes).orElse(null));
                erroRegistroBoletoOnlineEntity.setDataHoraIntegracao(LocalDateTime.now());
                erroRegistroBoletoOnlineEntity.setIdBoleto(boleto.getId());
                erroRegistroBoletoOnlineEntity.setDetalhes(observacao);
                return (ErroBoletoRegistroOnline)this.erroBoletoRegistradoOnlineRepository.save((Object)erroRegistroBoletoOnlineEntity);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    private void salvarIntegracaoBoletoPixLog(IntegracaoBoletoPixLog integracaoBoletoPixLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoBoletoPixLog)this.integracaoBoletoPixLogRepository.save((Object)integracaoBoletoPixLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    private String getParametro(ParametroGeralEnum parametroGeralEnum) {
        try {
            String valor = this.parametroGeralService.getParamValueAsString(parametroGeralEnum, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            if (Objects.isNull(valor) || StringUtils.isEmpty((CharSequence)valor)) {
                throw new ParametroNaoEncontradoException(parametroGeralEnum.getDescricao());
            }
            return valor;
        }
        catch (ParametroNaoEncontradoException e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    public String getValueTag(JsonNode node, String tag) {
        return node.has(tag) ? node.get(tag).asText() : null;
    }

    public CodigoBarrasDTO builderCodigoBarras(String nossoNumero, String codigoBarras, String linhaDigitavel) {
        CodigoBarrasDTO codigoBarrasDTO = new CodigoBarrasDTO();
        codigoBarrasDTO.setNossoNumero(StringUtils.leftPad((String)nossoNumero.substring(0, nossoNumero.length() - 1), (int)7, (String)"0"));
        codigoBarrasDTO.setDvNossoNumero(nossoNumero.substring(nossoNumero.length() - 1));
        codigoBarrasDTO.setCodigoBarras(codigoBarras);
        codigoBarrasDTO.setLinhaDigitavel(linhaDigitavel);
        codigoBarrasDTO.setCampo1(StringUtils.substring((String)linhaDigitavel, (int)0, (int)10));
        codigoBarrasDTO.setCampo2(StringUtils.substring((String)linhaDigitavel, (int)10, (int)20));
        codigoBarrasDTO.setCampo3(StringUtils.substring((String)linhaDigitavel, (int)20, (int)30));
        codigoBarrasDTO.setCampo4(StringUtils.substring((String)linhaDigitavel, (int)30, (int)31));
        codigoBarrasDTO.setCampo5(StringUtils.substring((String)linhaDigitavel, (int)31, (int)47));
        return codigoBarrasDTO;
    }

    @Generated
    public IntegracaoBoletoRegistradoSicoobService(AutenticacaoSicoobService autenticacaoSicoobService, ParametroGeralService parametroGeralService, ParametroCNAB240Repository parametroCNAB240Repository, SequenceGeneratorRepository sequenceGeneratorRepository, ParametroPixRepository parametroPixRepository, BancoRepository bancoRepository, ErroBoletoRegistradoOnlineRepository erroBoletoRegistradoOnlineRepository, IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository, ObjectMapper mapper, PlatformTransactionManager transactionManager) {
        this.autenticacaoSicoobService = autenticacaoSicoobService;
        this.parametroGeralService = parametroGeralService;
        this.parametroCNAB240Repository = parametroCNAB240Repository;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.parametroPixRepository = parametroPixRepository;
        this.bancoRepository = bancoRepository;
        this.erroBoletoRegistradoOnlineRepository = erroBoletoRegistradoOnlineRepository;
        this.integracaoBoletoPixLogRepository = integracaoBoletoPixLogRepository;
        this.mapper = mapper;
        this.transactionManager = transactionManager;
    }
}

