/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.sicoob;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.validation.EloValidatorExecutor;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParametroPix;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.dto.integracaoboleto.IntegracaoPixResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.CobrancaPixSicoobDTO;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.DadosHeaderSicoob;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.DadosTokenSicoob;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.QrCodePixSicoobErroDTO;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import br.com.elotech.tributos.enums.integracaoboleto.TipoIntegracaoBoletoPix;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.ParametroPixRepository;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoBoletoPixLogRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoPix;
import br.com.elotech.tributos.service.integracaoboleto.sicoob.AutenticacaoSicoobService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.MultiValueMap;

@Service
public class IntegracaoBoletoPixSicoobService
implements IntegracaoPix {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoBoletoPixSicoobService.class);
    private final EloValidatorExecutor eloValidatorExecutor;
    private final ParametroGeralService parametroGeralService;
    private final EntidadeRepository entidadeRepository;
    private final ObjectMapper mapper;
    private final ParametroPixRepository parametroPixRepository;
    private final IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    private final AutenticacaoSicoobService autenticacaoSicoobService;
    private static final String SCOPE = "cobv.write pix.read webhook.read webhook.write";
    private static final String TAG_BRCODE = "brcode";
    private static final String TAG_TXID = "txid";

    public IntegracaoPixResponseDTO generateQrCodePix(Bloqueto boleto) {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.GERA_PIX);
        try {
            Validate.notNull((Object)boleto, (String)"O boleto \u00e9 obrigat\u00f3rio para gerar o qrcode do pix.");
            this.validarModeloBoletoEntidadeRegistro(boleto);
            integracaoBoletoPixLog.setBloqueto(boleto.getId());
            Entidade entidade = (Entidade)this.entidadeRepository.findById((Object)boleto.getEntidade()).orElseThrow(() -> new EloValidationException(String.format("Entidade %d do boleto n\u00e3o encontrada", boleto.getEntidade())));
            String clientId = this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_OAUTH_CLIENTID);
            String txid = this.gerarTxid(boleto.getModeloBloqueto().getConvenio().getChavePix(), entidade.getCnpj());
            String url = String.format("%s/%s", this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_API_PIX_URL), txid);
            CobrancaPixSicoobDTO dto = CobrancaPixSicoobDTO.from((Bloqueto)boleto);
            dto.validate(this.eloValidatorExecutor);
            ParametroPix parametroPix = this.parametroPixRepository.getByEntidade(boleto.getEntidade());
            DadosTokenSicoob dadosTokenSicoob = DadosTokenSicoob.builder().clientId(clientId).scope(SCOPE).integracaoTokenOperation(IntegracaoTokenOperation.BOLETO).build();
            DadosHeaderSicoob dadosHeaderSicoob = this.autenticacaoSicoobService.builderDadosHeaders(parametroPix, dadosTokenSicoob);
            HttpHeaders headers = this.autenticacaoSicoobService.builderHeaders(dadosHeaderSicoob);
            HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
            HttpMethod httpMethod = HttpMethod.PUT;
            integracaoBoletoPixLog.setJsonRequest(this.mapper.writeValueAsString((Object)requestEntity));
            integracaoBoletoPixLog.setHttpMethod(httpMethod);
            integracaoBoletoPixLog.setUrlRequest(url);
            JsonNode response = (JsonNode)this.autenticacaoSicoobService.getRestTemplate(dadosHeaderSicoob.getCertificadoSicoobDTO()).exchange(url, httpMethod, requestEntity, JsonNode.class, new Object[0]).getBody();
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)response));
            IntegracaoPixResponseDTO resultDto = new IntegracaoPixResponseDTO();
            resultDto.setTextoQrCode(response.get(TAG_BRCODE).asText());
            resultDto.setTxid(response.get(TAG_TXID).asText());
            IntegracaoPixResponseDTO integracaoPixResponseDTO = resultDto;
            return integracaoPixResponseDTO;
        }
        catch (RestException e) {
            QrCodePixSicoobErroDTO dtoErros = this.converteErroResposta(e.getMessage());
            integracaoBoletoPixLog.setDescricaoErro(dtoErros.getErrosConcatenado());
            integracaoBoletoPixLog.setJsonResponse(e.getMessage());
            throw new RestException(e.getStatus(), dtoErros.getErrosConcatenado(), (Throwable)e);
        }
        catch (Exception e) {
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
        }
    }

    private QrCodePixSicoobErroDTO converteErroResposta(String json) {
        try {
            return (QrCodePixSicoobErroDTO)this.mapper.readValue(json, QrCodePixSicoobErroDTO.class);
        }
        catch (JsonProcessingException e) {
            QrCodePixSicoobErroDTO erroDTO = new QrCodePixSicoobErroDTO();
            erroDTO.setTitle("Erro ao ler o json do retorno com erro. " + e.getMessage());
            return erroDTO;
        }
    }

    private void salvarIntegracaoBoletoPixLog(IntegracaoBoletoPixLog integracaoBoletoPixLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoBoletoPixLog)this.integracaoBoletoPixLogRepository.save((Object)integracaoBoletoPixLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public Long getCodigoBanco() {
        return Banco.CODIGO_SICOOB;
    }

    private String gerarTxid(String chave, String cnpj) {
        String dataHoraAtual = LocalDateTime.now().toString();
        return DigestUtils.md5Hex((String)(dataHoraAtual + chave + cnpj));
    }

    private String getParametro(ParametroGeralEnum parametroGeralEnum) {
        String valor = this.parametroGeralService.getParamValueAsString(parametroGeralEnum, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (Objects.isNull(valor) || StringUtils.isEmpty((String)valor)) {
            throw new ParametroNaoEncontradoException(parametroGeralEnum.getDescricao());
        }
        return valor;
    }

    private void validarModeloBoletoEntidadeRegistro(Bloqueto boleto) {
        Convenio convenio = Optional.ofNullable(boleto).map(Bloqueto::getModeloBloqueto).map(ModeloBoleto::getConvenio).orElseThrow(() -> new EloValidationException("N\u00e3o existe um conv\u00eanio vinculado ao modelo de bloqueto!"));
        Optional.ofNullable(convenio.getEntidadeRegistro()).orElseThrow(() -> new EloValidationException(String.format("Necess\u00e1rio vincular a entidade para registro do boleto ao conv\u00eanio %s!", convenio.getNumeroConvenio())));
    }

    @Generated
    public IntegracaoBoletoPixSicoobService(EloValidatorExecutor eloValidatorExecutor, ParametroGeralService parametroGeralService, EntidadeRepository entidadeRepository, ObjectMapper mapper, ParametroPixRepository parametroPixRepository, IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository, PlatformTransactionManager transactionManager, AutenticacaoSicoobService autenticacaoSicoobService) {
        this.eloValidatorExecutor = eloValidatorExecutor;
        this.parametroGeralService = parametroGeralService;
        this.entidadeRepository = entidadeRepository;
        this.mapper = mapper;
        this.parametroPixRepository = parametroPixRepository;
        this.integracaoBoletoPixLogRepository = integracaoBoletoPixLogRepository;
        this.transactionManager = transactionManager;
        this.autenticacaoSicoobService = autenticacaoSicoobService;
    }
}

