/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.santander;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.BoletoDebitoID;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.MovimentacaoDiariaId;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParametroPix;
import br.com.elotech.tributos.domain.TipoArquivoRetornoPagamento;
import br.com.elotech.tributos.domain.TipoOperacaoDebito;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoPixPagoDetalhe;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoPixPagoLog;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalheId;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.domain.pagamento.SituacaoPagamentoLote;
import br.com.elotech.tributos.domain.pagamento.TipoPagamentoLote;
import br.com.elotech.tributos.domain.tipomensagem.ClassificacaoTipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagemEnum;
import br.com.elotech.tributos.dto.integracaoboleto.DadosCertificadoDTO;
import br.com.elotech.tributos.dto.integracaoboleto.DadosIntegracaoOauth;
import br.com.elotech.tributos.dto.integracaoboleto.santander.SantanderPixPago;
import br.com.elotech.tributos.dto.pagamento.ImportacaoPixPagoResultadoDTO;
import br.com.elotech.tributos.dto.pagamento.solicitacaopagamento.SolicitacaoPagamentoDTO;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import br.com.elotech.tributos.enums.TipoIntegracaoToken;
import br.com.elotech.tributos.enums.integracaoboleto.TipoIntegracaoBoletoPix;
import br.com.elotech.tributos.repository.ParametroPixRepository;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoBoletoPixLogRepository;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoPixPagoLogRepository;
import br.com.elotech.tributos.service.BaixaAutomaticaDetalheService;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.TipoMensagemService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoBoleto;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoPixPagoService;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoTokenService;
import br.com.elotech.tributos.util.AmbienteUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SantanderPixPagoService
extends IntegracaoBoleto
implements IntegracaoPixPagoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SantanderPixPagoService.class);
    private static final String AUTHORIZATION = "Authorization";
    private static final String BEARER = "Bearer %s";
    private static final DateTimeFormatter FORMATO_NOME_ARQUIVO = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
    private final ConfigurableEnvironment environment;
    private final ParametroPixRepository parametroPixRepository;
    private final ObjectMapper objectMapper;
    private final ContextService contextService;
    private final BloquetoService boletoService;
    private final DebitoParcelaService debitoParcelaService;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    private final IntegracaoPixPagoLogRepository integracaoPixPagoLogRepository;
    private final TipoMensagemService tipoMensagemService;
    private final BaixaAutomaticaDetalheService baixaAutomaticaDetalheService;
    private final PagamentoLoteService pagamentoLoteService;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;

    public SantanderPixPagoService(List<IntegracaoTokenService> integracaoTokenServices, ParametroGeralService parametroGeralService, IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository, PlatformTransactionManager transactionManager, ConfigurableEnvironment environment, ParametroPixRepository parametroPixRepository, ObjectMapper objectMapper, ContextService contextService, BloquetoService boletoService, DebitoParcelaService debitoParcelaService, IntegracaoPixPagoLogRepository integracaoPixPagoLogRepository, TipoMensagemService tipoMensagemService, BaixaAutomaticaDetalheService baixaAutomaticaDetalheService, PagamentoLoteService pagamentoLoteService, ValidaDataMovimentacaoService validaDataMovimentacaoService) {
        super(integracaoTokenServices, parametroGeralService, integracaoBoletoPixLogRepository, transactionManager, (TransactionDefinition)new DefaultTransactionDefinition(3));
        this.environment = environment;
        this.parametroPixRepository = parametroPixRepository;
        this.objectMapper = objectMapper;
        this.contextService = contextService;
        this.boletoService = boletoService;
        this.debitoParcelaService = debitoParcelaService;
        this.transactionManager = transactionManager;
        this.integracaoPixPagoLogRepository = integracaoPixPagoLogRepository;
        this.tipoMensagemService = tipoMensagemService;
        this.baixaAutomaticaDetalheService = baixaAutomaticaDetalheService;
        this.pagamentoLoteService = pagamentoLoteService;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
    }

    public ImportacaoPixPagoResultadoDTO importarPixPago(Convenio convenio, LocalDate dataReferencia) {
        throw new EloValidationException("Integra\u00e7\u00e3o para receber pix pagos para o banco Santander n\u00e3o implementada.");
    }

    public Boolean accept(Convenio convenio) {
        return Banco.CODIGO_SANTANDER.equals(convenio.getBanco().getId());
    }

    public IntegracaoPixPagoLog processarPixPagosWebHook(JsonNode pixPagos, Convenio convenio, IntegracaoPixPagoLog log) {
        if (!Boolean.TRUE.equals(convenio.getUtilizaPix()) || !Banco.CODIGO_SANTANDER.equals(convenio.getBanco().getId())) {
            throw new EloValidationException(String.format("Banco %s com conv\u00eanio %d n\u00e3o possui PIX", convenio.getBanco().getDescricao(), convenio.getId()));
        }
        Long entidade = this.contextService.getEntidadePrincipal();
        List santanderPixPagos = SantanderPixPago.from((JsonNode)pixPagos, (ObjectMapper)this.objectMapper);
        LocalDate dataReferencia = this.getDataReferencia(santanderPixPagos);
        log.setDataReferencia(dataReferencia);
        log.setQuantidadeRegistros(Integer.valueOf(santanderPixPagos.size()));
        if (Boolean.TRUE.equals(convenio.getCriarLotePgtPix())) {
            this.processaLotePagamentoPix(convenio, log, santanderPixPagos, dataReferencia, entidade);
        } else {
            this.processarPixPago(santanderPixPagos, log, convenio);
        }
        return log;
    }

    public void togglePixBoletoPagoWebhook(Convenio convenio) {
        boolean status;
        DadosCertificadoDTO certificadoSantander = this.getDadosCertificado(convenio);
        DadosIntegracaoOauth dadosOauth = this.getDadosIntegracaoOauth();
        boolean bl = status = convenio.getWebhookPixAtivo() == false;
        if (status) {
            this.activatePixWebhook(convenio, certificadoSantander, dadosOauth);
        } else {
            this.deactivatePixWebhook(convenio, certificadoSantander, dadosOauth);
        }
    }

    protected MultiValueMap<String, String> authBodyBuilder(DadosIntegracaoOauth dadosOauth) {
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"grant_type", (Object)"client_credentials");
        body.add((Object)"client_id", (Object)dadosOauth.getClientId());
        body.add((Object)"client_secret", (Object)dadosOauth.getClientSecret());
        return body;
    }

    private void activatePixWebhook(Convenio convenio, DadosCertificadoDTO dadosCertificadoDTO, DadosIntegracaoOauth dadosIntegracaoOauth) {
        try {
            String accessToken = this.getAccessToken(Banco.CODIGO_SANTANDER, IntegracaoTokenOperation.PIX, dadosIntegracaoOauth, dadosCertificadoDTO, this.authBodyBuilder(dadosIntegracaoOauth), TipoIntegracaoToken.DEFAULT.name());
            String url = String.format("%s/webhook/%s", this.getParametro(ParametroGeralEnum.BOLETO_SANTANDER_API_PIX_URL), convenio.getChavePix());
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("webhookUrl", String.format("%s/api/integracao-boleto/%d/webhook/pix", AmbienteUtils.getCurrentURL((ConfigurableEnvironment)this.environment), convenio.getId()));
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            headers.set("Authorization", String.format("Bearer %s", accessToken));
            HttpEntity requestEntity = new HttpEntity(body, (MultiValueMap)headers);
            this.getHttpClientTemplate(dadosCertificadoDTO).exchange(url, HttpMethod.PUT, requestEntity, JsonNode.class, new Object[0]);
        }
        catch (Exception e) {
            throw new EloValidationException(String.format("Erro ao ativar webhook do pix, %s", e.getMessage()));
        }
    }

    private void deactivatePixWebhook(Convenio convenio, DadosCertificadoDTO dadosCertificadoDTO, DadosIntegracaoOauth dadosIntegracaoOauth) {
        try {
            String accessToken = this.getAccessToken(Banco.CODIGO_SANTANDER, IntegracaoTokenOperation.PIX, dadosIntegracaoOauth, dadosCertificadoDTO, this.authBodyBuilder(dadosIntegracaoOauth), TipoIntegracaoToken.DEFAULT.name());
            String url = String.format("%s/webhook/%s", this.getParametro(ParametroGeralEnum.BOLETO_SANTANDER_API_PIX_URL), convenio.getChavePix());
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            headers.set("Authorization", String.format("Bearer %s", accessToken));
            this.getHttpClientTemplate(dadosCertificadoDTO).exchange(url, HttpMethod.DELETE, new HttpEntity((MultiValueMap)headers), JsonNode.class, new Object[0]);
        }
        catch (Exception e) {
            throw new EloValidationException(String.format("Erro ao desativar webhook do pix, %s", e.getMessage()));
        }
    }

    private void processaLotePagamentoPix(Convenio convenio, IntegracaoPixPagoLog log, List<SantanderPixPago> listPixPagos, LocalDate dataReferencia, Long entidade) {
        try {
            List baixaAutomaticaDetalhes = this.processarPixPagoLote(listPixPagos, log, convenio);
            if (!baixaAutomaticaDetalhes.isEmpty()) {
                PagamentoLote lote = this.getPagamentoLote(convenio, dataReferencia, entidade, new ImportacaoPixPagoResultadoDTO());
                AtomicLong sequence = new AtomicLong(this.baixaAutomaticaDetalheService.getUltimaSequenciaLote(lote.getId()));
                this.salvarItensGerados(baixaAutomaticaDetalhes, lote, sequence);
                log.setQuantidadeBaixasGeradas(Integer.valueOf(baixaAutomaticaDetalhes.size()));
            }
        }
        catch (Exception e) {
            String mensagemErro = String.format("%s%n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            log.setErro(mensagemErro);
            throw e;
        }
        finally {
            this.salvarIntegracaoBoletoPixPagoLog(log);
        }
    }

    private PagamentoLote getPagamentoLote(Convenio convenio, LocalDate dataReferencia, Long entidade, ImportacaoPixPagoResultadoDTO resultado) {
        this.validaMovimentacao(entidade, dataReferencia);
        Optional loteJaExistente = this.pagamentoLoteService.findAbertoByConvenioAndData(convenio, dataReferencia);
        resultado.setLoteNovo(Boolean.valueOf(loteJaExistente.isEmpty()));
        return loteJaExistente.orElseGet(() -> this.createPagamentoLote(convenio, entidade, dataReferencia));
    }

    private PagamentoLote createPagamentoLote(Convenio convenio, Long entidade, LocalDate dataReferencia) {
        Long exercicio = this.contextService.getExercicioAtual();
        PagamentoLoteId id = new PagamentoLoteId();
        id.setEntidade(entidade);
        id.setExercicio(exercicio);
        PagamentoLote pagamentoLote = new PagamentoLote();
        pagamentoLote.setId(id);
        pagamentoLote.setDataLote(LocalDate.now());
        pagamentoLote.setDataMovimento(dataReferencia);
        pagamentoLote.setDataCredito(dataReferencia);
        pagamentoLote.setSituacao(SituacaoPagamentoLote.ABERTO);
        pagamentoLote.setTipo(TipoPagamentoLote.PIX);
        pagamentoLote.setConvenio(convenio);
        pagamentoLote.setContaBancaria(convenio.getContaBancaria());
        pagamentoLote.setBanco(convenio.getBanco());
        pagamentoLote.setArquivoRetorno(Boolean.FALSE);
        pagamentoLote.setLoteManual(Boolean.FALSE);
        pagamentoLote.setNumeroBaixas(Long.valueOf(0L));
        pagamentoLote.setTipoArquivo(TipoArquivoRetornoPagamento.RETORNO_PIX);
        pagamentoLote.setObservacao("Lote gerado pela importa\u00e7\u00e3o de pix");
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime dataReferenciaComHoraAtual = dataReferencia.atTime(now.getHour(), now.getMinute(), now.getSecond());
        pagamentoLote.setNomeArquivo(String.format("importacao_pix_%d_%s", convenio.getConvenio(), FORMATO_NOME_ARQUIVO.format(dataReferenciaComHoraAtual)));
        return (PagamentoLote)this.pagamentoLoteService.save((EloEntity)pagamentoLote, null);
    }

    private void validaMovimentacao(Long entidade, LocalDate dataReferencia) {
        MovimentacaoDiariaId movimentacaoDiariaId = new MovimentacaoDiariaId();
        movimentacaoDiariaId.setEntidade(entidade);
        movimentacaoDiariaId.setData(dataReferencia);
        this.validaDataMovimentacaoService.verificaMovimentacaoDiaria(movimentacaoDiariaId);
    }

    private void salvarItensGerados(List<BaixaAutomaticaDetalhe> itensGerados, PagamentoLote lote, AtomicLong sequencia) {
        itensGerados.forEach(baixaAutomaticaDetalhe -> {
            BaixaAutomaticaDetalheId id = new BaixaAutomaticaDetalheId();
            id.setSequenciaArquivo(Long.valueOf(sequencia.incrementAndGet()));
            id.setLote(lote.getId().getLote());
            id.setEntidade(lote.getId().getEntidade());
            id.setExercicio(lote.getId().getExercicio());
            baixaAutomaticaDetalhe.setId(id);
            baixaAutomaticaDetalhe.setPagamentoLote(lote);
            baixaAutomaticaDetalhe.setDataCredito(lote.getDataCredito());
            baixaAutomaticaDetalhe.setDataPagamento(lote.getDataMovimento());
            baixaAutomaticaDetalhe.setContaBancaria(lote.getContaBancaria());
            baixaAutomaticaDetalhe.setConvenio(lote.getConvenio());
            baixaAutomaticaDetalhe.setBanco(lote.getBanco());
            this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
        });
        Long numeroBaixasAtual = Optional.ofNullable(lote.getNumeroBaixas()).orElse(0L);
        lote.setNumeroBaixas(Long.valueOf(numeroBaixasAtual + (long)itensGerados.size()));
    }

    private List<BaixaAutomaticaDetalhe> processarPixPagoLote(List<SantanderPixPago> listPixPago, IntegracaoPixPagoLog log, Convenio convenio) {
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.IMPORTADO);
        return listPixPago.stream().map(pix -> {
            IntegracaoPixPagoDetalhe detalhe = new IntegracaoPixPagoDetalhe();
            log.getDetalhes().add(detalhe);
            try {
                Bloqueto bloqueto = this.getBloqueto(pix, detalhe, convenio);
                if (Objects.isNull(bloqueto)) {
                    return null;
                }
                if (this.baixaAutomaticaDetalheService.existsByBoleto(bloqueto)) {
                    detalhe.setObservacao("Boleto j\u00e1 importado");
                    return null;
                }
                detalhe.setObservacao("Boleto importado com sucesso");
                return SantanderPixPagoService.getBaixaAutomaticaDetalhe((SantanderPixPago)pix, (Bloqueto)bloqueto, (TipoMensagem)tipoMensagem);
            }
            catch (Exception ex) {
                detalhe.setMensagemErro(ex.toString());
                SantanderPixPagoService.log.error("Ocorreu um erro ao processar pix pagos {}", (Object)ex.getMessage(), (Object)ex);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static BaixaAutomaticaDetalhe getBaixaAutomaticaDetalhe(SantanderPixPago pix, Bloqueto bloqueto, TipoMensagem tipoMensagem) {
        BaixaAutomaticaDetalhe baixaAutomaticaDetalhe = new BaixaAutomaticaDetalhe();
        baixaAutomaticaDetalhe.setBoleto(bloqueto);
        baixaAutomaticaDetalhe.setNossoNumero(bloqueto.getNossoNumero());
        baixaAutomaticaDetalhe.setSituacao(ClassificacaoTipoMensagem.IMPORTADO);
        baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.IMPORTADO.getDescricao());
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        baixaAutomaticaDetalhe.setDataVencimento(bloqueto.getDataVencimento());
        baixaAutomaticaDetalhe.setDataCreditoArquivo(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setDataPagamentoArquivo(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setDiferencaEmValor(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setDiferencaMaxima(BigDecimal.ZERO);
        baixaAutomaticaDetalhe.setAlterado(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setDescontoConcedido(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setCreditoConcedido(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setValor(BigDecimal.ZERO);
        baixaAutomaticaDetalhe.setValorPago(pix.getValor());
        baixaAutomaticaDetalhe.setValorPagoPrincipal(pix.getValor());
        baixaAutomaticaDetalhe.setValorPagoJuros(BigDecimal.ZERO);
        baixaAutomaticaDetalhe.setValorPagoMulta(BigDecimal.ZERO);
        baixaAutomaticaDetalhe.setTipoOperacao(TipoOperacaoDebito.NENHUMA_OPERACAO);
        return baixaAutomaticaDetalhe;
    }

    private void processarPixPago(List<SantanderPixPago> listPixPago, IntegracaoPixPagoLog log, Convenio convenio) {
        try {
            listPixPago.forEach(pix -> {
                IntegracaoPixPagoDetalhe detalhe = new IntegracaoPixPagoDetalhe();
                Bloqueto bloqueto = this.getBloqueto(pix, detalhe, convenio);
                if (Objects.isNull(bloqueto)) {
                    return;
                }
                bloqueto.getDebitos().stream().map(BoletoDebito::getId).map(BoletoDebitoID::getDebitoParcelaTributo).map(DebitoParcelaTributo::getDebitoParcela).distinct().forEach(arg_0 -> ((DebitoParcelaService)this.debitoParcelaService).pagarParcelaWebHookPix(arg_0));
                log.getDetalhes().add(detalhe);
            });
        }
        catch (Exception e) {
            String mensagemErro = String.format("%s%n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            log.setErro(mensagemErro);
            throw e;
        }
        finally {
            this.salvarIntegracaoBoletoPixPagoLog(log);
        }
    }

    private void salvarIntegracaoBoletoPixPagoLog(IntegracaoPixPagoLog integracaoPixPagoLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoPixPagoLog)this.integracaoPixPagoLogRepository.save((Object)integracaoPixPagoLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    private Bloqueto getBloqueto(SantanderPixPago pix, IntegracaoPixPagoDetalhe detalhe, Convenio convenio) {
        detalhe.setE2eid(pix.getEndToEndId());
        if (StringUtils.isNotBlank((String)pix.getTxid())) {
            detalhe.setTxid(pix.getTxid());
            detalhe.setBuscaPorE2E(Boolean.FALSE);
        } else {
            SantanderPixPago pagamentoByTxid = this.getPagamentoByTxid(pix.getEndToEndId(), convenio);
            Optional.ofNullable(pagamentoByTxid).ifPresent(pagamento -> {
                detalhe.setTxid(pagamento.getTxid());
                detalhe.setBuscaPorE2E(Boolean.FALSE);
            });
        }
        if (StringUtils.isBlank((String)detalhe.getTxid())) {
            detalhe.setObservacao("N\u00e3o foi possivel encontrar o Txid do pagamento Pix");
            return null;
        }
        Optional bloqueto = this.boletoService.findByTxid(detalhe.getTxid());
        if (bloqueto.isEmpty()) {
            detalhe.setObservacao("N\u00e3o foi possivel encontrar o boleto com o Txid informado");
            return null;
        }
        detalhe.setBoleto(((Bloqueto)bloqueto.get()).getBloqueto());
        detalhe.setExercicioboleto(((Bloqueto)bloqueto.get()).getExercicioBloqueto());
        detalhe.setEntidade(((Bloqueto)bloqueto.get()).getEntidade());
        return (Bloqueto)bloqueto.get();
    }

    private SantanderPixPago getPagamentoByTxid(String txid, Convenio convenio) {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.CONSULTA_PIX_E2E);
        try {
            integracaoBoletoPixLog.setTxid(txid);
            DadosIntegracaoOauth dadosOauth = this.getDadosIntegracaoOauth();
            DadosCertificadoDTO certificadoSantander = this.getDadosCertificado(convenio);
            String dataInicio = LocalDate.now().atStartOfDay().truncatedTo(ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + "Z";
            String dataFim = LocalDate.now().atStartOfDay().plusDays(1L).minusNanos(1L).truncatedTo(ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + "Z";
            String url = String.format("%s/pix?inicio=%s&fim=%s&txid=%s", this.getParametro(ParametroGeralEnum.BOLETO_SANTANDER_API_PIX_URL), dataInicio, dataFim, txid);
            String accessToken = this.getAccessToken(Banco.CODIGO_SANTANDER, IntegracaoTokenOperation.PIX, dadosOauth, certificadoSantander, this.authBodyBuilder(dadosOauth), TipoIntegracaoToken.DEFAULT.name());
            HttpHeaders headers = new HttpHeaders();
            headers.set("Authorization", String.format("Bearer %s", accessToken));
            HttpMethod httpMethod = HttpMethod.GET;
            integracaoBoletoPixLog.setJsonRequest(this.objectMapper.writeValueAsString((Object)new HttpEntity((MultiValueMap)headers)));
            integracaoBoletoPixLog.setUrlRequest(url);
            integracaoBoletoPixLog.setHttpMethod(httpMethod);
            JsonNode response = (JsonNode)this.getHttpClientTemplate(certificadoSantander).exchange(url, httpMethod, new HttpEntity((MultiValueMap)headers), JsonNode.class, new Object[0]).getBody();
            List listPix = SantanderPixPago.from((JsonNode)response, (ObjectMapper)this.objectMapper);
            if (listPix.isEmpty()) {
                SantanderPixPago santanderPixPago = null;
                return santanderPixPago;
            }
            SantanderPixPago santanderPixPago = (SantanderPixPago)listPix.get(0);
            return santanderPixPago;
        }
        catch (RestException e) {
            throw new RestException(e.getStatus(), e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new EloValidationException(e.getMessage());
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
        }
    }

    private DadosCertificadoDTO getDadosCertificado(Convenio convenio) {
        ParametroPix parametroPix = this.parametroPixRepository.getByEntidade(convenio.getEntidade());
        return Optional.ofNullable(parametroPix).map(ParametroPix::getCertificadoSantander).map(DadosCertificadoDTO::from).orElse(null);
    }

    private DadosIntegracaoOauth getDadosIntegracaoOauth() {
        String oauthUrl = this.getParametro(ParametroGeralEnum.BOLETO_SANTANDER_OAUTH_URL);
        String clienId = this.getParametro(ParametroGeralEnum.BOLETO_SANTANDER_CLIENTID);
        String clientSecret = this.getParametro(ParametroGeralEnum.BOLETO_SANTANDER_CLIENTSECRET);
        return DadosIntegracaoOauth.builder().oauthUrl(oauthUrl).clientId(clienId).clientSecret(clientSecret).build();
    }

    private LocalDate getDataReferencia(List<SantanderPixPago> santanderPixPagoS) {
        return santanderPixPagoS.stream().map(SantanderPixPago::getHorario).filter(Objects::nonNull).map(LocalDateTime::toLocalDate).min(Comparator.naturalOrder()).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel obter a data de refer\u00eancia dos pix pagos."));
    }

    public SolicitacaoPagamentoDTO solicitarArquivoPagamento(Convenio convenio, LocalDate dataReferencia) {
        throw new EloValidationException("Integra\u00e7\u00e3o para solicitar arquivo de pagamento para o banco Santander n\u00e3o implementada.");
    }

    public List<ImportacaoPixPagoResultadoDTO> importarSolicitacaoPagamento(Convenio convenio, LocalDate dataReferencia, Long codigoSolicitacao) {
        throw new EloValidationException("Integra\u00e7\u00e3o para importar arquivo de pagamento para o banco Santander n\u00e3o implementada.");
    }
}

