/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.cresol;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoCodigoBarras;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.domain.registroboletoonline.ErroBoletoRegistroOnline;
import br.com.elotech.tributos.dto.CodigoBarrasDTO;
import br.com.elotech.tributos.dto.integracaoboleto.cresol.EmissaoBoletoCresolDTO;
import br.com.elotech.tributos.dto.integracaoboleto.cresol.RetornoCresolDTO;
import br.com.elotech.tributos.enums.integracaoboleto.TipoIntegracaoBoletoPix;
import br.com.elotech.tributos.repository.BancoRepository;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.cnab240.ParametroCNAB240Repository;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoBoletoPixLogRepository;
import br.com.elotech.tributos.repository.registroboletoonline.ErroBoletoRegistradoOnlineRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoBoletoRegistrado;
import br.com.elotech.tributos.service.integracaoboleto.cresol.AutenticacaoCresolService;
import br.com.elotech.tributos.util.RestTemplateUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class IntegracaoBoletoCresolService
implements IntegracaoBoletoRegistrado {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoBoletoCresolService.class);
    private static final String BEARER = "Bearer %s";
    private static final String INTEGRACAO_CRESOL = "Integra\u00e7\u00e3o Cresol";
    private final ParametroGeralService parametroGeralService;
    private final AutenticacaoCresolService autenticacaoCresolService;
    private final ParametroCNAB240Repository parametroCNAB240Repository;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final BancoRepository bancoRepository;
    private final ErroBoletoRegistradoOnlineRepository erroBoletoRegistradoOnlineRepository;
    private final IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    private final ObjectMapper mapper;

    private String getUrlEmissaoCresol() {
        try {
            log.debug("{} - Buscando par\u00e2metro geral {}", (Object)INTEGRACAO_CRESOL, (Object)ParametroGeralEnum.URLAPICRESOL_REGISTRAR.name());
            String value = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.URLAPICRESOL_REGISTRAR, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            if (StringUtils.isEmpty((CharSequence)value)) {
                throw new EloValidationException(String.format("O par\u00e2metro %s n\u00e3o foi configurado.", ParametroGeralEnum.URLAPICRESOL_REGISTRAR.name()));
            }
            return value;
        }
        catch (ParametroNaoEncontradoException e) {
            log.error("{} - Erro ao buscar p\u00e2rmetro geral {}", (Object)INTEGRACAO_CRESOL, (Object)ParametroGeralEnum.URLAPICRESOL_REGISTRAR.name());
            throw new EloValidationException("N\u00e3o foi encontrado cadastro para o par\u00e2metro " + ParametroGeralEnum.URLAPICRESOL_REGISTRAR.name());
        }
    }

    private void saveIntegracaoBoletoPixLog(IntegracaoBoletoPixLog integracaoBoletoPixLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                log.debug("{} - Salvando log de integra\u00e7\u00e3o em INTEGRACAOBOLETOPIXLOG", (Object)INTEGRACAO_CRESOL);
                return (IntegracaoBoletoPixLog)this.integracaoBoletoPixLogRepository.save((Object)integracaoBoletoPixLog);
            }
            catch (Exception e) {
                log.error("{} - Erro ao salvar log de integra\u00e7\u00e3o em INTEGRACAOBOLETOPIXLOG - {}", new Object[]{INTEGRACAO_CRESOL, e.getMessage(), e});
                return null;
            }
        });
    }

    private void saveRespostaErro(HttpEntity<List<EmissaoBoletoCresolDTO>> request, String response, Bloqueto boleto, String observacao) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                log.debug("{} - Salvando log de integra\u00e7\u00e3o em TRIBERROREGISTROBOLETOONLINE", (Object)INTEGRACAO_CRESOL);
                ErroBoletoRegistroOnline erroRegistroBoletoOnlineEntity = new ErroBoletoRegistroOnline();
                erroRegistroBoletoOnlineEntity.setRequest(Objects.nonNull(request) ? this.mapper.writeValueAsBytes((Object)request) : null);
                erroRegistroBoletoOnlineEntity.setResponse((byte[])Optional.ofNullable(response).map(String::getBytes).orElse(null));
                erroRegistroBoletoOnlineEntity.setDataHoraIntegracao(LocalDateTime.now());
                erroRegistroBoletoOnlineEntity.setIdBoleto(boleto.getId());
                erroRegistroBoletoOnlineEntity.setDetalhes(observacao);
                return (ErroBoletoRegistroOnline)this.erroBoletoRegistradoOnlineRepository.save((Object)erroRegistroBoletoOnlineEntity);
            }
            catch (Exception e) {
                log.error("{} - Erro ao salvar log de integra\u00e7\u00e3o em TRIBERROREGISTROBOLETOONLINE - {}", new Object[]{INTEGRACAO_CRESOL, e.getMessage(), e});
                return null;
            }
        });
    }

    RestTemplate getRestTemplateSemCertificado() {
        return RestTemplateUtils.getRestTemplateSemCertificado();
    }

    public CodigoBarrasDTO generateBoleto(Bloqueto boleto, ParametroCNAB240 parametroCNAB240) {
        HttpEntity request = null;
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.GERA_BOLETO);
        integracaoBoletoPixLog.setBloqueto(boleto.getId());
        integracaoBoletoPixLog.setDataIntegracao(LocalDateTime.now());
        try {
            String accessToken = this.autenticacaoCresolService.getAccessToken();
            EmissaoBoletoCresolDTO emissaoBoletoCresolDTO = EmissaoBoletoCresolDTO.from((Bloqueto)boleto, (ParametroCNAB240)parametroCNAB240);
            HttpHeaders headers = new HttpHeaders();
            headers.set("Authorization", String.format(BEARER, accessToken));
            headers.setContentType(MediaType.APPLICATION_JSON);
            request = new HttpEntity(List.of(emissaoBoletoCresolDTO), (MultiValueMap)headers);
            String urlEmissao = this.getUrlEmissaoCresol();
            integracaoBoletoPixLog.setJsonRequest(this.mapper.writeValueAsString((Object)request));
            integracaoBoletoPixLog.setUrlRequest(urlEmissao);
            integracaoBoletoPixLog.setHttpMethod(HttpMethod.POST);
            JsonNode response = (JsonNode)this.getRestTemplateSemCertificado().postForEntity(urlEmissao, (Object)request, JsonNode.class, new Object[0]).getBody();
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)response));
            if (Objects.isNull(response) || response.isEmpty()) {
                throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, "N\u00e3o foi poss\u00edvel registrar o boleto. O retorno do Cresol est\u00e1 nulo ou vazio.");
            }
            List retornoCresolDTOS = (List)this.mapper.readValue(response.toString(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            CodigoBarrasDTO codigoBarrasDTO = new CodigoBarrasDTO();
            codigoBarrasDTO.setCodigoBarras(((RetornoCresolDTO)retornoCresolDTOS.get(0)).getCodigoBarras());
            String linhaDigitavelSemMascara = ((RetornoCresolDTO)retornoCresolDTOS.get(0)).getLinhaDigitavel().replaceAll("\\D", "");
            codigoBarrasDTO.setLinhaDigitavel(linhaDigitavelSemMascara);
            codigoBarrasDTO.setDvNossoNumero(((RetornoCresolDTO)retornoCresolDTOS.get(0)).getDvNossoNumero());
            codigoBarrasDTO.setCampo1(StringUtils.substring((String)linhaDigitavelSemMascara, (int)0, (int)10));
            codigoBarrasDTO.setCampo2(StringUtils.substring((String)linhaDigitavelSemMascara, (int)10, (int)21));
            codigoBarrasDTO.setCampo3(StringUtils.substring((String)linhaDigitavelSemMascara, (int)21, (int)32));
            codigoBarrasDTO.setCampo4(StringUtils.substring((String)linhaDigitavelSemMascara, (int)32, (int)33));
            codigoBarrasDTO.setCampo5(StringUtils.substring((String)linhaDigitavelSemMascara, (int)33, (int)47));
            codigoBarrasDTO.setNossoNumero(boleto.getNossoNumero());
            codigoBarrasDTO.generateCodigoBarrasFormatadoIntervalo2Of5();
            CodigoBarrasDTO codigoBarrasDTO2 = codigoBarrasDTO;
            return codigoBarrasDTO2;
        }
        catch (RestException re) {
            log.error("{} - Erro retornado pela API do banco Cresol", (Object)INTEGRACAO_CRESOL, (Object)re);
            String stackTrace = Arrays.stream(re.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
            this.saveRespostaErro(request, re.getMessage(), boleto, stackTrace);
            integracaoBoletoPixLog.setJsonResponse(re.getMessage());
            integracaoBoletoPixLog.setDescricaoErro(re.getMessage());
            throw new RestException(re.getStatus(), "Erro ao enviar o boleto registrado para a API do Cresol: " + re.getMessage(), (Throwable)re);
        }
        catch (Exception e) {
            log.error("{} - Erro interno ao integrar o boleto", (Object)INTEGRACAO_CRESOL, (Object)e);
            String stackTrace = Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
            this.saveRespostaErro(request, e.getMessage(), boleto, stackTrace);
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        finally {
            this.saveIntegracaoBoletoPixLog(integracaoBoletoPixLog);
        }
    }

    public ParametroCNAB240 getParametroCnab240ByBanco() {
        return (ParametroCNAB240)this.parametroCNAB240Repository.findFirstByBanco((Banco)this.bancoRepository.findOne((Object)Banco.CODIGO_CRESOL)).orElseThrow(() -> new EloValidationException("Par\u00e2metro CNAB 240 n\u00e3o encontrado para o banco CRESOL"));
    }

    public TipoCodigoBarras getTipoCodigoBarras() {
        return TipoCodigoBarras.BOLETO_BANCARIO_CRESOL;
    }

    public void beforeGenerateBoleto(Bloqueto boleto) {
        if (Objects.isNull(boleto.getExercicioBloqueto())) {
            throw new EloValidationException("\u00c9 necess\u00e1rio o exerc\u00edcio do bloqueto para gerar o nosso n\u00famero.");
        }
        Convenio convenio = Optional.of(boleto).map(Bloqueto::getModeloBloqueto).map(ModeloBoleto::getConvenio).orElseThrow(() -> new EloValidationException("\u00c9 necess\u00e1rio ter o modelo de boleto e o conv\u00eanio configurado para gerar o nosso n\u00famero"));
        if (Objects.isNull(convenio.getNumeroConvenio())) {
            throw new EloValidationException("O n\u00famero do conv\u00eanio \u00e9 obrigat\u00f3rio para gerar o nosso n\u00famero");
        }
        Long nossoNumero = this.sequenceGeneratorRepository.getNextVal("s05nossonumerocresol" + convenio.getNumeroConvenio());
        if (Objects.isNull(convenio.getNossoNumeroIniCresol()) || Objects.isNull(convenio.getNossoNumeroFimCresol())) {
            throw new EloValidationException("A faixa de intervalo para a sequ\u00eancia do NossoNumero n\u00e3o foi informada.\nVerifique a faixa da sequ\u00eancia do Cresol e ajuste em Conv\u00eanio.");
        }
        if (nossoNumero > convenio.getNossoNumeroFimCresol()) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel gerar o boleto!\nA sequ\u00eancia de NossoNumero do Cresol foi utilizada totalmente.\nSequ\u00eancia Atual: " + nossoNumero + ".\nSequ\u00eancia Final: " + convenio.getNossoNumeroFimCresol() + ".\nPor Favor entre em contato com o Cresol e solicite uma nova sequ\u00eancia.");
        }
        boleto.setNossoNumero(String.format("%011d", nossoNumero));
    }

    @Generated
    public IntegracaoBoletoCresolService(ParametroGeralService parametroGeralService, AutenticacaoCresolService autenticacaoCresolService, ParametroCNAB240Repository parametroCNAB240Repository, SequenceGeneratorRepository sequenceGeneratorRepository, BancoRepository bancoRepository, ErroBoletoRegistradoOnlineRepository erroBoletoRegistradoOnlineRepository, IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository, PlatformTransactionManager transactionManager, ObjectMapper mapper) {
        this.parametroGeralService = parametroGeralService;
        this.autenticacaoCresolService = autenticacaoCresolService;
        this.parametroCNAB240Repository = parametroCNAB240Repository;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.bancoRepository = bancoRepository;
        this.erroBoletoRegistradoOnlineRepository = erroBoletoRegistradoOnlineRepository;
        this.integracaoBoletoPixLogRepository = integracaoBoletoPixLogRepository;
        this.transactionManager = transactionManager;
        this.mapper = mapper;
    }
}

