/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.cresol;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoRefreshTokenService;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoTokenService;
import br.com.elotech.tributos.util.RestTemplateUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AutenticacaoCresolService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutenticacaoCresolService.class);
    private static final String AUTENTICACAO_CRESOL = "Autentica\u00e7\u00e3o Cresol";
    private final List<IntegracaoTokenService> integracaoTokenServices;
    private final List<IntegracaoRefreshTokenService> integracaoRefreshTokenServices;
    private final ParametroGeralService parametroGeralService;

    private String getParamValue(ParametroGeralEnum parametroGeral) {
        try {
            log.debug("{} - Buscando par\u00e2metro geral {}", (Object)AUTENTICACAO_CRESOL, (Object)parametroGeral.name());
            String value = this.parametroGeralService.getParamValueAsString(parametroGeral, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            if (StringUtils.isEmpty((CharSequence)value)) {
                throw new EloValidationException(String.format("O par\u00e2metro %s n\u00e3o foi configurado.", parametroGeral.name()));
            }
            return value;
        }
        catch (ParametroNaoEncontradoException e) {
            log.error("{} - Erro ao buscar p\u00e2rmetro geral {}", (Object)AUTENTICACAO_CRESOL, (Object)parametroGeral.name());
            throw new EloValidationException("N\u00e3o foi encontrado cadastro para o par\u00e2metro " + parametroGeral.name());
        }
    }

    private IntegracaoTokenService getTokenService() {
        return this.integracaoTokenServices.stream().filter(s -> s.accept("DEFAULT")).findFirst().orElseThrow(() -> new EloValidationException("N\u00e3o encontrado service para lidar com o tipo de token DEFAULT"));
    }

    private IntegracaoRefreshTokenService getRefreshTokenService() {
        return this.integracaoRefreshTokenServices.stream().filter(s -> s.accept("DEFAULT")).findFirst().orElseThrow(() -> new EloValidationException("N\u00e3o encontrado service para lidar com o tipo de token DEFAULT"));
    }

    private HttpEntity<MultiValueMap<String, String>> getRequest() {
        log.debug("{} - Criando requisi\u00e7\u00e3o para o token de autentica\u00e7\u00e3o", (Object)AUTENTICACAO_CRESOL);
        Optional refreshToken = this.getRefreshTokenService().getRefreshToken(Banco.CODIGO_CRESOL, IntegracaoTokenOperation.BOLETO);
        String clientId = this.getParamValue(ParametroGeralEnum.BOLETO_CRESOL_CLIENTID);
        String clientSecret = this.getParamValue(ParametroGeralEnum.BOLETO_CRESOL_CLIENTSECRET);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"scope", (Object)"read");
        map.add((Object)"client_id", (Object)clientId);
        map.add((Object)"client_secret", (Object)clientSecret);
        if (refreshToken.isPresent()) {
            log.debug("{} - Requisi\u00e7\u00e3o com grant_type para refresh_token", (Object)AUTENTICACAO_CRESOL);
            map.add((Object)"grant_type", (Object)"refresh_token");
            map.add((Object)"refresh_token", (Object)((String)refreshToken.get()));
        } else {
            log.debug("{} - Requisi\u00e7\u00e3o com grant_type para password", (Object)AUTENTICACAO_CRESOL);
            String username = this.getParamValue(ParametroGeralEnum.USUARIOCRESOL);
            String password = this.getParamValue(ParametroGeralEnum.SENHACRESOL);
            map.add((Object)"grant_type", (Object)"password");
            map.add((Object)"username", (Object)username);
            map.add((Object)"password", (Object)password);
        }
        log.debug("{} - Requisi\u00e7\u00e3o criada", (Object)AUTENTICACAO_CRESOL);
        return new HttpEntity((Object)map, (MultiValueMap)headers);
    }

    private JsonNode generateOrRefreshAccessToken() {
        String url = this.getParamValue(ParametroGeralEnum.URLTOKENCRESOL);
        HttpEntity httpEntity = this.getRequest();
        log.debug("{} - Realizando POST para obter o token de autentica\u00e7\u00e3o", (Object)AUTENTICACAO_CRESOL);
        JsonNode response = (JsonNode)this.getRestTemplateSemCertificado().postForEntity(url, (Object)httpEntity, JsonNode.class, new Object[0]).getBody();
        if (Objects.isNull(response) || !response.has("access_token")) {
            throw new RestException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel buscar o token. A resposta do banco Cresol est\u00e1 vazia ou n\u00e3o contem o access_token.");
        }
        return response;
    }

    RestTemplate getRestTemplateSemCertificado() {
        return RestTemplateUtils.getRestTemplateSemCertificado();
    }

    public String getAccessToken() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        IntegracaoTokenService tokenService = this.getTokenService();
        Optional accessToken = tokenService.getAccessToken(Banco.CODIGO_CRESOL, IntegracaoTokenOperation.BOLETO);
        if (accessToken.isPresent()) {
            log.debug("{} - Retornando token existente no banco de dados", (Object)AUTENTICACAO_CRESOL);
            return (String)accessToken.get();
        }
        IntegracaoRefreshTokenService refreshTokenService = this.getRefreshTokenService();
        JsonNode response = this.generateOrRefreshAccessToken();
        return refreshTokenService.saveIntegracaoWithRefreshToken(Banco.CODIGO_CRESOL, IntegracaoTokenOperation.BOLETO, response);
    }

    @Generated
    public AutenticacaoCresolService(List<IntegracaoTokenService> integracaoTokenServices, List<IntegracaoRefreshTokenService> integracaoRefreshTokenServices, ParametroGeralService parametroGeralService) {
        this.integracaoTokenServices = integracaoTokenServices;
        this.integracaoRefreshTokenServices = integracaoRefreshTokenServices;
        this.parametroGeralService = parametroGeralService;
    }
}

