/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.bancodobrasil;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.CertificadoBBDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.ParticipanteBBPayDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.ParticipanteBBPayRequestDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.ParticipanteResponseDTO;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import br.com.elotech.tributos.service.integracaoboleto.bancodobrasil.BbUtilsService;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ParticipanteBBPayService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ParticipanteBBPayService.class);
    private final ObjectMapper mapper;
    private final BbUtilsService bbUtilsService;
    private static final String URL_BBPAY_PARTICIPANTES = "participantes";

    public ParticipanteResponseDTO criarParticipante(ParticipanteBBPayDTO participanteBBPayDTO) {
        CertificadoBBDTO certificadoBBDTO = this.bbUtilsService.buscarCertificadoBB();
        Convenio convenio = this.bbUtilsService.getConvenio(participanteBBPayDTO.getIdConvenio());
        try {
            log.info("Iniciando processo de cria\u00e7\u00e3o do participante: {}", (Object)participanteBBPayDTO.getNomeParticipante());
            ParticipanteBBPayRequestDTO participanteDTO = ParticipanteBBPayRequestDTO.from((ParticipanteBBPayDTO)participanteBBPayDTO, (Convenio)convenio);
            String urlParticipantes = this.montarUrlParticipantes(participanteBBPayDTO, convenio.getNumeroConvenio());
            JsonNode responseParticipante = this.bbUtilsService.executarRequisicaoBB(HttpMethod.POST, urlParticipantes, (Object)participanteDTO, certificadoBBDTO, IntegracaoTokenOperation.BOLETO_HIBRIDO);
            log.info("Participante criado com sucesso: {}");
            return (ParticipanteResponseDTO)this.mapper.treeToValue((TreeNode)responseParticipante, ParticipanteResponseDTO.class);
        }
        catch (RestException e) {
            String descricaoErros = this.bbUtilsService.tratarErrosBBPay(e);
            log.error("Erro ao tentar criar participante na API do BBPAY: {}", (Object)descricaoErros);
            throw new RestException(e.getStatus(), "Erro ao processar participante na API do BBPAY. Detalhes: " + descricaoErros, (Throwable)e);
        }
        catch (Exception e) {
            log.error("Erro inesperado ao processar participante BBPay: {}", (Object)participanteBBPayDTO.getNomeParticipante(), (Object)e);
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    public ResponseEntity atualizarParticipante(ParticipanteBBPayDTO participanteBBPayDTO) {
        CertificadoBBDTO certificadoBBDTO = this.bbUtilsService.buscarCertificadoBB();
        Convenio convenio = this.bbUtilsService.getConvenio(participanteBBPayDTO.getIdConvenio());
        try {
            ParticipanteBBPayRequestDTO participanteDTO = ParticipanteBBPayRequestDTO.from((ParticipanteBBPayDTO)participanteBBPayDTO, (Convenio)convenio);
            if (!Objects.nonNull(participanteBBPayDTO.getIdParticipante())) {
                throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, "Parametro Id do participante n\u00e3o informado.");
            }
            String urlParticipantes = this.montarUrlParticipantes(participanteBBPayDTO, convenio.getNumeroConvenio());
            log.info("Iniciando a atualiza\u00e7\u00e3o do participante: {}", (Object)participanteBBPayDTO.getNomeParticipante());
            this.bbUtilsService.executarRequisicaoBB(HttpMethod.PUT, urlParticipantes, (Object)participanteDTO, certificadoBBDTO, IntegracaoTokenOperation.BOLETO_HIBRIDO);
            log.info("Participante atualizado com sucesso: {}", (Object)participanteBBPayDTO.getNomeParticipante());
            return ResponseEntity.noContent().build();
        }
        catch (RestException e) {
            String descricaoErros = this.bbUtilsService.tratarErrosBBPay(e);
            log.error("Erro ao tentar atualizar o participante na API do BBPAY: {}", (Object)participanteBBPayDTO.getIdParticipante(), (Object)descricaoErros);
            throw new RestException(e.getStatus(), "Erro ao processar participante na API do BBPAY. Detalhes: " + descricaoErros, (Throwable)e);
        }
        catch (Exception e) {
            log.error("Erro inesperado ao atualizar o participante BBPay: {}", (Object)participanteBBPayDTO.getNomeParticipante(), (Object)e);
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    private String montarUrlParticipantes(ParticipanteBBPayDTO participanteBBPayDTO, String numeroConvenio) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (participanteBBPayDTO.getIdParticipante() != null) {
            queryMap.put("numeroConvenio", numeroConvenio);
            return this.bbUtilsService.montarUrlBbPay("participantes/" + participanteBBPayDTO.getIdParticipante(), queryMap);
        }
        return this.bbUtilsService.montarUrlBbPay(URL_BBPAY_PARTICIPANTES, queryMap);
    }

    @Generated
    public ParticipanteBBPayService(ObjectMapper mapper, BbUtilsService bbUtilsService) {
        this.mapper = mapper;
        this.bbUtilsService = bbUtilsService;
    }
}

